package suffix_tree;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import indexstructure.EdgeInfo;
import indexstructure.IndexStructure;
//import indexstructure.IndexStructure.RelTypes;
//import indexstructure.Neo4J_Handler;
import indexstructure.Node;
import util.Util;

public class Ukkonen_Suffixtree extends IndexStructure {

	ActivePoint ap;

	public Node root, suffixstate, split, leaf;

	public ArrayList<Node> all_nodes;

	int id_cnt;
	int split_cnt = 0;

	public String input_text;
	boolean letters_available;

	int stringcount;

	int pos = 0;
	int remainder = 0;

	boolean print = false;
	public ArrayList<String> stringset = new ArrayList();

	public Ukkonen_Suffixtree(ArrayList<String> _stringset, boolean print) {

		super();

		id_cnt = 0;
		stringset = _stringset;
		input_text = "";
		letters_available = true;

		this.print = print;

		all_nodes = new ArrayList();

	} // Ukkonen_Suffixtree()

	public void build_suffixtree() {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..building suffix tree ");

		// 1. Create a state named root
		root = create_node(-1, 0, 0, 0);

		ap = new ActivePoint(root, -1, 0);

		stringcount = 0;

		while (stringcount < stringset.size()) {

			ap = new ActivePoint(root, -1, 0);

			input_text = stringset.get(stringcount);
			// cout << input_text << endl;

			pos = -1;

			// 2. For each letter a of w do:

			letters_available = true;
			while (letters_available) {

				update();
				if (pos >= input_text.length() - 1)
					letters_available = false;
			} // letters_available

			stringcount++;
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds");
		System.out.println(
				" ... memory used:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory free:" + (Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory total:" + (Runtime.getRuntime().totalMemory()));

	}

	boolean canonize(Node node, int pos) {
		int edgelength = this.get_edge_length(ap.active_edge, ap.active_node,
				ap.active_node.children.get(ap.active_edge));
		if (ap.active_length >= edgelength) {

			if (print)
				System.out.println("CANONIZE");
			ap.active_length -= edgelength;

			int next_pos = pos - ap.active_length;

			if (ap.active_length > 0) {

				ap.active_edge = this.get_letter(next_pos, stringcount);
			}

			ap.active_node = node;

			return true;
		}
		return false;
	}

	private void add_suffixlink(Node node) {
		if (suffixstate != null)
			suffixstate.suffixLink = node;
		suffixstate = node;
	}

	// *******************************************************************************
	// update()
	// *******************************************************************************
	private void update() {
		pos++;
		int a = get_letter(pos, stringcount);
		suffixstate = null;
		split = null;
		Node active_child = null;

		while (true) {

			if (ap.active_length == 0)
				ap.active_edge = a;

			if (print)
				System.out.println(" pos: " + pos + " " + input_text.charAt(pos) + " (active_node: " + ap.active_node.id
						+ " <" + this.get_node_label(ap.active_node) + "> active_edge: " + ap.active_edge + " ["
						+ this.get_letter_by_idx(ap.active_edge) + "] active length: " + ap.active_length + ")");

			if (!(has_outgoing_edge(ap.active_node, ap.active_edge))) { // if no edge with label of active edge from
																		// active point

				int new_leaf_start = stringset.get(stringcount)
						.indexOf(this.get_node_label(ap.active_node) + this.get_letter_by_idx(a));

				leaf = create_node(new_leaf_start, stringset.get(stringcount).length() - 1,
						ap.active_node.pathlength + (stringset.get(stringcount).length() - pos), stringcount); // create
																												// new
				if (print)
					System.out.println(this.get_node_label(leaf) + " id leaf" + leaf.id);
				// leaf

				create_edge(ap.active_node, leaf, ap.active_edge, pos);  // create new edge from active_node to new_leaf
				add_suffixlink(ap.active_node); // rule 2

			}

			else {
				Node next = ap.active_node.children.get(ap.active_edge);
				// System.out.println(this.get_node_label(next));
				if (canonize(next, pos))
					continue; // observation 2

				String current_letter = get_letter_by_idx(a);


				
				int active_label_length = this.get_edge_length(ap.active_edge, ap.active_node, next);

				int last_char_pos = next.end + 1 - active_label_length + ap.active_length;
				Character last_suffix_c = stringset.get(next.stringnr).charAt(last_char_pos);
				String last_suffix = last_suffix_c.toString();
				
				if (last_suffix.equals(current_letter)) {// observation 1
					ap.active_length++;
					add_suffixlink(ap.active_node); // observation 3
					break;
				}

				if (active_child == ap.active_node.children.get(ap.active_edge)) {

					redirect_edge(ap.active_node, split, ap.active_edge);

				} else {

					if (print)
						System.out.println("SPLIT");

					active_child = ap.active_node.children.get(ap.active_edge);

					int stringnr = next.stringnr;

					int end_node = ap.active_node.children_new.get(ap.active_edge).pos + ap.active_length - 1;
					int start_node = end_node - this.get_node_length(ap.active_node) + 1 - ap.active_length;

					int start = end_node + 1;

					
					split = create_node(start_node,start_node + ap.active_node.pathlength + ap.active_length - 1,
							ap.active_node.pathlength + ap.active_length, stringnr);

					if (print)
						System.out.println(this.get_node_label(split) + " id split" + split.id);

					int new_leaf_start = stringset.get(stringcount)
							.indexOf(this.get_node_label(split) + this.get_letter_by_idx(a));

					leaf = create_node(new_leaf_start, stringset.get(stringcount).length() - 1,
							split.pathlength + (stringset.get(stringcount).length() - pos), stringcount);

					if (print)
						System.out.println(this.get_node_label(leaf) + " id leaf" + leaf.id);

					redirect_edge(ap.active_node, split, ap.active_edge);  // create edge from active_node to split

					create_edge(split, leaf, a, pos); // create edge from split to leaf


					create_edge(split, next, this.get_letter(last_char_pos, next.stringnr), start); // create

					if (print)
						System.out.println("NEXT " + this.get_letter(last_char_pos, next.stringnr));
					// to next

					// next.start = split.start;

					add_suffixlink(split); // rule 2
				}

			}

			if (ap.active_node == root && ap.active_length > 0) { // rule 1
				ap.active_edge = get_letter(pos - ap.active_length + 1, stringcount); // find the next shortest suffix
																						// (e.g.

				ap.active_length--;
				// after root ->
				// ab ; root -> b)
			} else {
				if (ap.active_node.suffixLink != null) { // rule 3
					if (print)
						System.out.println("RULE 3");
					ap.active_node = ap.active_node.suffixLink;
				} else {
					ap.active_node = root;
					if (print)
						System.out.println("AP -> ROOT");

					break;
				}
			}

		}

		if (print)
			System.out.println(
					"-----------------------------------------------------------------------------------------");

	}

	// *******************************************************************************
	// get_edge_length()
	// *******************************************************************************

	public int get_edge_length(int letter_idx, Node parent, Node node) {

		try {
			EdgeInfo edge_info = parent.children_new.get(letter_idx);
			int start = edge_info.pos;

			if (print)
				System.out.println("START NEW " + start + " node end " + node.end);

			return node.end - start + 1;

		} catch (Exception e) {
			return -2;
		}

	} // get_edge_length_new()

	// *******************************************************************************
	// get_letter()
	// *******************************************************************************

	int get_letter(int pos, int stringnr) {
		Character letter = stringset.get(stringnr).charAt(pos);
		return utf8_sequence_map.get(letter.toString());
	}


	// *******************************************************************************
	// get_node_length()
	// *******************************************************************************

	public int get_node_length(Node node) {

		return node.pathlength;

	} // get_node_label()

	// *******************************************************************************
	// get_node_label()
	// *******************************************************************************

	public String get_node_label(Node node) {

		String result;
	

		try {

			if (node == root)
				return "";

			else {
				return stringset.get(node.stringnr).substring(node.start, node.end + 1);
			}

		} catch (Exception e) {
			e.printStackTrace();
			return "X";
		}

	} // get_node_label()

	// *******************************************************************************
	// get_edge_label()
	// *******************************************************************************

	public String get_edge_label(int letter_idx, Node parent, Node node) {

		String rep_parent = get_node_label(parent);
		String rep_child = get_node_label(node);
		if (rep_parent.equals("λ"))
			rep_parent = "";

		String letter = this.get_letter_by_idx(letter_idx);
		// System.out.println("rep_parent: "+rep_parent+" rep_child: "+rep_child+"letter "+letter+" node_id "+node.id+ " node start "+node.start);

		try {

			int start = rep_child.indexOf(rep_parent + letter);

			return rep_child.substring(start + rep_parent.length(), rep_child.length());

		} catch (Exception e) {
			return "X";
		}

	} // get_edge_label()

	// *******************************************************************************
	// get_equivalence_classes_()
	// *******************************************************************************

	public Multimap<Integer, Integer> get_equivalence_classes(Node node) {
		Multimap<Integer, Integer> result = ArrayListMultimap.create();
		Multimap<Integer, Integer> node_end_positions = node.end_positions;

		Iterator it = node_end_positions.entries().iterator();
		while (it.hasNext()) {
			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			if (pair.getValue() != -1)
				result.put(pair.getKey(), pair.getValue());

		}

		for (int i = 1; i < all_nodes.size(); i++) {

			if (hasConnectionViaSuffixLinks(all_nodes.get(i).suffixLink, node)) {
				node_end_positions = all_nodes.get(i).end_positions;

				it = node_end_positions.entries().iterator();
				while (it.hasNext()) {
					Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
					result.put(pair.getKey(), pair.getValue());

				}

			}

		}

		return result;

	} // get_equivalence_classes()

	// *******************************************************************************
	// equivalence_classes_to_strings()
	// *******************************************************************************

	public ArrayList equivalence_classes_to_strings(Multimap<Integer, Integer> eq) {

		ArrayList result = new ArrayList();

		Iterator it = eq.entries().iterator();

		StringBuilder s1 = new StringBuilder();
		StringBuilder s2 = new StringBuilder();

		int cnt = 0;

		String d = ",";

		while (it.hasNext()) {

			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			// System.out.println(pair.getKey()+ " " + pair.getValue());
			if (pair.getKey() == 1) {
				s1.append(pair.getValue());
				s1.append(d);
			}
			if (pair.getKey() == 2) {
				s2.append(pair.getValue());
				s2.append(d);
			}

		}

		String eqs1 = s1.toString();
		String eqs2 = s2.toString();

		if (eqs1.length() > 0)
			eqs1 = eqs1.substring(0, eqs1.length() - 1);
		if (eqs2.length() > 0)
			eqs2 = eqs2.substring(0, eqs2.length() - 1);

		result.add(eqs1);
		result.add(eqs2);

		// string result =""; string d="";

		// stringstream node_sstr;

		// for (int i=0;i<eq.size();i++){
		// node_sstr << d << eq.at(i); d=",";
		// }
		// result = node_sstr.str();

		return result;

	} // equivalence_classes_to_strings()

	private boolean hasConnectionViaSuffixLinks(Node parentTW, Node node) {
		if (parentTW == node)
			return true;
		if (parentTW == root)
			return false;

		return hasConnectionViaSuffixLinks(parentTW.suffixLink, node);

	}

	private boolean has_outgoing_edge(Node node, int label) {
		Node n = node.children.get(label);
		if (n == null)
			return false;
		return true;
	}

	private Node get_state_of_outgoing_edge(Node node, int label) {
		return node.children.get(label);
	}

	// *******************************************************************************
	// get_letter_by_idx()
	// *******************************************************************************

	public String get_letter_by_idx(int idx) {
		String result = "";
		Iterator it = utf8_sequence_map.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();

			if ((int) pair.getValue() == idx) {
				result = (String) pair.getKey();
				break;
			}
		}

		return result;
	}

	public Node get_parent(Node node) {
		return node.suffixLink;
	} // get_parent()

	public void save_graph_to_db() {

		long startTime = System.currentTimeMillis();
		System.out.println("\n ..saving graph to database ");

		// Neo4J_Handler neo4j = new Neo4J_Handler("C:/Neo4j/Neo4jUkkonenDB_test",this);
		//
		// neo4j.connect_and_clear_graphDb();
		// neo4j.create_node_db(root);
		//
		// neo4j.link_children_db(root);
		// neo4j.link_suffixes_db(root);

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds \n");

	}

	// *******************************************************************************
	// create_node()
	// *******************************************************************************

	private Node create_node(int start, int end, int pathlength, int stringnr) {

		// if(pos==-2) node = new Node();
		Node node = new Node(start, end, pathlength, stringnr, id_cnt++);

		// Iterator it = utf8_sequence_map.entrySet().iterator();
		// while (it.hasNext()) {
		// Map.Entry pair = (Map.Entry)it.next();
		//
		// node.children.put((Integer) pair.getValue(),null);
		// }

		all_nodes.add(node);
		return node;
	}

	// private void create_node_db(Node node){
	//
	// try (Transaction tx = db.beginTx()) {
	//
	// org.neo4j.graphdb.Node db_node = db.createNode(Label.label(id_cnt+""));
	// db_node.setProperty("start", node.start);
	// db_node.setProperty("end", node.end);
	// db_node.setProperty("name", this.get_longest_member(node) );
	//
	// tx.success();
	// node.dB_Node = db_node;
	//
	// }
	//
	// }

	// *******************************************************************************
	// create_edge()
	// *******************************************************************************

	public void create_edge(Node parent, Node child, int label, int pos) {

		parent.children.put(label, child);
		parent.children_new.put(label, new EdgeInfo(child, pos));

	} // create_edge()

	// *******************************************************************************
	// redirect_edge()
	// *******************************************************************************

	void redirect_edge(Node start, Node target, int edge) {

		start.children.put(edge, target);

		/// ** # # # ** ## ** #'**** ##** NEU NEU

		// KEY BLEIBT BUCHTSTABE dann Object Edge mit Position und Zielknoten.
	}

	public void print_tree(String outputfile) {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..printing suffix tree ");

		String filename = outputfile+"_stree.dot";

		StringBuilder sb = new StringBuilder();

		// dotfile
		sb.append("digraph stree_graph {");
		sb.append("\n" + "labeljust=l");
		sb.append("\n" + "fontname=Vera");
		sb.append("\n" + "fontsize=20");
		sb.append("\n" + "labelloc=top");
		sb.append("\n" + "margin=.5");
		sb.append("\n" + "size=\"15,7\"");
		sb.append("\n" + "nodesep=.3");
		sb.append("\n"
				+ "node [width=0.5,height=auto,shape=record,fontsize=12,fontcolor=black,style=filled,fillcolor=sandybrown];");
		sb.append("\n" + "edge [minlen=1,constraint=true,fontsize=11,labelfontsize=11];");

		sb.append("\n");
		sb.append("\n");

		//
		String edge_list = "", node_list = "";
		// cout << endl << " Nodes" << endl << " -----" << endl;
		sb.append("/* Nodes */ \n \n");
		//
		String nodeslist = print_nodes_rec(root);
		sb.append(nodeslist);
		// cout << endl << " Edges" << endl << " -----" << endl;
		sb.append("\n /* Edges */ \n \n");
		// print_edges(root,edge_list);
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		Util.writeFile(filename, result);

		String[] cmd = { "cmd.exe", "/c", "dot -Tsvg "+outputfile+ "_stree.dot -o " + outputfile + "_Stree.svg" };

		try {

			Process p = Runtime.getRuntime().exec(cmd);

			BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));

			String temp = "";

			while ((temp = input.readLine()) != null)
				System.out.println(temp);

			input.close();

		} catch (IOException e) {
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds");

	} // print_automaton()

	public String get_dot() {

		long startTime = System.currentTimeMillis();

		StringBuilder sb = new StringBuilder();

		//
		String edge_list = "", node_list = "";
		// cout << endl << " Nodes" << endl << " -----" << endl;
		//
		String nodeslist = print_nodes_rec(root);
		sb.append(nodeslist);
		// cout << endl << " Edges" << endl << " -----" << endl;
		// print_edges(root,edge_list);
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		return result;

	} // get_dot()

	// *******************************************************************************
	// print_nodes()
	// *******************************************************************************
	String print_nodes() {

		String result = "";

		String node_str;
		StringBuilder node_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);

			int node_number;
			if (node.end == -1)
				node_number = node.end + 1;
			else
				node_number = node.end;

			node_sstr.append(" n_" + node.id + "_" + node_number + " ");

			Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

			//
			ArrayList eq_strings_map = equivalence_classes_to_strings(equivalence_classes);
			//

			//
			String rep = get_longest_member(node);

			// cout << " rep: " << rep << endl;
			// cout << " pathlength " << node->pathlength << endl;
			// cout << "-------------" << endl;
			//
			//// cout << node_str << " [label=" << node->end << " id=" << node->id << "
			// pathlength=" << node->pathlength << "];" << endl;
			node_sstr.append("[label=< id=" + node.id + "<br/> \"" + rep + "\"<br/>>");
			//
			//
			//

			for (int i = 0; i < eq_strings_map.size(); i++) {
				node_sstr.append("s" + (i + 1) + ":" + eq_strings_map.get(i));
				if (i == 0)
					node_sstr.append("<br/>");
				else
					node_sstr.append("<br/>>");
			}
			node_sstr.append("]; \n");

		}

		result = node_sstr.toString();

		return result;

	} // print_nodes()

	// *******************************************************************************
	// print_nodes_rec()
	// *******************************************************************************
	String print_nodes_rec(Node node) {

		String result = "";

		StringBuilder node_sstr = new StringBuilder();

		String node_str = "";

		int node_number;
		if (node.end == -1)
			node_number = node.end + 1;
		else
			node_number = node.end;

		node_sstr.append(" n_" + node.id + "_" + node_number + " ");

		String rep = "";
		if (node != root)
			rep = this.get_node_label(node);
		else
			rep = "λ";

		// node_sstr.append("[label=< id=" + node.id + "<br/> \"" + rep + "\"<br/>>");
		node_sstr.append("[label=<\"" + rep + "\">");
		node_sstr.append("]; \n");

		StringBuilder childlevel = new StringBuilder();
		childlevel.append("{ rank= same; ");

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();

			Node child = (Node) pair.getValue();
			int i = (int) pair.getKey();

			String child_node_str = print_nodes_rec(child);
			node_sstr.append(child_node_str);

			int node_number_end;
			if (node.children.get(i).end == -1)
				node_number_end = 0;
			else
				node_number_end = node.children.get(i).end;

			childlevel.append(" n_" + node.children.get(i).id + "_" + node_number_end + "; ");

		}

		childlevel.append("}");

		node_sstr.append(childlevel.toString() + "\n");

		result = node_sstr.toString();

		return result;

	} // print_nodes_rec()

	// *******************************************************************************
	// print_edges()
	// *******************************************************************************
	public String print_edges() {

		String result = "";
		StringBuilder edge_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);
			// if (node->ident_pointers.size()>0||node==root) {
			int label_count = 0;

			Iterator it = node.children.entrySet().iterator();
			while (it.hasNext()) {

				Map.Entry pair = (Map.Entry) it.next();

				int i = (int) pair.getKey();

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.children.get(i).end == -1)
					node_number_end = 0;
				else
					node_number_end = node.children.get(i).end;

				edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" + node.children.get(i).id + "_"
						+ node_number_end + " ");

				String label = "";
				label = this.get_edge_label(i, node, node.children.get(i));

				String regex = "\\\"";

				edge_sstr.append(" [style=" + "solid" + "  label=\"" + label + "\"];" + "\n");

			} // for it node children

			Node suffixLink = node.suffixLink;

			if (suffixLink != null) {

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.suffixLink.end == -1)
					node_number_end = node.suffixLink.end + 1;
				else
					node_number_end = node.suffixLink.end;

				 edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" +
				 node.suffixLink.id + "_"
				 + node_number_end + " ");
				 edge_sstr.append(" [color=red];\n");

			}

			// edge_list+= edge_str;
			label_count++;

			// if (node.prefixLinks.size()>0)
			// {
			//
			// for (int k=0;k<node->prefixLinks.size();k++){
			// string edge_str;
			// stringstream edge_sstr;
			//
			// int node_number;
			// if (node->end==-1) node_number=node->end+1;
			// else node_number = node->end;
			//
			// int node_number_end;
			// if (node->prefixLinks[k]->end==-1)
			// node_number_end=node->prefixLinks[k]->end+1;
			// else node_number_end = node->prefixLinks[k]->end;
			//
			// edge_sstr << " n_" << node->id << "_" << node_number << " -> n_" <<
			// node->prefixLinks[k]->id << "_" << node_number_end << " ";
			// edge_str = edge_sstr.str();
			//
			// string label = node->prefixlabels[k];
			// string regex = "\\\"";
			// label = ReplaceAll(label,std::string("\""), std::string(regex));
			// // if ( edge_list.find(edge_str) != string::npos ) return;
			// // cout << edge_str << " ["<< "prefix_link label=" << node->prefixlabels[k]
			// << "];" << endl;
			// dotfile << edge_str << " [color=blue label=\"" << label << "\"];" << endl;
			// edge_list+= edge_str;
			//
			// }
			// }

			// }
		} // for all nodes

		result = edge_sstr.toString();

		return result;

	} // print_edges()

	public String[] getTopNNodes() {
		int n = 10;
		
		ArrayList<String> node_reps_list = new ArrayList<String>();
		
		String[] node_reps = new String[this.all_nodes.size()];

		for (int i=0;i<this.all_nodes.size();i++) {
			node_reps[i] = this.get_node_label(this.all_nodes.get(i));
		}
		
		
//		this.eachNode_DFS(this.root, false, false, new IndexStructure.Visitor() {
//		 public void visit(Node n){
//			node_reps_list.add(this.get_node_label(n));
//		 }
//		 });
//		
//		
//		String[] node_reps = new String[node_reps_list.size()];
//		
//		for(int i=0;i<node_reps_list.size();i++) {
//			node_reps[i] = node_reps_list.get(i);
//		}
		
		Arrays.sort(node_reps, (b, a)->Integer.compare(a.length(), b.length()));

		
		for (int i=0;i<node_reps.length;i++) {
			System.out.println(node_reps[i]);
		}
		String [] result = new String[n];
		
		
		return result;
		
	}
	
}
