package cdawg_sym;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.Stack;

import com.sun.tools.javac.util.Pair;

import alignment_offline.Endpos_Pair;
import alignment_offline.Endpos_Tupel;
import alignment_offline.Related_Node_Info;
import indexstructure.EdgeInfo;
import indexstructure.Node;
import util.Util;

/**
 * @author Tobias Englmeier (CIS)
 */

public class Common_SCDAWG_Functions {

    Online_CDAWG_sym scdawg = null;

    public Common_SCDAWG_Functions(Online_CDAWG_sym scdawg) {
	this.scdawg = scdawg;
    }
    
    /*********************************************************************************
     * find()
     * 
     * finds longst prefix x
     * from one node are followed recursively
     * 
     * @return
     **********************************************************************************/
    
    public String find(String q,Node v) {
    	if(q.equals("")) return "";

    	String x = "";
    	Character letter = q.charAt(0);
    	String letterstring = letter.toString();
    	Integer q1 = scdawg.utf8_sequence_map.get(letterstring);
    	EdgeInfo e = v.children_new.get(q1);

    	if(e == null){
    		return x;
    	}
    	
    	int i = e.child.stringnr;
    	
    	int j = 0; int h = 0;
    	
    	String edgelabel = scdawg.get_edge_label(q1, v, e.child);
    	
    	while (j < edgelabel.length() && h < q.length()){
    		
    		Character h_letter = q.charAt(h);
    		String h_letterstring = h_letter.toString();
    		Character e_letter = edgelabel.charAt(j);
    		String e_letterstring  = e_letter.toString();
    		

    		if(e_letterstring.equals(h_letterstring)) {
    			x += e_letterstring;
    		}
    		else {
    			return x;
    		}
    		j++;h++;
    	}
    	return x + find(q.substring(h, q.length()),e.child);
    }
    
    /*********************************************************************************
     * find_node()
     * 
     * finds longest matching node x
     * from one node are followed recursively
     * 
     * @return
     **********************************************************************************/
    
    public Pair<Node,Integer> find_node(String q,Node v,int pathlength) {
//    	System.out.println("START");
    	if(q.equals("")) return new Pair(v,pathlength);

    	Character letter = q.charAt(0);
    	String letterstring = letter.toString();
    	Integer q1 = scdawg.utf8_sequence_map.get(letterstring);
    	EdgeInfo e = v.children_new.get(q1);

    	if(e == null){
    		return null;
    	}
    	
    	
    	int i = e.child.stringnr;
    	
    	int j = 0; int h = 0;
    	
    	String edgelabel = scdawg.get_edge_label(q1, v, e.child);
//    	System.out.println(edgelabel);

		pathlength+=edgelabel.length();

    	int matchcount = 0;
    	while (j < edgelabel.length() && h < q.length()){
    		
    		Character h_letter = q.charAt(h);
    		String h_letterstring = h_letter.toString();
    		Character e_letter = edgelabel.charAt(j);
    		String e_letterstring  = e_letter.toString();
    		
//    		System.out.println(h_letterstring+" "+e_letterstring);

    		if(e_letterstring.equals(h_letterstring)) {
    			matchcount++;
    		}
    		else {
    			return null;
    		}
    		j++;h++;
    	}
    	
    	
    	
    	
    	if(q.length()-matchcount==0) {
//    		if(matchcount==edgelabel.length()) {
    			return new Pair(e.child,pathlength);
//    		}
//    		else {
//    			return new Pair(e.child,pathlength);
//    		}

    	}
  
            	
    	else {
        	return find_node(q.substring(matchcount, q.length()),e.child,pathlength);
    	}
    }
    
    /*********************************************************************************
     * locations()
     * 
     * finds int, int pairs of locations
     * from one node are followed recursively
     * @return 
     * 
     * @return
     **********************************************************************************/
    
    public ArrayList<Pair> locations(Node v,int pathlength) {
    	ArrayList<Pair> result = new ArrayList();

    	if(v.is_endNode) {
    		result.add(new Pair(v.stringnr,v.end-pathlength+1));
    	}
    	   		    	
    	    
    	    	Iterator it = v.children.entrySet().iterator();

    			while (it.hasNext()) {

    			    Map.Entry pair = (Map.Entry) it.next();
    			    Node child = (Node) pair.getValue();
    			    if (scdawg.sinks.contains(child)) {
    			    	
    			    	
    			    	Pair p = new Pair(child.stringnr,child.end-pathlength-scdawg.get_edge_length((int) pair.getKey(), v, child)+1);
    			    	result.add(p);
    			    }
    			    else {
    			    	result.addAll(locations(child,pathlength+scdawg.get_edge_length((int) pair.getKey(), v, child)));
    			    }
    			}
    	    	
    			if(v.children.isEmpty()) {
    	    
    			
    			Iterator it2 = v.children_left.entrySet().iterator();

    			while (it2.hasNext()) {

    			    Map.Entry pair = (Map.Entry) it2.next();
    			    Node child = (Node) pair.getValue();
    			    if (scdawg.sinks.contains(child)) {
    			    	
    			    	
    			    	Pair p = new Pair(child.stringnr,child.end-pathlength+1);
    			    	result.add(p);
    			    }
    			    else {
    			    	result.addAll(locations(child,pathlength));
    			    }
    			}
    	
    			}
    	  
		
    	
    return result;
    }
    
    

  
  int cnt = 0;
    
    public HashMap<Node, ArrayList> all_nodes_meta_categories = new HashMap<Node, ArrayList>();
    public ArrayList add_meta_categories(Node n,int[] visited,ArrayList meta_categories) {
		 visited[n.id] = 1;
		 cnt++;
		 if(cnt%100000==0) {
			 System.out.println(cnt);
		 }

    	if(scdawg.sinks.contains(n)) {
    		ArrayList meta_sink = new ArrayList();
    		meta_sink.add(meta_categories.get(n.stringnr));
    		all_nodes_meta_categories.put(n, meta_sink);
    		return meta_sink;
    	}
    	
		Iterator it = n.children.entrySet().iterator();
		
		ArrayList node_meta = new ArrayList();
		
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			int key = (int) pair.getKey();
			Node child = (Node) pair.getValue();
			if (visited[child.id]!=1) {
			 ArrayList child_meta = add_meta_categories(child,visited,meta_categories);
			 for(Object cat : child_meta) {
				 if(!node_meta.contains(cat)) {
					 node_meta.add(cat);
				 }
			 }
			}
			else {
				 ArrayList child_meta=all_nodes_meta_categories.get(child);
				 for(Object cat : child_meta) {
					 if(!node_meta.contains(cat)) {
						 node_meta.add(cat);
					 }
				 }
			}
		}
		
		
		if(n.children.isEmpty()) {
		
			Iterator it2 = n.children_left.entrySet().iterator();
			while (it2.hasNext()) {

				Map.Entry pair = (Map.Entry) it2.next();
				int key = (int) pair.getKey();
				Node child = (Node) pair.getValue();
				if (visited[child.id]!=1) {
					 ArrayList child_meta = add_meta_categories(child,visited,meta_categories);
					 for(Object cat : child_meta) {
						 if(!node_meta.contains(cat)) {
							 node_meta.add(cat);
						 }
					 }
				}
				else {
					 ArrayList child_meta=all_nodes_meta_categories.get(child);
					 for(Object cat : child_meta) {
						 if(!node_meta.contains(cat)) {
							 node_meta.add(cat);
						 }
					 }
				}
			}

		}
		  all_nodes_meta_categories.put(n, node_meta);
	
			return node_meta;
    	    
    	   }
    
  
    public HashMap<Node, ArrayList> all_nodes_df = new HashMap<Node, ArrayList>();
    public ArrayList get_df(Node n,int[] visited) {
		 visited[n.id] = 1;
		 

    	if(scdawg.sinks.contains(n)) {
    		ArrayList df_sink = new ArrayList();
    		df_sink.add(n.stringnr);
    		all_nodes_df.put(n, df_sink);
    		return df_sink;
    	}
    	
		Iterator it = n.children.entrySet().iterator();
		
		ArrayList node_df = new ArrayList();
		
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			int key = (int) pair.getKey();
			Node child = (Node) pair.getValue();
			
			if (visited[child.id]!=1) {
			 ArrayList child_df = get_df(child,visited);
			 for(Object df : child_df) {
				 if(!node_df.contains(df)) {
					 node_df.add(df);
				 }
			 }
			}
			else {
				 ArrayList child_df=all_nodes_df.get(child);
				 for(Object df : child_df) {
					 if(!node_df.contains(df)) {
						 node_df.add(df);
					 }
				 }
			}
		}
		
		
		if(n.children.isEmpty()) {
		
			Iterator it2 = n.children_left.entrySet().iterator();
			while (it2.hasNext()) {

				Map.Entry pair = (Map.Entry) it2.next();
				int key = (int) pair.getKey();
				Node child = (Node) pair.getValue();
				if (visited[child.id]!=1) {
					 ArrayList child_df = get_df(child,visited);
					 for(Object df : child_df) {
						 if(!node_df.contains(df)) {
							 node_df.add(df);
						 }
					 }
					}
					else {
						 ArrayList child_df=all_nodes_df.get(child);
						 for(Object df : child_df) {
							 if(!node_df.contains(df)) {
								 node_df.add(df);
							 }
						 }
					}
			}

		}
		all_nodes_df.put(n, node_df);
	
			return node_df;
    	    
    	   }
    
    
    //##########################
    
    public HashMap<Node, Integer> all_nodes_freqs = new HashMap<Node, Integer>();
    public int add_freq_labels(Node n,ArrayList visited) {
		 visited.add(n);
		 
//		 System.out.println(scdawg.get_node_label(n));

    	if(scdawg.sinks.contains(n)) {
			all_nodes_freqs.put(n, 1);
    		return 1;
    	}
    	
		Iterator it = n.children.entrySet().iterator();
		
		int node_freq = 0;
		
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			int key = (int) pair.getKey();
			Node child = (Node) pair.getValue();
			if (!visited.contains(child)) {
			 int child_freq = add_freq_labels(child,visited);
			 node_freq += child_freq;
			}
			else {
				node_freq+=all_nodes_freqs.get(child);
			}
		}
		
		
		if(n.children.isEmpty()) {
		
			Iterator it2 = n.children_left.entrySet().iterator();
			while (it2.hasNext()) {

				Map.Entry pair = (Map.Entry) it2.next();
				int key = (int) pair.getKey();
				Node child = (Node) pair.getValue();
				if (!visited.contains(child)) {
					 int child_freq = add_freq_labels(child,visited);
					 node_freq += child_freq;
				}
				else {
					node_freq+=all_nodes_freqs.get(child);
				}
			}

		}
			all_nodes_freqs.put(n, node_freq);
	
			return node_freq;
    	    
    	   }
    
    
    
    /*********************************************************************************
     * get_quasi_maximal_nodes_new
     * 
     * finds quasimaximal nodes für two strings simple quasi-max definition =
     * direct left + direct right edge to sink for start and end two left or two
     * right transitions RETURN (v,i,j)
     ***********************************************************************************/

    public ArrayList<Endpos_Tupel> get_quasi_maximal_nodes_new() {

	HashMap<Node,Integer >marked_nodes = this.get_string_occurences();
	
	
	ArrayList<Endpos_Tupel> result = new ArrayList();
	mainloop: for (int i = 0; i < scdawg.all_nodes.size(); i++) {

	    Node node = scdawg.all_nodes.get(i);

	    if (marked_nodes.get(node) != -1 || node == scdawg.root)
		continue;
	    
    
	    
	    // check for start node
	    if (node.children_new.size() == 2 && scdawg.get_node_label(node).startsWith("#")) {
		
        	   result.add(new Endpos_Tupel(node, scdawg.get_node_length(node), 0));
        	   result.add(new Endpos_Tupel(node, scdawg.get_node_length(node), 1));

		   continue mainloop;

		}
		
//
//	    // check for end node
	    if (node.children_left.size() == 2 && scdawg.get_node_label(node).endsWith("$")) {
        	   result.add(new Endpos_Tupel(node, scdawg.stringset.get(0).length, 0));
        	   result.add(new Endpos_Tupel(node, scdawg.stringset.get(1).length, 1));

		   continue mainloop;
	    }

	    // all nodes except last alignment part
	    get_quasi_maximal_nodes_Util(node, node,result, marked_nodes, 0);

	
	}
	return result;
    }
    
    
    void get_quasi_maximal_nodes_Util(Node sourceNode, Node node, ArrayList<Endpos_Tupel> quasi_max_nodes,
	    HashMap<Node,Integer> marked_nodes, int pathcount) {

	
	//
	//System.out.println("node " + scdawg.get_node_label(sourceNode) + " n	 " + scdawg.get_node_label(node));


	Iterator it = node.children_new.entrySet().iterator();

	while (it.hasNext()) {
	    Map.Entry pair2 = (Map.Entry) it.next();
	    EdgeInfo e = (EdgeInfo) pair2.getValue();
	    Node n2 = e.child;

	    if (n2.is_endNode) {

		int left_context_in_sink = e.pos - scdawg.get_node_length(node) - 1;

		int left_letter = scdawg.get_letter(left_context_in_sink, n2.stringnr);

		if (sourceNode.children_left.get(left_letter) != null) {

//		    if (node.children_left.get(left_letter) == e.child) { // hier doch check ob left_child == child ??
		   if (marked_nodes.get(sourceNode.children_left.get(left_letter)) != -1) { // hier doch check ob left_child == child ??
//		       System.out.println(node.children_left.get(left_letter).id+" .L...:::. ...:. R  "+e.child.id);

			int possible_endpos = e.pos - pathcount;
			quasi_max_nodes.add(new Endpos_Tupel(sourceNode,possible_endpos,n2.stringnr));
			
			}

		    }
 
	    } else if (marked_nodes.get(n2) != -1) {
		get_quasi_maximal_nodes_Util(sourceNode, n2, quasi_max_nodes, marked_nodes,
			scdawg.get_edge_length((int) pair2.getKey(), node, n2) + pathcount);
	    }
	}


    }
    
    /*********************************************************************************
     * get_quasi_maximal_nodes_pairwise
     * 
     * finds quasimaximal nodes für two strings simple quasi-max definition =
     * direct left + direct right edge to sink for start and end two left or two
     * right transitions
     ***********************************************************************************/

    public ArrayList<Endpos_Pair> get_quasi_maximal_nodes_pairwise() {

	HashMap<Node,Integer> marked_nodes = this.get_string_occurences();
	
	System.out.println("done marked nodes");
	
	ArrayList<Endpos_Pair> result = new ArrayList();

	mainloop: for (int i = 0; i < scdawg.all_nodes.size(); i++) {

	    Node node = scdawg.all_nodes.get(i);

	    if (marked_nodes.get(node) != -1 || node == scdawg.root)
		continue;
	    
	    
	    // check for start node
	    if (node.children_new.size() == 2 && scdawg.get_node_label(node).startsWith("#")) {
		
    		   ArrayList endpos_s1 = new ArrayList();
    		   ArrayList endpos_s2 = new ArrayList();
		   endpos_s1.add(scdawg.get_node_length(node));
		   endpos_s2.add(scdawg.get_node_length(node));
        	   result.add(new Endpos_Pair(node, endpos_s1, endpos_s2));

		   continue mainloop;

		}
		
//
//	    // check for end node
	    if (node.children_left.size() == 2 && scdawg.get_node_label(node).endsWith("$")) {
		   ArrayList endpos_s1 = new ArrayList();
    		   ArrayList endpos_s2 = new ArrayList();
		   endpos_s1.add(scdawg.stringset.get(0).length);
		   endpos_s2.add(scdawg.stringset.get(1).length);
        	   result.add(new Endpos_Pair(node, endpos_s1, endpos_s2));

		   continue mainloop;
	    }

	    // all nodes except last alignment part
	    get_quasi_maximal_nodes_pairwise_Util(node, node,result, marked_nodes, 0);

	
	}
	return result;
    }

    void get_quasi_maximal_nodes_pairwise_Util(Node sourceNode, Node node, ArrayList<Endpos_Pair> quasi_max_nodes,
	    HashMap<Node,Integer> marked_nodes, int pathcount) {

	HashMap<Node, Integer> quasi_max_nodes_hash = new HashMap<Node, Integer>();
	for (int i = 0; i < quasi_max_nodes.size(); i++) {
	    quasi_max_nodes_hash.put(quasi_max_nodes.get(i).node, i); // hier
								      // nochmal
								      // der
								      // nervige
								      // hash...
	}

	//
	//System.out.println("node " + scdawg.get_node_label(sourceNode) + " n	 " + scdawg.get_node_label(node));

	// all nodes except last alignment part
	ArrayList endpos_s1 = new ArrayList();
	ArrayList endpos_s2 = new ArrayList();

	Iterator it = node.children_new.entrySet().iterator();

	while (it.hasNext()) {
	    Map.Entry pair2 = (Map.Entry) it.next();
	    EdgeInfo e = (EdgeInfo) pair2.getValue();
	    Node n2 = e.child;

	    if (n2.is_endNode) {

		int left_context_in_sink = e.pos - scdawg.get_node_length(node) - 1;

		int left_letter = scdawg.get_letter(left_context_in_sink, n2.stringnr);

		if (sourceNode.children_left.get(left_letter) != null) {

		    if (marked_nodes.get(sourceNode.children_left.get(left_letter)) != -1) { // hier doch check ob left_child == child ??

			int possible_endpos = e.pos - pathcount;

			if (n2.stringnr == 0) {
			    if (!endpos_s1.contains(possible_endpos)) {
				endpos_s1.add(possible_endpos);
			    }
			} else {
			    if (!endpos_s2.contains(possible_endpos)) {
				endpos_s2.add(possible_endpos);
			    }
			}

		    }
		}
 
	    } else if (marked_nodes.get(n2)!= -1) {
		get_quasi_maximal_nodes_pairwise_Util(sourceNode, n2, quasi_max_nodes, marked_nodes,
			scdawg.get_edge_length((int) pair2.getKey(), node, n2) + pathcount);
	    }
	}

	quasi_max_nodes_hash = new HashMap<Node, Integer>(); // hier
							     // möglicherweise
							     // quadratisch!!:....
	for (int i = 0; i < quasi_max_nodes.size(); i++) {
	    quasi_max_nodes_hash.put(quasi_max_nodes.get(i).node, i);
	}

	if (endpos_s1.size() > 0 || endpos_s2.size() > 0) {

	    if (quasi_max_nodes_hash.containsKey(sourceNode)) {

		ArrayList<Integer> final_endpos_s1 = quasi_max_nodes
			.get(quasi_max_nodes_hash.get(sourceNode)).endpos_s1;
		ArrayList<Integer> final_endpos_s2 = quasi_max_nodes
			.get(quasi_max_nodes_hash.get(sourceNode)).endpos_s2;

		final_endpos_s1.addAll(endpos_s1);
		final_endpos_s2.addAll(endpos_s2);

		Set<Integer> set = new HashSet<>();
		set.addAll(final_endpos_s1);
		final_endpos_s1.clear();
		final_endpos_s1.addAll(set);

		set.clear();
		set.addAll(final_endpos_s2);
		final_endpos_s2.clear();
		final_endpos_s2.addAll(set);

		Collections.sort(quasi_max_nodes.get(quasi_max_nodes_hash.get(sourceNode)).endpos_s1);
		Collections.sort(quasi_max_nodes.get(quasi_max_nodes_hash.get(sourceNode)).endpos_s2);

	    } else {
		quasi_max_nodes.add(new Endpos_Pair(sourceNode, endpos_s1, endpos_s2));
	    }
	}

    }

    /*********************************************************************************
     * get_quasi_maximal_nodes_pairwise_only_right_edges
     * 
     * finds quasimaximal nodes für two strings simple quasi-max definition each
     * right transitions to a sink
     ***********************************************************************************/

    public ArrayList<Endpos_Pair> get_quasi_maximal_nodes_pairwise_only_right_edges() {

	ArrayList<Endpos_Pair> result = new ArrayList();
	Node[] nodes_in_s1 = new Node[scdawg.stringset.get(0).length];

	mainloop: for (int i = 0; i < scdawg.all_nodes.size(); i++) {

	    Node node = scdawg.all_nodes.get(i);

	    if (node.equals(scdawg.root)) {
		continue;
	    }

	    // all nodes except last alignment part
	    ArrayList endpos_s1 = new ArrayList();
	    ArrayList endpos_s2 = new ArrayList();

	    HashSet<Integer> sinkshit = new HashSet<>();

	    Iterator it = node.children_new.entrySet().iterator();

	    while (it.hasNext()) {
		Map.Entry pair2 = (Map.Entry) it.next();
		EdgeInfo e = (EdgeInfo) pair2.getValue();
		Node n2 = e.child;

		if (n2.is_endNode) {
		    int start_in_sink = e.pos - scdawg.get_node_length(node) - 1;

		    if (start_in_sink > -1) {
			// System.out.println(scdawg.get_node_label(node)+"
			// "+scdawg.get_node_label(n2)+"
			// :"+scdawg.get_node_length(node)+" "+e.pos+"
			// "+start_in_sink);

			sinkshit.add(n2.stringnr);

			if (n2.stringnr == 0) {
			    if (!endpos_s1.contains(e.pos)) {
				endpos_s1.add(e.pos);
			    }
			} else {
			    if (!endpos_s2.contains(e.pos)) {
				endpos_s2.add(e.pos);
			    }
			}

		    }
		}
	    }
	    // if (sinkshit.size() == 2 && (endpos_s1.size() == 1 &&
	    // endpos_s2.size() == 1)) {
	    // if (sinkshit.size() == 2 && (endpos_s1.size() > 0 &&
	    // endpos_s2.size() > 0)) {
	    if (endpos_s1.size() > 0 || endpos_s2.size() > 0) {
		result.add(new Endpos_Pair(node, endpos_s1, endpos_s2));
		continue mainloop;
	    }
	    // check for start node
	    if (node.children_new.size() == 2 && scdawg.get_node_label(node).startsWith("#")) {
		sinkshit = new HashSet<>();
		for (Map.Entry<Integer, EdgeInfo> e : node.children_new.entrySet()) {
		    if (e.getValue().child.is_endNode) {
			sinkshit.add(e.getValue().child.stringnr);
		    }
		}
		if (sinkshit.size() == 2) {
		    endpos_s1.add(scdawg.get_node_length(node));
		    endpos_s2.add(scdawg.get_node_length(node));
		    result.add(new Endpos_Pair(node, endpos_s1, endpos_s2));
		    continue mainloop;
		}
	    }

	    // check for end node
	    if (node.children_left.size() == 2 && scdawg.get_node_label(node).endsWith("$")) {
		sinkshit = new HashSet<>();
		for (Map.Entry<Integer, Node> e : node.children_left.entrySet()) {
		    if (e.getValue().is_endNode) {
			sinkshit.add(e.getValue().stringnr);
			if (e.getValue().stringnr == 0) {
			    if (!endpos_s1.contains(scdawg.stringset.get(0).length)) {
				endpos_s1.add(scdawg.stringset.get(0).length);
			    }
			} else {
			    if (!endpos_s2.contains(scdawg.stringset.get(1).length)) {
				endpos_s2.add(scdawg.stringset.get(1).length);
			    }
			}
		    }
		}
		if (sinkshit.size() == 2) {
		    result.add(new Endpos_Pair(node, endpos_s1, endpos_s2));
		    continue mainloop;
		}
	    }
	}
	return result;
    }

    /*********************************************************************************
     * get_distinct_quasimaximal_nodes()
     * 
     * finds all quasimaximal Nodes with transitions to only one string
     * quasimaximal defined as either left or right transitions to exactly one
     * string
     **********************************************************************************/

    public void get_distinct_quasimaximal_nodes() {

	HashMap<Node, Integer> distinct_nodes = new HashMap();

	scdawg.eachNode_BFS(scdawg.root, false, false, new Online_CDAWG_sym.Visitor() {
	    public void visit(Node n) {

		// System.out.println(get_node_label(n));
		ArrayList sinkshit = new ArrayList();

		Iterator it2 = n.children.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (!n2.is_endNode)
			return;

		    if (n2.is_endNode & !sinkshit.contains(n2))
			sinkshit.add(n2);
		    // System.out.print(get_letter_by_idx((int)
		    // pair2.getKey())+" ");
		}

		it2 = n.children_left.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (!n2.is_endNode)
			return;

		    if (n2.is_endNode & !sinkshit.contains(n2))
			sinkshit.add(n2);
		}

		// System.out.println("xxx " + sinkshit.size());

		if (sinkshit.size() == 1) {
		    int count = 0;

		    Iterator it3 = n.children.entrySet().iterator();

		    while (it3.hasNext()) {
			Map.Entry pair3 = (Map.Entry) it3.next();
			Node n3 = (Node) pair3.getValue();
			if (n3.is_endNode)
			    count++;
		    }

		    distinct_nodes.put(n, count);
		}

		// System.out.println("---------------------------------------------------");

	    }
	});
	System.out.println("Size " + distinct_nodes.size());

	HashMap distinct_nodes_sorted = Util.sortByValues(distinct_nodes, "DESC");

	Iterator it2 = distinct_nodes_sorted.entrySet().iterator();

	while (it2.hasNext()) {
	    Map.Entry pair = (Map.Entry) it2.next();
	    Node n = (Node) pair.getKey();
	    Integer count = (Integer) pair.getValue();

	    System.out.println(count + " " + scdawg.get_node_label(n));

	}

    }

    /*********************************************************************************
     * childOf()
     * 
     * Checks if one node is the direct child of another
     **********************************************************************************/

    public boolean childOf(Node father, Node child) {

	Iterator it2 = father.children.entrySet().iterator();

	while (it2.hasNext()) {
	    Map.Entry pair2 = (Map.Entry) it2.next();
	    Node n2 = (Node) pair2.getValue();

	    if (n2.equals(child))
		return true;

	}

	// it2 = father.children_left.entrySet().iterator();
	//
	// while (it2.hasNext()) {
	// Map.Entry pair2 = (Map.Entry) it2.next();
	// Node n2 = (Node) pair2.getValue();
	//
	// if (n2.equals(child))
	// return true;
	//
	// }

	return false;
    }

    /*********************************************************************************
     * get_string_occurences()
     * 
     * Returns HashMap with nodes and a boolean value, whether the nodes occurs
     * in one or more strings
     **********************************************************************************/

    public HashMap<Node,Integer> get_string_occurences() {

	HashMap<Node,Integer> marked_nodes = new HashMap();

	scdawg.eachNode_DFS(scdawg.root, true, true, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {

		// System.out.println("Node " + scdawg.get_node_label(n));

		if (n.is_endNode) {
		    marked_nodes.put(n,n.stringnr);
		    return;
		}

		int k = -2;

		Iterator it2 = n.children.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (k == -2) {
			k = marked_nodes.get(n2);
		    } else if (k != marked_nodes.get(n2)) {
			marked_nodes.put(n,-1);
			return;
		    }

		}

		it2 = n.children_left.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (k == -2) {
				k = marked_nodes.get(n2);
		    } else if (k != marked_nodes.get(n2)) {
			marked_nodes.put(n,-1);
			return;
		    }
		}

		marked_nodes.put(n,k);

	    }
	});

	// System.out.println("Size " + marked_nodes.length);

	// for (int i = 0; i < scdawg.all_nodes.size(); i++) {
	// Node n = scdawg.all_nodes.get(i);
	// System.out.println(scdawg.get_node_label(n) + " " +
	// marked_nodes[n.id]);

	// if (scdawg.stringset.get(0).contains(scdawg.get_node_label(n))
	// && scdawg.stringset.get(0).contains(scdawg.get_node_label(n)) &&
	// marked_nodes[n.id] != -1) {
	// System.out.println("ALARM");
	// }
	// }

	return marked_nodes;

    }
    
    /*********************************************************************************
     * get_string_occurences()
     * 
     * Returns HashMap with nodes and a boolean value, whether the nodes occurs
     * in one or more strings
     **********************************************************************************/

    public HashMap<Node,Integer> get_string_occurences_meta(HashMap<Node,ArrayList> nodes_meta) {

	HashMap<Node,Integer> marked_nodes = new HashMap();

	scdawg.eachNode_DFS(scdawg.root, true, true, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {


	    	if(nodes_meta.get(n).size()>1) {
	    		marked_nodes.put(n,-1);
	    	}
	    	else {
	    		marked_nodes.put(n,1);
	    	}

	    }
	});
	
//	System.out.println("-----------------------------------------------------------------------");
//
//
//
//	for(Node r : marked_nodes.keySet()) {
//	   
//	    System.out.println(scdawg.get_node_label(r) + " " + marked_nodes.get(r));
//
//	}
//
	return marked_nodes;

    }

    /*********************************************************************************
     * get_n_string_occurences()
     * 
     * Returns HashMap with nodes and a HashSet value, whether the nodes occurs
     * in one or more strings
     **********************************************************************************/

    public HashMap<Node, HashSet<Integer>> get_n_string_occurences(int n) {

	HashMap<Node, HashSet<Integer>> marked_nodes = new HashMap();
	HashMap<Node, HashSet<Integer>> result = new HashMap();

	scdawg.eachNode_DFS(scdawg.root, true, true, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {

		if (n.is_endNode) {
		    return;
		}

		// System.out.println(" node: " + scdawg.get_node_label(n) + " "
		// +
		// marked_nodes.get(n));

		HashSet<Integer> child_occurrences = new HashSet();
		HashSet sinkshit = new HashSet();

		Iterator it2 = n.children.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (n2.is_endNode)
			sinkshit.addAll(n2.stringnumbers);

		    if (marked_nodes.containsKey(n2))
			child_occurrences = marked_nodes.get(n2);
		}

		it2 = n.children_left.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (n2.is_endNode)
			sinkshit.addAll(n2.stringnumbers);

		    if (marked_nodes.containsKey(n2))
			child_occurrences = marked_nodes.get(n2);
		}

		sinkshit.addAll(child_occurrences);

		marked_nodes.put(n, sinkshit);

	    }
	});

	// for (Node sink : scdawg.sinks){
	// marked_nodes.put(sink, false);
	//
	// }
	System.out.println("Size " + marked_nodes.size());

	Iterator it2 = marked_nodes.entrySet().iterator();

	while (it2.hasNext()) {
	    Map.Entry pair = (Map.Entry) it2.next();
	    Node node = (Node) pair.getKey();
	    HashSet count = (HashSet) pair.getValue();

	    if (count.size() <= n) {
		Iterator it3 = count.iterator();
		HashSet<Integer> ids = new HashSet();
		int final_count = 0;

		while (it3.hasNext()) {
		    Integer id = (Integer) it3.next();
		    ids.add(id);
//		    System.out.print(id + " ");
		}
//		System.out.println(":" + ids.size() + " " + scdawg.get_node_label(node));
		if (ids.size() == n) {
		    result.put(node, ids);
		}
	    }
	}

	return result;

    }

    /*********************************************************************************
     * mark_children_of_single_occ_nodes()
     * 
     * Marks children of marked_nodes (nodes only occuring) once
     * 
     * @param marked_nodes:
     *            Result from mark_children_of_single_occ_nodes()
     **********************************************************************************/

    public HashMap<Node, Boolean> mark_children_of_single_occ_nodes(HashMap<Node,Integer> marked_nodes) {

	HashMap<Node, Boolean> result = new HashMap();
	scdawg.eachNode_DFS(scdawg.root, true, false, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {
		if (n.is_endNode) {
		    return;
		}

//		 if(scdawg.get_node_label(n).equals("len.$")) {
//		    	System.out.println(scdawg.get_node_label(n)+" KLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL");
//		    	System.out.println(scdawg.all_nodes.get(-2));
//
//		    }
		
		if (marked_nodes.get(n) == -1)
		    return;

		Iterator it2 = n.children.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();
		    
//			 if(scdawg.get_node_label(n2).equals("len.$")) {
//			    	System.out.println(scdawg.get_node_label(n)+" KLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL");
//			    	System.out.println(scdawg.all_nodes.get(-2));
//
//			    }
		    

		    if (marked_nodes.get(n2) > -1)
			result.put(n2, true);

		}

		Iterator it3 = n.children_left.entrySet().iterator();

		while (it3.hasNext()) {
		    Map.Entry pair3 = (Map.Entry) it3.next();
		    Node n3 = (Node) pair3.getValue();
		   
//			 if(scdawg.get_node_label(n3).equals("len.$")) {
//			    	System.out.println(scdawg.get_node_label(n)+" KLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL");
//			    	System.out.println(scdawg.all_nodes.get(-2));
//
//			    }
		    
		    if (marked_nodes.get(n3) > -1) {
		       
		    	
			result.put(n3, true);
		    }

		 		    
		}
		
//		 if(scdawg.get_node_label(n).equals("len.$")) {
//		    	System.out.println(scdawg.all_nodes.get(-2));
//		    }

	    }
	});

	// for (Node sink : scdawg.sinks){
	// marked_nodes.put(sink, false);
	//
	// }
//	System.out.println("-----------------------------------------------------------------------");
//
//	System.out.println("Size " + result.size());
//
//	Iterator it2 = result.entrySet().iterator();
//
//	while (it2.hasNext()) {
//	    Map.Entry pair = (Map.Entry) it2.next();
//	    Node n = (Node) pair.getKey();
//	    Boolean count = (Boolean) pair.getValue();
//
//	    System.out.println(count + " " + scdawg.get_node_label(n));
//
//	}

	return result;

    }

    /*********************************************************************************
     * get_quasiminimal_nodes()
     * 
     * Finds all quasiminimal nodes in an SCDAWG Quasiminimal defined as all
     * nodes with parent nodes occuring in more then one string while they only
     * occur in one string
     * 
     * @param marked_nodes:
     *            Result from get_string_occurences()
     **********************************************************************************/

    public HashMap<Node, Integer> get_quasiminimal_nodes() {

	HashMap<Node, Integer> result = new HashMap<Node, Integer>();
	ArrayList<Node> quasiminimal_nodes = new ArrayList<Node>();

	HashMap<Node,Integer> marked_nodes = this.get_string_occurences();
	System.out.println("VM DONE");
	
	HashMap<Node, Boolean> marked_nodes2 = this.mark_children_of_single_occ_nodes(marked_nodes);
	System.out.println("VU DONE");

	scdawg.eachNode_DFS(scdawg.root, true, false, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {

		if (n.is_endNode || n == scdawg.root) {
		    return;
		}

		if (marked_nodes.get(n) == -1)
		    return;

		if (marked_nodes2.containsKey(n)) {
		    if (marked_nodes2.get(n))
			return;
		} else {
		    quasiminimal_nodes.add(n);
		}
	    }

	});

	HashMap<Node, Integer> right_edges_count = this.count_quasiminimal_nodes(marked_nodes);

	System.out.println("QUASIMINIMAL Size " + quasiminimal_nodes.size());

	for (Node n : quasiminimal_nodes) {

	    Iterator it2 = n.children.entrySet().iterator();

	    result.put(n, right_edges_count.get(n));
	}

	return result;
    }

    
    public HashMap<Node, Integer> get_quasiminimal_nodes_df() {

    	HashMap<Node, Integer> result = new HashMap<Node, Integer>();
    	ArrayList<Node> quasiminimal_nodes = new ArrayList<Node>();

    	HashMap<Node,Integer> marked_nodes = this.get_string_occurences();
    	System.out.println("VM DONE");
    	
    	HashMap<Node, Boolean> marked_nodes2 = this.mark_children_of_single_occ_nodes(marked_nodes);
    	System.out.println("VU DONE");

    	scdawg.eachNode_DFS(scdawg.root, true, false, new Online_CDAWG_sym.Visitor() {

    	    public void visit(Node n) {

    		if (n.is_endNode || n == scdawg.root) {
    		    return;
    		}

    		if (marked_nodes.get(n) == -1)
    		    return;

    		if (marked_nodes2.containsKey(n)) {
    		    if (marked_nodes2.get(n))
    			return;
    		} else {
    		    quasiminimal_nodes.add(n);
    		}
    	    }

    	});
    	int [] v2 = new int[scdawg.all_nodes.size()+10];
    	for (int x = 0;x<v2.length;x++) {
    		v2[0] = 0;
    	}
		 ArrayList root_df = this.get_df(scdawg.root,v2);

    	System.out.println("QUASIMINIMAL Size " + quasiminimal_nodes.size());

    	for (Node n : quasiminimal_nodes) {

    	    Iterator it2 = n.children.entrySet().iterator();

    	    result.put(n, all_nodes_df.get(n).size());
    	}

    	return result;
        }

    public HashMap<Node, Integer> get_quasiminimal_nodes_meta(ArrayList meta) {

    	HashMap<Node, Integer> result = new HashMap<Node, Integer>();
    	ArrayList<Node> quasiminimal_nodes = new ArrayList<Node>();
    	System.out.println("ADD META");
    	int [] v1 = new int[scdawg.all_nodes.size()+10];
    	for (int x = 0;x<v1.length;x++) {
    		v1[0] = 0;
    	}
		 ArrayList root_meta = add_meta_categories(scdawg.root,v1,meta);
		 
//		 for (Entry<Node, ArrayList> entry : all_nodes_meta_categories.entrySet()) {
//			 Node key = entry.getKey();
//			    ArrayList value = entry.getValue();
//			if(scdawg.get_node_label(key).contains("$")&!key.is_endNode) System.out.println(scdawg.get_node_label(key)+" : " +value);
//			}

    	HashMap<Node,Integer> marked_nodes = this.get_string_occurences_meta(all_nodes_meta_categories);
    	System.out.println("VM DONE");
    	
    	HashMap<Node, Boolean> marked_nodes2 = this.mark_children_of_single_occ_nodes(marked_nodes);
    	System.out.println("VU DONE");

    	scdawg.eachNode_DFS(scdawg.root, true, false, new Online_CDAWG_sym.Visitor() {

    	    public void visit(Node n) {

    		if (n.is_endNode || n == scdawg.root) {
    		    return;
    		}

    		if (marked_nodes.get(n) == -1) {

    		    return;

    		}

    		if (marked_nodes2.containsKey(n)) {
    		    if (marked_nodes2.get(n))
    			return;
    		} else {
    		    quasiminimal_nodes.add(n);
    		}
    	    }

    	});
    	
    	int [] v2 = new int[scdawg.all_nodes.size()+10];
    	for (int x = 0;x<v2.length;x++) {
    		v2[0] = 0;
    	}
		 ArrayList root_df = this.get_df(scdawg.root,v2);

    	System.out.println("QUASIMINIMAL Size " + quasiminimal_nodes.size());

    	for (Node n : quasiminimal_nodes) {

    	    Iterator it2 = n.children.entrySet().iterator();

    	    result.put(n, all_nodes_df.get(n).size());
    	}

    	return result;
        }
   
	
	/*********************************************************************************
     * count_quasiminimal_nodes()
     * 
     * 
     * 
     * @param marked_nodes:
     *            Result from get_string_occurences()
     **********************************************************************************/

    public HashMap<Node, Integer> count_quasiminimal_nodes(HashMap<Node,Integer> marked_nodes) {

	HashMap<Node, Integer> result = new HashMap<Node, Integer>();
	System.out.println("-----------------------------------------------------------------------");

	scdawg.eachNode_DFS(scdawg.root, true, true, new Online_CDAWG_sym.Visitor() {

	    public void visit(Node n) {

		if (n.is_endNode || n == scdawg.root) {
		    return;
		}

		if (marked_nodes.get(n) == -1)
		    return;

		int count = 0;

		Iterator it2 = n.children.entrySet().iterator();

		while (it2.hasNext()) {
		    Map.Entry pair2 = (Map.Entry) it2.next();
		    Node n2 = (Node) pair2.getValue();

		    if (n2.is_endNode)
			count++;
		    if (result.containsKey(n2))
			count += result.get(n2);

		}

		result.put(n, count);

	    }

	});

	// System.out.println("-----------------------------------------------------------------------");
	//
	// System.out.println("COUNT");
	//
	// Iterator it2 = result.entrySet().iterator();
	//
	// while (it2.hasNext()) {
	// Map.Entry pair = (Map.Entry) it2.next();
	// Node n = (Node) pair.getKey();
	// Integer count = (Integer) pair.getValue();
	//
	// System.out.println(count + " " + scdawg.get_node_label(n));
	//
	// }

	return result;
    }

    /*********************************************************************************
     * get_quasimaximal_nodes()
     * 
     * Finds all quasimaximal nodes in an SCDAWG quasimaximal defined as longest
     * nodes occuring in (n) strings
     * 
     * @param marked_nodes:
     *            Result from get_string_occurences()
     **********************************************************************************/

    public HashMap<Node, Integer> get_quasimaximal_nodes(HashMap<Node, Boolean> marked_nodes) {

	HashMap<Node, Integer> quasi_maximal_nodes = new HashMap<Node, Integer>();
	HashMap<Node, Integer> quasi_maximal_nodes_help = new HashMap<Node, Integer>();

	scdawg.eachNode_DFS(scdawg.root, true, false, new Online_CDAWG_sym.Visitor() {

	    Node quasi_maximal_candidate = null;
	    HashSet<Integer> sinkset = new HashSet<Integer>();

	    int count = 0;

	    public void visit(Node n) {
		// WELCHE SINKS STATT NUR ZÄHLEN!!?
		if (n.is_endNode || n == scdawg.root)
		    return;

		System.out.println(" node: " + scdawg.get_node_label(n) + " " + marked_nodes.get(n));

		if (marked_nodes.get(n) && quasi_maximal_candidate == null) {
		    quasi_maximal_candidate = n;
		}

		if (quasi_maximal_candidate != null)
		    System.out.println(" candidate: " + scdawg.get_node_label(quasi_maximal_candidate));
		else
		    System.out.println(" candidate: null");

		if (marked_nodes.get(n)) {

		    Iterator it2 = n.children.entrySet().iterator();

		    while (it2.hasNext()) {
			Map.Entry pair2 = (Map.Entry) it2.next();
			Node n2 = (Node) pair2.getValue();

			if (scdawg.sinks.contains(n2)) {
			    sinkset.add(n2.stringnr);
			}
			if (quasi_maximal_nodes_help.containsKey(n2) && quasi_maximal_candidate != null) {

			    System.out.println(
				    " candidate: " + quasi_maximal_candidate.children.entrySet().iterator().hasNext());

			    Iterator it3 = quasi_maximal_candidate.children.entrySet().iterator();
			    int sinkshit_candidate = 0;

			    while (it3.hasNext()) {
				Map.Entry pair3 = (Map.Entry) it3.next();
				Node n3 = (Node) pair3.getValue();

				if (scdawg.sinks.contains(n3)) {
				    sinkshit_candidate++;
				}
			    }

			    it3 = n2.children.entrySet().iterator();
			    int sinkshit_n2 = 0;

			    while (it3.hasNext()) {
				Map.Entry pair3 = (Map.Entry) it3.next();
				Node n3 = (Node) pair3.getValue();

				if (scdawg.sinks.contains(n3)) {
				    sinkshit_n2++;
				}
			    }

			    int sinkshit_total = sinkshit_candidate + sinkshit_n2;

			    if (sinkshit_total == scdawg.sinks.size()) {
				System.out.println("NIMM IHN");
				quasi_maximal_nodes.put(quasi_maximal_candidate, count);
				quasi_maximal_candidate = null;
				sinkset = new HashSet<Integer>();

				return;
			    }
			}
		    }

		    it2 = n.children_left.entrySet().iterator();

		    while (it2.hasNext()) {
			Map.Entry pair2 = (Map.Entry) it2.next();
			Node n2 = (Node) pair2.getValue();

			if (scdawg.sinks.contains(n2)) {
			    sinkset.add(n2.stringnr);

			}
		    }

		    System.out.println(sinkset.size() + " " + scdawg.sinks.size());

		    if (sinkset.size() == scdawg.sinks.size()) { // wenn in
								 // allen sinks
								 // vorkommt
			if (count == 0)
			    count += n.children.size();

			quasi_maximal_nodes.put(quasi_maximal_candidate, count);
			quasi_maximal_candidate = null;
			sinkset = new HashSet<Integer>();
			quasi_maximal_nodes_help.put(n, n.stringnr);
			count = 0;
		    } else
			count += n.children.size();

		}

	    }
	});
	System.out.println("Size maximal " + quasi_maximal_nodes.size());

	HashMap<Node, Integer> result = Util.sortByValues(quasi_maximal_nodes, "DESC");

	Iterator it2 = result.entrySet().iterator();

	while (it2.hasNext()) {
	    Map.Entry pair = (Map.Entry) it2.next();
	    Node n = (Node) pair.getKey();
	    Integer count = (Integer) pair.getValue();

	    System.out.println(count + " xxx " + scdawg.get_node_label(n));

	}

	return result;

    }

    /*********************************************************************************
     * find_n_transitions_to_sinks()
     * 
     * Method searches for all nodes with occurences in n strings
     * 
     * @param node:
     *            node from which search will be started
     **********************************************************************************/

    public static HashSet<Integer> find_n_transitions_to_sinks(Node node, Online_CDAWG_sym scdawg,
	    HashSet<Integer> acc) {

	Iterator it = node.children.entrySet().iterator();
	HashSet<Integer> result = new HashSet<Integer>();
	while (it.hasNext()) {
	    Map.Entry pair = (Map.Entry) it.next();
	    Node child = (Node) pair.getValue();
	    for (int j = 0; j < scdawg.sinks.size(); j++) {
		if (scdawg.sinks.get(j) == child) {
		    // if (!sinks.contains(scdawg.sinks.get(j))) {
		    for (int k = 0; k < scdawg.sinks.get(j).stringnumbers.size(); k++) {
			acc.add(scdawg.sinks.get(j).stringnumbers.get(k));
			// sinks.add(scdawg.sinks.get(j));
		    }
		    // }
		}
	    }
	}

	Iterator it2 = node.children_left.entrySet().iterator();

	while (it2.hasNext()) {

	    Map.Entry pair = (Map.Entry) it2.next();
	    Node child = (Node) pair.getValue();

	    for (int j = 0; j < scdawg.sinks.size(); j++) {
		if (scdawg.sinks.get(j) == child) {
		    // if (!sinks.contains(scdawg.sinks.get(j))) {
		    for (int k = 0; k < scdawg.sinks.get(j).stringnumbers.size(); k++) {
			acc.add(scdawg.sinks.get(j).stringnumbers.get(k));
			// sinks.add(scdawg.sinks.get(j));
		    }
		    // }
		}
	    }
	}

	// REC AUFRUF der Funktion mit den Kindern
	Iterator it3 = node.children.entrySet().iterator();

	while (it3.hasNext()) {

	    Map.Entry pair = (Map.Entry) it3.next();
	    Node child = (Node) pair.getValue();
	    find_n_transitions_to_sinks(child, scdawg, acc);
	}

	Iterator it4 = node.children_left.entrySet().iterator();

	while (it4.hasNext()) {
	    Map.Entry pair = (Map.Entry) it4.next();
	    Node child = (Node) pair.getValue();
	    find_n_transitions_to_sinks(child, scdawg, acc);
	}
	return acc;
    }

    public HashMap<Node, Related_Node_Info> get_related_nodes(ArrayList<Endpos_Pair> quasi_max_nodes) {

	HashMap<Node, Related_Node_Info> result = new HashMap<Node, Related_Node_Info>();

	HashMap<Node, Boolean> quasi_max_nodes_hash = new HashMap<Node, Boolean>();
	for (Endpos_Pair p : quasi_max_nodes) {
	    quasi_max_nodes_hash.put(p.node, true);
	}

	for (Endpos_Pair p : quasi_max_nodes) {
	    Node n = p.node;
	    Iterator it = n.children_new.entrySet().iterator();

	    while (it.hasNext()) {

		Map.Entry pair = (Map.Entry) it.next();
		EdgeInfo e = (EdgeInfo) pair.getValue();
		int letter = (int) pair.getKey();
		if (quasi_max_nodes_hash.containsKey(e.child)) {
		    result.put(n, new Related_Node_Info(e.child, e.pos, false, letter));
		}
	    }

	    it = n.children_left.entrySet().iterator();

	    while (it.hasNext()) {

		Map.Entry pair = (Map.Entry) it.next();
		Node child = (Node) pair.getValue();
		int letter = (int) pair.getKey();

		if (quasi_max_nodes_hash.containsKey(child)) {
		    result.put(n, new Related_Node_Info(child, child.end - scdawg.get_node_length(n), true, letter));
		}
	    }

	}

	return result;
    }
    
//    public HashMap<Node, Related_Node_Info> get_related_father_nodes(ArrayList<Endpos_Pair> quasi_max_nodes) {
//
//   	HashMap<Node, Related_Node_Info> result = new HashMap<Node, Related_Node_Info>();
//   	
//   	HashMap<Node, Node> longest_fathers = new HashMap<Node, Node>();
//
//   	
//   	int[] marked_nodes = this.get_string_occurences();
//
//   	HashMap<Node, Boolean> quasi_max_nodes_hash = new HashMap<Node, Boolean>();
//   	for (Endpos_Pair p : quasi_max_nodes) {
//   	    quasi_max_nodes_hash.put(p.node, true);
//   	}
//
//	mainloop: for (int i = 0; i < scdawg.all_nodes.size(); i++) {
//
//	    Node node = scdawg.all_nodes.get(i);
//
//	    if (marked_nodes[node.id] != -1 || node == scdawg.root)
//		continue;
//	    
//   	    Iterator it = node.children_new.entrySet().iterator();
//
//   	    while (it.hasNext()) {
//
//   		Map.Entry pair = (Map.Entry) it.next();
//   		EdgeInfo e = (EdgeInfo) pair.getValue();
//   		int letter = (int) pair.getKey();
//   		if (quasi_max_nodes_hash.containsKey(e.child)) {
//   		    if(!longest_fathers.containsKey((e.child))
//   			 longest_fathers.put(e.child, new Related_Node_Info(node, e.pos, false, letter));
//   		}
//   	    }
//
//   	    it = node.children_left.entrySet().iterator();
//
//   	    while (it.hasNext()) {
//
//   		Map.Entry pair = (Map.Entry) it.next();
//   		Node child = (Node) pair.getValue();
//   		int letter = (int) pair.getKey();
//
//   		if (quasi_max_nodes_hash.containsKey(child)) {
//   		    result.put(child, new Related_Node_Info(node, child.end - scdawg.get_node_length(node), true, letter));
//   		}
//   	    }
//	
//	}
//   	
//   	
//   	
//
//   	return result;
//       }
}
