import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import cdawg.Online_CDAWG;
import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;

import dawg.DAWG;
import indexstructure.Node;
import suffix_tree.Ukkonen_Suffixtree;
import suffix_trie.Naive_Suffixtrie;
import util.Util;
import com.sun.tools.javac.util.Pair;

import org.apache.commons.cli.*;

public class SearchIndex {

	public static void main(String[] args) {
		ArrayList stringset = new ArrayList();
			

		
		Options options = new Options();

        Option input = new Option("i", "input", true, "input file path");
        input.setRequired(true);
        options.addOption(input);

        Option query= new Option("q", "query", true, "query string");
        query.setRequired(true);
        options.addOption(query);
        
        Option debug = new Option("d", "debug", false, "enable debug prints ");
        debug.setRequired(false);
        options.addOption(debug);
        
        Option find_p = new Option("fp", "find_p", false, "find prefix of query");
        find_p.setRequired(false);
        options.addOption(find_p);
        
        Option find_freq = new Option("ff", "find_freq", false, "find frequency of query");
        find_freq.setRequired(false);
        options.addOption(find_freq);
        
        Option find_loc = new Option("fl", "find_loc", false, "find locations of query");
        find_loc.setRequired(false);
        options.addOption(find_loc);

        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;

        try {
            cmd = parser.parse(options, args);
        } catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("utility-name", options);

            System.exit(1);
        }

        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");
        String querystring = cmd.getOptionValue("query");


        boolean debugbool = false;

        if(cmd.hasOption("debug")) {
	        String debugstring = cmd.getOptionValue("debug");
	        
	        
	        if(debugstring.equals("1")) {
	        	debugbool = true;
	        }
        
        }
        
        

		try {
		stringset = Util.readInputFile(inputFilePath);
		} catch (IOException e) {
			e.printStackTrace();
		}
			
	        
       
    		 Online_CDAWG_sym scdawg = new Online_CDAWG_sym(debugbool);
    		 scdawg.determineAlphabet(stringset,"",debugbool);
    		 scdawg.build_cdawg();
    		 scdawg.print_automaton_new(outputFilePath);
    		 System.out.println("Nodes: " +scdawg.all_nodes.size());
    		 System.out.println("Edges R: " +scdawg.count_edges(scdawg.all_nodes));
    		 System.out.println("Edges L: " +scdawg.count_edges_left(scdawg.all_nodes));

    		 Common_SCDAWG_Functions func = new Common_SCDAWG_Functions(scdawg);
    		 
    	     if(cmd.hasOption("find_p")) 
    		 {
        	 String answer = func.find(querystring,scdawg.root);
    		 System.out.println("Longest Prefix: " +answer);
    		    		 
    		 }
    	     if(cmd.hasOption("find_freq")) {
    			 int nodes = func.add_freq_labels(scdawg.root,new ArrayList());
    			 System.out.println("Frequencies:");
    			 
    			 for (Entry<Node, Integer> entry : func.all_nodes_freqs.entrySet()) {
    				    Node key = entry.getKey();
    				    Object value = entry.getValue();
    				    System.out.println(scdawg.get_node_label(key)+" "+value);
    			
    			 }
    			 
    		}
    	    if(cmd.hasOption("find_loc")) {
    			 System.out.println("Locations:");

    			 Pair<Node,Integer> pair_node_q = func.find_node(querystring,scdawg.root,0);

        		 ArrayList<Pair> r = func.locations(pair_node_q.fst, pair_node_q.snd);
         		 for (Pair entry : r) {
 				
 				    System.out.println(entry.fst.toString()+" "+ entry.snd.toString());
 			
 			 }


    		 }

		 java.io.PrintStream out = System.out;
		 Runtime runtime = Runtime.getRuntime();

			// To convert from Bytes to MegaBytes:
			// 1 MB = 1024 KB and 1 KB = 1024 Bytes.
			// Therefore, 1 MB = 1024 * 1024 Bytes.
			long MegaBytes = 1024 * 1024;

			// Memory which is currently available for use by heap
			long totalMemory = runtime.totalMemory() / MegaBytes;
			out.println("Heap size available for use -> " + totalMemory + " MB");

			// Maximum memory which can be used if required.
			// The heap cannot grow beyond this size
			long maxMemory = runtime.maxMemory() / MegaBytes;
			out.println("Maximum memory Heap can use -> " + maxMemory + " MB");

			// Free memory still available
			long freeMemory = runtime.freeMemory() / MegaBytes;
			out.println("Free memory in heap -> " + freeMemory + " MB");

			// Memory currently used by heap
			long memoryInUse = totalMemory - freeMemory;
			out.println("Memory already used by heap -> " + memoryInUse + " MB");



	}
	
	
	

}

