import os
import argparse
debug = False

class Node:
  def __init__(self,length,id,label):
    self.length = length
    self.id = id
    self.label = label
    self.children_L = dict()
    self.children_R = dict()
    self.sl = None

class Edge:
    global e_i
    global v_wi
    global sink_edges

    def __init__(self,source,pointer,target,stringnr,dir):

        self.source = source
        self.target = target
        self.pointer = pointer
        self.stringnr = stringnr

        if target == v_wi and dir == "R":
           sink_edges.append(self)




def create_node(length,label):
    global node_count
    v = Node(length,node_count,label)
    print("Create Node:"+str(node_count))

    node_count += 1
    V.add(v)
    return v

def create_edge_R(s,k,p,s_,i):
    w_i = W[i]
    s.children_R[w_i[k]] = Edge(s,[k,p],s_,i,"R")
    print("create right'"+get_edge_label_R(Edge(s,[k,p],s_,i,"R"))+"'-edge: "+s.label+" ("+str(s.id)+")"+"("+str(k)+","+str(p)+") --> "+s_.label+" ("+str(s_.id)+")")

def create_edge_L(s,k,p,s_,i):
    w_i = W[i]
    s.children_L[w_i[k]] = Edge(s,[k,p],s_,i,"L")
    print("create left'"+get_edge_label_L(Edge(s,[k,p],s_,i,"L"))+"'-edge: "+s.label+" ("+str(s.id)+")"+"("+str(k)+","+str(p)+") --> "+s_.label+" ("+str(s_.id)+")")

def copy_edges(s,s_,dir):
    if(dir=="L"):
        edges = s.children_L
    else:
        edges = s.children_R
    for key in edges:
        if(dir=="L"):
            create_edge_L(s_,edges[key].pointer[0],edges[key].pointer[1],edges[key].target,edges[key].stringnr)
        else:
            create_edge_R(s_,edges[key].pointer[0],edges[key].pointer[1],edges[key].target,edges[key].stringnr)

def get_edge_label_R(edge):
    global W
    return W[edge.stringnr][edge.pointer[0]:edge.pointer[1]+1]


def get_edge_label_L(edge):
    global W
    s = W[edge.stringnr][edge.pointer[1]:edge.pointer[0]+1]

    return s[::-1]


def print_Edges_R(v,visited,output):

    for key in v.children_R:
        edge = v.children_R[key]
        if not edge in visited:
            label_r = get_edge_label_R(edge)
            label_r = label_r.replace('\n', '')
            #print (key + " : " +str(edge.source.label)+" ("+str(edge.pointer[0])+" , "+str(edge.pointer[1])+" ) ---> " +str(edge.target.label))
            output.append("\n"+str(edge.source.id) + ' -> '+ str(edge.target.id)+ ' [style=solid label="'+ label_r  + '"];')


        visited.append(edge)


        output = print_Edges_R(edge.target,visited,output)

        for key in v.children_L:
            edge = v.children_L[key]
            if not edge in visited:
              #  print(key + " : " + str(edge.source.label) + " (" + str(edge.pointer[0]) + " , " + str(
                 #   edge.pointer[1]) + " ) ---> " + str(edge.target.label))
                if "ε" == get_edge_label_L(edge):
                  continue
                label_l = get_edge_label_L(edge).replace("ε","")
                output.append("\n" + str(edge.source.id) + ' -> ' + str(edge.target.id) + ' [style=solid label="' +label_l + '" color=blue];')

            visited.append(edge)

            output = print_Edges_L(edge.target, visited, output)

    return output

def print_Edges_L(v,visited,output):

    for key in v.children_L:
        edge = v.children_L[key]
        if not edge in visited:
            if "ε" == get_edge_label_L(edge):
                continue
            else:
                label_l = get_edge_label_L(edge).replace("ε","").strip()
                #print (key + " : " +str(edge.source.label)+" ("+str(edge.pointer[0])+" , "+str(edge.pointer[1])+" ) ---> " +str(edge.target.label))
                output.append("\n"+str(edge.source.id) + ' -> '+ str(edge.target.id)+ ' [style=solid label="'+ label_l + '" color=blue];')

        visited.append(edge)


        output = print_Edges_L(edge.target,visited,output)
    return output

def print_Graph_dot(v):
    global V
    global ε
    global bottom
    result = ["digraph G {"]
    for node in V:
        if node == bottom:
            continue
        result.append( str(node.id) + ' [label="' + node.label+ " ("+ str(node.id) + ')"]; \n ')

        if(node.sl != None):
            if node.sl != bottom:
                result.append( str(node.id) + " -> "  + str(node.sl.id) +"[color = red];\n")

        edges = print_Edges_R(v,[],[])


    result.extend(edges)

    result.extend("}")
    return result


def find_w_i_k_edge(s,k):
    global w_i
    w_i_k_edge = s.children_R[w_i[k]]
    print("Finding '" + str(w_i[k]) + "'-edge from " + str(s.label) + " ("+ str(s.id) + ") " + " ("+str(w_i_k_edge.pointer[0])+","+str(w_i_k_edge.pointer[1])+") --> "+str(w_i_k_edge.target.label)+" ("+ str(w_i_k_edge.target.id) + ") ")

    return ((w_i_k_edge.source,(w_i_k_edge.pointer[0],w_i_k_edge.pointer[1]),w_i_k_edge.target,w_i_k_edge.stringnr))

def find_left_w_i_k_edge(s,k):
    global w_i

    if not w_i[k] in s.children_L:
        return None

    w_i_k_edge = s.children_L[w_i[k]]
    print("Finding left '" + str(w_i[k]) + "'-edge from " + str(s.label) + " ("+str(w_i_k_edge.pointer[0])+","+str(w_i_k_edge.pointer[1])+") --> "+str(w_i_k_edge.target.label))

    return ((w_i_k_edge.source,(w_i_k_edge.pointer[0],w_i_k_edge.pointer[1]),w_i_k_edge.target))







w_i = None
e_i = None

sink_edges = []

node_count = -1

ε = None
v_wi = None
bottom = None

V = set()
E_L = set()
E_R = set()



def build_scdawg(W):
    global ε
    global w_i
    global v_wi
    global e_i
    global bottom


    ε = create_node(0,"ε") # init root
    bottom = create_node(-1,"bottom") # init bottom

    ε.sl = bottom # Suffixlink v_ε --> v_bottom

    for i in range(1,len(W)):
        w_i = W[i]
        v_wi = create_node(len(w_i),"v_w"+str(i))

        (s,k) = (ε,1)
        for j in range(1,len(W[i])):

            bottom.children_R[w_i[j]] = Edge(bottom, (-j, -j), ε,i,"R")    # -> bottom --> ε

            (s,k) = update(s,k,j,i)


        add_suffixlink(v_wi,s,k,i)





def update(s,k,p,i):
    global w_i
    global e_i
    global v_wi
    global ε
    c = w_i[p]
    oldr = None
    r_end = None

    s_ = None

    if debug:
        print("*************************************************")
        print("Zeichen: " +c)
        print("*************************************************")

        print("k: "+str(k)+" p:"+str(p))

    while not check_end_point(s,k,p-1,c):
        if debug:
            print("-------------------------------------------------")
            print("Wanderung: "+s.label+" "+str(s.id))
            print("-------------------------------------------------")

        if k <= p - 1:  # implizit
            if s_ == extension(s,k,p-1):
                redirect_edge(s,k,p-1,r,i)
                (s,k) = canonize(s.sl,k,p-1,r,r_end,i)
                continue
            else:
                s_ = extension(s,k,p-1)
                r,r_end = split_edge(s,k,p-1,i)
        else:
            r = s
        create_edge_R(r,p,len(w_i)-1,v_wi,i)

        if oldr != None:
            add_suffixlink(oldr, r, k+r.length-s.length,i)

        l = k-s.length
        if r!=ε:
            l = l-1
        if not w_i[l] in r.children_L:
            create_edge_L(r, l, 1, v_wi, i)

        oldr = r

        s,k = canonize(s.sl,k,p-1,r,r_end,i)

    if oldr != None:
        add_suffixlink(oldr,s,k,i)

    l = k - s.length
    if s != ε:
        l = l - 1

    if not w_i[l] in s.children_L:
        create_edge_L(s, l, 1, v_wi, i)


    return separate_node(s,k,p,i)

def add_suffixlink(s,t,k,i):
    if debug:
        print("-------------------------------------------------")
        print("add_suffixlink")
        print("-------------------------------------------------")
    global ε
    s.sl = t

    create_edge_L(t, k - t.length - 1, k - s.length, s, i)


def check_end_point(s,k,p,c):
    global w_i
    if k <= p: # implizt
        (s,(k_,p_),s_,stnr) = find_w_i_k_edge(s,k)

        return c == W[stnr][k_+p-k+1]
    else:
        return w_i[k] in s.children_R

def canonize(s,k,p,r,r_end,i):
    if debug:
        print("-------------------------------------------------")
        print("canonize")
        print("-------------------------------------------------")

    if k > p: # explizit
        return s,k


    (s, (k_, p_), s_,stnr) = find_w_i_k_edge(s,k)


    old_length = p-k

    while p_ - k_ <= p - k:
        k = k+p_-k_+1
        s = s_
        if k <= p:
            (s, (k_, p_), s_,stnr) = find_w_i_k_edge(s,k)
            if debug:
                print("redirect_left canonize::")

            if r != None:

                    l = k_  - s.length -1
                    if s == ε:
                        l = r_end - old_length

                    left_edge = find_left_w_i_k_edge(s, l)
                    if left_edge == None:
                        continue
                    else:
                        (s, (k__, p__), s__) = left_edge

                    if((k__-p__+1) + s.length < s__.length):
                        create_edge_L(s, k__, r_end - r.length + 1, r, i)  # Umleitung linke Kante


    return s,k

def extension(s,k,p):
    if k > p:
        return s # explizit
    (s, (k_, p_), s_,stnr) = find_w_i_k_edge(s,k)
    return s_

def redirect_edge(s,k,p,r,i):
    if debug:
        print("-------------------------------------------------")
        print("redirect_edge")
        print("-------------------------------------------------")
    global ε


    (s, (k_, p_), s_,stnr) = find_w_i_k_edge(s,k)
    create_edge_R(s,k_,k_+p-k,r,stnr) # Umleitung oberes Stück

    return k_,stnr

def split_edge(s,k,p,i):
    if debug:
        print("-------------------------------------------------")
        print("split edge")
        print("-------------------------------------------------")
    global ε

    (s, (k_, p_), s_,stnr) = find_w_i_k_edge(s,k)
    r = create_node(s.length +(p-k+1),"split: "+w_i[k-s.length:p+1])

    create_edge_R(s,k_,k_+p-k,r,i) # Umleitung oberes Stück
    create_edge_R(r,k_+p-k+1,p_,s_,i) # Unteres Stück

    ## Linke Kanten

    if s.length + (p_ - k_) +1  != s_.length:
        l = k_-s.length-1
        create_edge_L(r,l,p_-s_.length+1,s_,i)

    else:
        copy_edges(s_,r,"L")


    return r,k_+p-k

def separate_node (s,k,p,i):
    global v_wi

    s_,k_ = canonize(s,k,p,None,None,i)
    if debug:
        print("s_ nach separate canonzize "+str(s_.label)+ " ("+str(s_.id)+")")
    if k_ <= p: # implizit
        return (s_,k_)

    if(s_.length == s.length + (p-k+1)):
       return (s_,k_)

    if debug:
        print("-------------------------------------------------")
        print("separate_node")
        print("-------------------------------------------------")

    r_ = create_node(s.length+(p-k+1),"separate:" +w_i[k-s.length:p+1])
    copy_edges(s_,r_,"R")


    l,stnr = redirect_edge(s, k, p, r_, i)
    add_suffixlink(r_, s_.sl, p+1, i)
    add_suffixlink(s_, r_, l+1, stnr)

    create_edge_L(r_,p-r_.length,1,v_wi,i)


    while True:

        redirect_edge(s, k, p, r_, i)

        s,k = canonize(s.sl,k,p-1,r_,p-r_.length,i)
        s__,k__ = canonize(s,k,p,r_,p-r_.length,i)

        if(s_!=s__ and k__!=k):
            break


    return r_,p+1



if __name__ == "__main__":

    # some example strings
    # W = ["ε","ε#cbcabcdcded$"]
    # W = ["ε","ε#xyxxxyxxxxxyxxxxxxyxxxxy$"]
    # W = ["ε","ε#abcbc$","ε#abcab$","ε#abab$"]
    # W = ["ε","ε#cocoaoxyok$","ε#cocoalhov$"]
    # W = ["ε","ε#xyxxxyxxxxx$"]

    parser = argparse.ArgumentParser(description='Creates on-line SCDAWG of a set of strings.')
    parser.add_argument('-i',"--input", required=True,
                        help='path of the inputfile')
    parser.add_argument('-o' ,"--output",  required=True,
                        help='path of the outputfile')

    args = parser.parse_args()
    texts = []
    texts.append("ε")
    with open(args.input) as f:
        lines = f.readlines()

        for line in lines:
            line = line.replace("\n",'')
            text = "ε#" + line +"$"
            texts.append(text)
        W = texts
    build_scdawg(W)

    dot = print_Graph_dot(ε)
    f = open(args.output+".dot", "w", encoding="utf-8")
    for line in dot:
        f.write(line)
    f.close()

    os.system("dot -Tsvg "+ args.output+".dot -o "+args.output+".svg")



