package cdawg_offline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import com.google.common.collect.Multimap;

import dawg.DAWG;
import dawg.Node;
import util.Util;

public class CDAWG_offline {

	public DAWG dawg;
	
	 String label="";
	 String prefixlabel="";
	 Node unreplaceable_node;
	 
	
	public CDAWG_offline(DAWG _dawg){
		
		dawg = _dawg;
		
	}
	
	//*******************************************************************************
	//compact_dawg()
	//*******************************************************************************
	public void compact_dawg()
	{

	// mark nodes with idenification pointers
	    dawg.root.ident_pointers.add(1);



	Iterator it = dawg.endnodes.entrySet().iterator();
	while (it.hasNext()) {
	       Map.Entry pair = (Map.Entry)it.next();
	       Node node = (Node) pair.getValue();
	       while (node!=dawg.root) {
	    	     node.ident_pointers.add((Integer) pair.getKey());
	    	     node=dawg.get_parent(node);
	    	   }

	   }


	for (int r=0;r<dawg.all_nodes.size();r++)
	  {

	   Node node = dawg.all_nodes.get(r);
	    if (node.children.size()>1 && node.ident_pointers.size()==0) {
	      node.ident_pointers.add(-1);
	    }
	  }


	 remove_nodes();


	} // compact_dawg()
	
	
	private void remove_nodes()
	{
	 
	 // remove all but one of nodes ...
	  for (int r=0;r<dawg.all_nodes.size();r++)
	     {
	      Node node = dawg.all_nodes.get(r);
	     if (node.ident_pointers.size()==0) continue;

	    else {

	          if(node.children.size()>0){

	        	  Iterator it = node.children.entrySet().iterator();
	        	  while (it.hasNext()) {
	        		  
	        	    Map.Entry pair = (Map.Entry)it.next();
	        	    
	                int i = (int) pair.getKey();
	                unreplaceable_node = new Node();
	                boolean needs_prefix_link = false;

	                if ( dawg.isReplaceable(node.children.get(i),node,unreplaceable_node,label,needs_prefix_link,prefixlabel) )
	                {
	                 boolean duplicateLabel=false;
	                 
	                 if(unreplaceable_node.id!=-2) System.out.println(dawg.get_node_label(unreplaceable_node));
	                 
	                  node.children.put(i,unreplaceable_node);
	                  
	                    node.labels.put(i,dawg.get_letter_by_idx(i)+label);  

	                  if ( needs_prefix_link ) {

	                      node.prefixLinks.add(unreplaceable_node);
	                      node.prefixlabels.add(prefixlabel);
	                      // cout << "label" << prefixlabel << endl;
	                  }
	                }

	                if ( node != dawg.root )
	                {
	                  boolean duplicatePrefixLabel=false;
	                  Node parentNode = node.suffixLink;
	                  String prefixlabel = dawg.get_PrefixLabel(node,parentNode);

	                  for(int j=0;j<parentNode.prefixlabels.size();j++){
	                    if(parentNode.prefixlabels.get(j)==prefixlabel) duplicatePrefixLabel=true;
	                  }

	                  if(!duplicatePrefixLabel){
	                  parentNode.prefixLinks.add(node);
	                  parentNode.prefixlabels.add(dawg.get_PrefixLabel(node,parentNode));
	                  // cout << "label" << get_PrefixLabel(node,parentNode) << endl;
	                  }
	                }

	            }
	          }
	          else{

	                Node parentNode = node.suffixLink;

	                parentNode.prefixLinks.add(node);

	                parentNode.prefixlabels.add(dawg.get_PrefixLabel(node,parentNode));
	                // cout << "label" << get_PrefixLabel(node,parentNode) << endl;


	          }
	  }// else ident

	  } // for it


	}
	
	
	public void print_automaton(String outputfile)
	{

	String filename = "cdawg.dot";	
		
		
	StringBuilder sb = new StringBuilder();

	//  dotfile
	sb.append("digraph dawg_graph { label=\"CDAWG input text: " + dawg.input_text + "\"");
	sb.append("\n" + "labeljust=l");
	sb.append("\n" + "fontname=Vera");
	sb.append("\n" + "fontsize=20");
	sb.append("\n" + "labelloc=top");
	sb.append("\n" + "margin=.5");
	sb.append("\n" + "size=\"15,7\"");
	sb.append("\n" + "nodesep=.3");
	sb.append("\n" + "node [width=0.5,height=auto,shape=record,fontsize=12,fontcolor=black,style=filled,fillcolor=sandybrown];");
	sb.append("\n" + "edge [minlen=1,constraint=true,fontsize=11,labelfontsize=11];");

	sb.append("\n");
	sb.append("\n");


	//
	  String edge_list = "", node_list= "";
	//  cout << endl << " Nodes" << endl << " -----" << endl;
	  sb.append("/* Nodes */ \n \n");
	//  
	 String nodeslist =  print_nodes();
	 sb.append(nodeslist);
	//  cout << endl << " Edges" << endl << " -----" << endl;
	 sb.append("\n /* Edges */ \n \n");
	//  print_edges(root,edge_list);
	 String edgeslist =  print_edges();
	 sb.append(edgeslist+"}");

	 
	String result = sb.toString();

	Util.writeFile(filename, result);	


	String[] cmd = {"cmd.exe","/c","dot -Tsvg cdawg.dot -o "+outputfile+"_CDAWG.svg"};

	try {

	Process p = Runtime.getRuntime().exec(cmd);
	  
	BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
	  
	String temp = "";
	  
	while ((temp = input.readLine()) != null)
	   System.out.println(temp);
	  
	input.close();

	} catch(IOException e){}


	} // print_automaton()



	//*******************************************************************************
	//print_nodes()
	//*******************************************************************************
	String print_nodes()
	{

	String result= "";

	String node_str;
	StringBuilder node_sstr = new StringBuilder();



	for (int r=0;r<dawg.all_nodes.size();r++){

	Node node = dawg.all_nodes.get(r);
	if (node.ident_pointers.size()>0||node==dawg.root) {


	int node_number;
	if (node.end==-1) node_number=node.end+1;
	else node_number = node.end;


	node_sstr.append(" n_" + node.id + "_" + node_number + " ");


	Multimap<Integer,Integer> equivalence_classes = dawg.get_equivalence_classes(node);

	//
	ArrayList eq_strings_map = dawg.equivalence_classes_to_strings(equivalence_classes);
	//

	//
	String rep = dawg.get_node_label(node);
	System.out.println(rep);
	// cout << " rep: " << rep << endl;
	// cout << " pathlength " << node->pathlength << endl;
	//cout << "-------------" << endl;
	//
	//// cout << node_str << " [label=" << node->end << " id=" << node->id  << " pathlength=" << node->pathlength <<   "];" << endl;
	 node_sstr.append("[label=< id=" + node.id + "<br/> Rep: \"" + rep + "\"<br/>");
	//
	//  
	//

	  for (int i=0;i<eq_strings_map.size();i++){
	        node_sstr.append("s" + (i+1) + ":" + eq_strings_map.get(i));
	        if(i==0)node_sstr.append("<br/>");
	        else node_sstr.append("<br/>>");
	     }
	     node_sstr.append("]; \n");

	   }

	}

	result = node_sstr.toString();


	return result;


	} // print_nodes()

	//*******************************************************************************
	//print_edges()
	//*******************************************************************************
	public String print_edges()
	{


		String result= "";

		   StringBuilder edge_sstr = new StringBuilder();

		for (int r=0;r<dawg.all_nodes.size();r++){
		

	   Node node = dawg.all_nodes.get(r);
	    if (node.ident_pointers.size()>0||node==dawg.root) {
	   int label_count=0;
	  
	   Iterator it = node.children.entrySet().iterator();
	   while (it.hasNext()) {
	  
	    Map.Entry pair = (Map.Entry)it.next();
	  
		   
	   int i = (int) pair.getKey();



	   int node_number;
	   if (node.end==-1) node_number=node.end+1;
	   else node_number = node.end;

	   int node_number_end;
	   if (node.children.get(i).end==-1) node_number_end=0;
	   else node_number_end = node.children.get(i).end;

	   edge_sstr .append(" n_" + node.id + "_" + node_number + " -> n_" + node.children.get(i).id + "_" + node_number_end + " ");
	   

	   String label="";
	   if(node.labels.get(i)==null) label = dawg.get_letter_by_idx(i);
	   else label = node.labels.get(i);
	   
	   String regex = "\\\"";
	//   label = ReplaceAll(label,std::string("\""), std::string(regex));
	   
	//   edge_str = edge_sstr.toString();
	   // cout << edge_str << " ["<< (node->primary[i] ? "primary" : "secondary" ) << " label=" << label << "];" << endl;
	   edge_sstr.append(" [style=" + (node.primary.get(i) ? "solid" : "dashed" ) + "  label=\"" + label + "\"];" + "\n");
	   
	   } // for it node children

	 
	   

//	   String rep = dawg.get_longest_member(node);

	   
//	 if (node.prefixLinks.size()>0) 
//	 {
//		 
//	 for (int k=0;k<node.prefixLinks.size();k++){
//
//	//   string edge_str;
//	//   stringstream edge_sstr;
//
//	   int node_number;
//	   if (node.end==-1) node_number=node.end+1;
//	   else node_number = node.end;
//
//	   int node_number_end;
//	   if (node.prefixLinks.get(k).end==-1) node_number_end=node.prefixLinks.get(k).end+1;
//	   else node_number_end = node.prefixLinks.get(k).end;
//
//	      String label =  node.prefixlabels.get(k);
//	   
//	//   edge_sstr << " n_" << node->id << "_" << node_number << " -> n_" << node->suffixLink->id << "_" << node_number_end << " ";
//		 edge_sstr .append(" n_" + node.id + "_" + node_number + " -> n_" + node.prefixLinks.get(k).id + "_" + node_number_end + " ");
//		 edge_sstr .append(" [color=blue label=\""+ label +"\"];\n");
//	//   edge_str = edge_sstr.str();
//	//   if ( edge_list.find(edge_str) != string::npos ) return;
//	//   cout << edge_str << " ["<< "suffix_link" << "];" << endl;
//	//   dotfile << edge_str << " [color=red];" << endl;
//	//   edge_list+= edge_str;
//	 	}
//	}
	   
	}
	
	} // for all nodes



	result = edge_sstr.toString();

	return result;

	} // print_edges()
	
}
