package alignment_offline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;
import indexstructure.Node;
import util.Util;

public class LineAlignment extends ArrayList<ArrayList<String>> {

	static ArrayList<Node> sinks = new ArrayList<Node>();
	public ArrayList<String> stringset = new ArrayList<String>();

	private static class pair {
		public Node node;
		public HashSet<Integer> ids;
	}

	public LineAlignment(ArrayList stringset, int nlines) {
		super();

		ArrayList<String> strids = new ArrayList<String>();

		Online_CDAWG_sym scdawg = new Online_CDAWG_sym(false);
		scdawg.determineAlphabet(stringset,"",true);
		scdawg.build_cdawg();
		// scdawg.print_automaton("svgs/scdawg");

		Common_SCDAWG_Functions scdawg_functions = new Common_SCDAWG_Functions(scdawg);

		HashMap<Node, Integer> nodes_count = scdawg_functions.count_nodes();

		HashMap count_nodes_sorted = Util.sortByValues(nodes_count, "DESC");

		ArrayList<pair> nodes_sink_set = new ArrayList<pair>();

		count_nodes_sorted.put(scdawg.root, null);
		Iterator it3 = count_nodes_sorted.entrySet().iterator();
		System.out.println("Knoten save alignment:");

		HashSet<Integer> usedIDs = new HashSet<Integer>();
		main_loop: while (it3.hasNext()) {
			Map.Entry pair = (Map.Entry) it3.next();

			Node n = (Node) pair.getKey();
			

			HashSet<Integer> ids = Common_SCDAWG_Functions.find_n_transitions_to_sinks(n, scdawg, new HashSet<Integer>());

			if (ids.size() != nlines) {
				continue;
			}
			for (Integer id : ids) {
				if (usedIDs.contains(id)) {
					continue main_loop;
				}
			}
			for (Integer id : ids) {
				usedIDs.add(id);
			}
			pair p = new pair();
			p.ids = ids;
			p.node = n;
			System.out.println(scdawg.get_node_label(n));
			nodes_sink_set.add(p);
		}
		// handle final nodes (special case if all ocrs are identical)
		sinkloop: for (Node sink : scdawg.sinks) {
			if (sink.stringnumbers.size() == nlines) {
				// it is impossilbe (?) that this node was used before
				// System.out.println("got sink with " + nlines + " sinks");
				// System.out.println(sink.stringnumbers);
				// System.out.println(scdawg.get_node_label(sink));

				// Special case if identical strings had an smaller quasi max node as their sink

				for (pair pn : nodes_sink_set) {
					HashSet<Integer> ids = pn.ids;
					HashSet<Integer> sink_ids = new HashSet<Integer>();

					for (Integer i : sink.stringnumbers) {
						sink_ids.add(i);
					}

					if (sink_ids.equals(ids)) {
						continue sinkloop;
					}
				}

				pair p = new pair();
				p.ids = new HashSet<Integer>();
				for (Integer id : sink.stringnumbers) {
					p.ids.add(id);
				}
				p.node = scdawg.root;
				nodes_sink_set.add(p);
			}
		}

		for (pair p : nodes_sink_set) {
			System.out.println(scdawg.get_node_label(p.node));
			System.out.println(p.ids);
			ArrayList<String> linetupel = new ArrayList<String>();
			for (Integer id : p.ids) {
				int idx = id;

				linetupel.add((String) stringset.get(idx));

				 System.out.println("- " + stringset.get(idx));
				// xyz[idx] = stringset.get(idx);
			}
			this.add(linetupel);
			// System.out.println();
		}

	}

	

}
