package suffix_trie;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

//import org.neo4j.graphdb.GraphDatabaseService;
//import org.neo4j.graphdb.Label;
//import org.neo4j.graphdb.PropertyContainer;
//import org.neo4j.graphdb.Relationship;
//import org.neo4j.graphdb.Transaction;
//import org.neo4j.graphdb.factory.GraphDatabaseFactory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import indexstructure.IndexStructure;
//import indexstructure.IndexStructure.RelTypes;
//import indexstructure.Neo4J_Handler;
import indexstructure.Node;
import util.Util;

public class Naive_Suffixtrie extends IndexStructure {

	Node currentstate, suffixstate, needSL;
	Node current_end, current_node, next_end, next_node;

	Node childstate;

	Node newsink;

	public ArrayList<Node> all_nodes;

	int id_cnt;
	int split_cnt = 0;
	
	public String input_text;
	boolean letters_available;
	boolean print;
	int stringcount;

	int pos = 0;
	int remainder = 0;
	public ArrayList<String> stringset = new ArrayList();

	public HashMap<Integer, Node> endnodes = new HashMap<Integer, Node>();

	public Naive_Suffixtrie(ArrayList<String> _stringset,boolean print) {

		super();
		this.print = print;
		id_cnt = 0;
		stringset = _stringset;
		input_text = "";
		letters_available = true;

		all_nodes = new ArrayList();

	} // Ukkonen_Suffixtree()

	public void build_suffixtrie() {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..building suffix trie ");

		// 1. Create a state named root
		root = create_node(-1, -1, 0, 1);

		current_end = root;

		stringcount = 1;

		while (stringcount <= stringset.size()) {
			input_text = stringset.get(stringcount - 1);
			// cout << input_text << endl;

			pos = 0;

			// 2. For each letter a of w do:

			letters_available = true;
			while (letters_available) {
				update();
				if (pos >= input_text.length())
					letters_available = false;
			} // letters_available

			stringcount++;
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " millieseconds");
		System.out.println(
				" ... memory used:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory free:" + (Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory total:" + (Runtime.getRuntime().totalMemory()));

	}

	/*******************************************************************************
	 * //update() //
	 *******************************************************************************/
	void update() {
		if (print)
			System.out.println(" pos: " + pos + " " + input_text.charAt(pos) );
		// 1. Create a node named next_end and an edge labeled a from current_end
		// to next_end.
		int a = get_letter(pos);
		pos++;

		Node next_end = create_node(pos - (current_end.pathlength + 1), pos, current_end.pathlength + 1, 1);
		create_edge(current_end, next_end, a);

		// 2. Let current_node be current_end and next_node be next_end. Let current_end
		// be next_end

		current_node = current_end;

		next_node = next_end;

		current_end = next_end;
		int runde = 1;
		// 3. While current_node is not root do:
		while (current_node != root) {
			if(print) System.out.println("Rundenlänge "+runde);
			
			// 3.a Let current_node be the node pointed to by the suffix link of
			// current_node.

			current_node = current_node.suffixLink;

			// 3.b Check whether current_node has an outgoing edge labeled a.

			if (!has_outgoing_edge(current_node, a)) {
				// 3.b.1 If current_node does not have an outgoing edge labeled a, then create
				// a new node named next_node and an edge labeled a from current_node to
				// next_node
				Node node = create_node(pos - (current_node.pathlength + 1), pos, current_node.pathlength + 1, 1);
				next_node = node;
				create_edge(current_node, next_node, a);

				// set suffixLink from next_end to next_node
				next_end.suffixLink = next_node;

				// set next_end to next_node
				next_end = next_node;
			}
			// 3.b.2 Else, set suffixLink from next_end to the node which current_node
			// points to and let
			// nnext_end be that node
			else {
				next_end.suffixLink = get_state_of_outgoing_edge(current_node, a);

				next_end = get_state_of_outgoing_edge(current_node, a);

			}
			runde++;
		} // while

		// 4. If there is no suffixlink form next_end to current_node (root) then set
		// suffixlink from nnext_end to current_node
		if (next_end.suffixLink != current_node)
			next_end.suffixLink = current_node;
		
		if (print)
			System.out.println(
					"-----------------------------------------------------------------------------------------");
	} // update()

	// *******************************************************************************
	// get_letter()
	// *******************************************************************************

	int get_letter(int pos) {

		Character letter = input_text.charAt(pos);
		return utf8_sequence_map.get(letter.toString());
	}

	// *******************************************************************************
	// get_equivalence_classes_()
	// *******************************************************************************

	public Multimap<Integer, Integer> get_equivalence_classes(Node node) {
		Multimap<Integer, Integer> result = ArrayListMultimap.create();
		Multimap<Integer, Integer> node_end_positions = node.end_positions;

		Iterator it = node_end_positions.entries().iterator();
		while (it.hasNext()) {
			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			if (pair.getValue() != -1)
				result.put(pair.getKey(), pair.getValue());

		}

		for (int i = 1; i < all_nodes.size(); i++) {

			if (hasConnectionViaSuffixLinks(all_nodes.get(i).suffixLink, node)) {
				node_end_positions = all_nodes.get(i).end_positions;

				it = node_end_positions.entries().iterator();
				while (it.hasNext()) {
					Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
					result.put(pair.getKey(), pair.getValue());

				}

			}

		}

		return result;

	} // get_equivalence_classes()

	// *******************************************************************************
	// equivalence_classes_to_strings()
	// *******************************************************************************

	public ArrayList equivalence_classes_to_strings(Multimap<Integer, Integer> eq) {

		ArrayList result = new ArrayList();

		Iterator it = eq.entries().iterator();

		StringBuilder s1 = new StringBuilder();
		StringBuilder s2 = new StringBuilder();

		int cnt = 0;

		String d = ",";

		while (it.hasNext()) {

			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			// System.out.println(pair.getKey()+ " " + pair.getValue());
			if (pair.getKey() == 1) {
				s1.append(pair.getValue());
				s1.append(d);
			}
			if (pair.getKey() == 2) {
				s2.append(pair.getValue());
				s2.append(d);
			}

		}

		String eqs1 = s1.toString();
		String eqs2 = s2.toString();

		if (eqs1.length() > 0)
			eqs1 = eqs1.substring(0, eqs1.length() - 1);
		if (eqs2.length() > 0)
			eqs2 = eqs2.substring(0, eqs2.length() - 1);

		result.add(eqs1);
		result.add(eqs2);

		// string result =""; string d="";

		// stringstream node_sstr;

		// for (int i=0;i<eq.size();i++){
		// node_sstr << d << eq.at(i); d=",";
		// }
		// result = node_sstr.str();

		return result;

	} // equivalence_classes_to_strings()

	private boolean hasConnectionViaSuffixLinks(Node parentTW, Node node) {
		if (parentTW == node)
			return true;
		if (parentTW == root)
			return false;

		return hasConnectionViaSuffixLinks(parentTW.suffixLink, node);

	}

	private boolean has_outgoing_edge(Node node, int label) {
		Node n = node.children.get(label);
		if (n == null)
			return false;
		return true;
	}

	private Node get_state_of_outgoing_edge(Node node, int label) {
		return node.children.get(label);
	}

	// *******************************************************************************
	// get_letter_by_idx()
	// *******************************************************************************

	public String get_letter_by_idx(int idx) {
		String result = "";
		Iterator it = utf8_sequence_map.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();

			if ((int) pair.getValue() == idx) {
				result = (String) pair.getKey();
				break;
			}
		}

		return result;
	}

	public Node get_parent(Node node) {
		return node.suffixLink;
	} // get_parent()

	public void save_graph_to_db() {

		long startTime = System.currentTimeMillis();
		System.out.println("\n ..saving graph to database ");

		// Neo4J_Handler neo4j = new
		// Neo4J_Handler("C:/Neo4j/Suffixtrie_Naive_DBtest",this);
		//
		// neo4j.connect_and_clear_graphDb();
		// neo4j.create_node_db(root);
		//
		// neo4j.link_children_db(root);
		// neo4j.link_suffixes_db(root);

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds \n");

	}

	// *******************************************************************************
	// create_node()
	// *******************************************************************************

	private Node create_node(int start, int end, int pathlength, int stringnr) {

		// if(pos==-2) node = new Node();
		Node node = new Node(start, end, pathlength, stringnr, id_cnt++);
		all_nodes.add(node);

		return node;
	}

	// private void create_node_db(Node node){
	//
	// try (Transaction tx = db.beginTx()) {
	//
	// org.neo4j.graphdb.Node db_node = db.createNode(Label.label(id_cnt+""));
	// db_node.setProperty("start", node.start);
	// db_node.setProperty("end", node.end);
	// db_node.setProperty("name", this.get_longest_member(node) );
	//
	// tx.success();
	// node.dB_Node = db_node;
	//
	// }
	//
	// }

	// *******************************************************************************
	// create_edge()
	// *******************************************************************************

	public void create_edge(Node parent, Node child, int label) {

		parent.children.put(label, child);

	} // create_edge()

	// *******************************************************************************
	// get_node_label()
	// *******************************************************************************

	public String get_node_label(Node node) {

		String result;

		if (node == root)
			return "λ";
		else
			return stringset.get(0).substring(node.start, node.start + node.pathlength);

	} // get_node_label()

	// *******************************************************************************
	// get_edge_label()
	// *******************************************************************************

	public String get_edge_label(int letter_idx, Node parent, Node node) {
		return stringset.get(0).substring(node.end - 1, node.end);
	} // get_edge_label()

	public void print_tree(String outputfile) {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..printing suffix trie ");

		String filename = outputfile+"_strie.dot";

		StringBuilder sb = new StringBuilder();

		// dotfile
		sb.append("digraph stree_graph { label=\"STrie input text: " + input_text + "\"");
		sb.append("\n" + "labeljust=l");
		sb.append("\n" + "fontname=Vera");
		sb.append("\n" + "fontsize=20");
		sb.append("\n" + "labelloc=top");
		sb.append("\n" + "margin=.5");
		sb.append("\n" + "size=\"15,7\"");
		sb.append("\n" + "nodesep=.3");
		sb.append("\n"
				+ "node [width=0.5,height=auto,shape=record,fontsize=12,fontcolor=black,style=filled,fillcolor=sandybrown];");
		sb.append("\n" + "edge [minlen=1,constraint=true,fontsize=11,labelfontsize=11];");

		sb.append("\n");
		sb.append("\n");

		String edge_list = "", node_list = "";
		sb.append("/* Nodes */ \n \n");

		String nodeslist = print_nodes_rec(root);
		sb.append(nodeslist);
		sb.append("\n /* Edges */ \n \n");
		// print_edges(root,edge_list);
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		Util.writeFile(filename, result);

		String[] cmd = { "cmd.exe", "/c", "dot -Tsvg "+outputfile+ "_strie.dot -o " + outputfile + "_Strie.svg" };

		try {

			Process p = Runtime.getRuntime().exec(cmd);

			BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));

			String temp = "";

			while ((temp = input.readLine()) != null)

				input.close();

		} catch (IOException e) {
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds");

	} // print_automaton()

	public String get_dot() {

		long startTime = System.currentTimeMillis();

		StringBuilder sb = new StringBuilder();

		//
		String edge_list = "", node_list = "";
		// cout << endl << " Nodes" << endl << " -----" << endl;
		//
		String nodeslist = print_nodes_rec(root);
		sb.append(nodeslist);
		// cout << endl << " Edges" << endl << " -----" << endl;
		// print_edges(root,edge_list);
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		return result;

	} // get_dot()

	// *******************************************************************************
	// print_nodes()
	// *******************************************************************************
	String print_nodes() {

		String result = "";

		String node_str;
		StringBuilder node_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);

			int node_number;
			if (node.end == -1)
				node_number = node.end + 1;
			else
				node_number = node.end;

			node_sstr.append(" n_" + node.id + "_" + node_number + " ");

			Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

			//
			ArrayList eq_strings_map = equivalence_classes_to_strings(equivalence_classes);
			//

			//
			String rep = get_node_label(node);

			// cout << " rep: " << rep << endl;
			// cout << " pathlength " << node.pathlength << endl;
			// cout << "-------------" << endl;
			//
			//// cout << node_str << " [label=" << node.end << " id=" << node.id << "
			// pathlength=" << node.pathlength << "];" << endl;
			node_sstr.append("[label=< id=" + node.id + "<br/> Rep: \"" + rep + "\"<br/>>");
			//
			//
			//

			for (int i = 0; i < eq_strings_map.size(); i++) {
				node_sstr.append("s" + (i + 1) + ":" + eq_strings_map.get(i));
				if (i == 0)
					node_sstr.append("<br/>");
				else
					node_sstr.append("<br/>>");
			}
			node_sstr.append("]; \n");

		}

		result = node_sstr.toString();

		return result;

	} // print_nodes()

	// *******************************************************************************
	// print_nodes_rec()
	// *******************************************************************************
	String print_nodes_rec(Node node) {

		String result = "";

		StringBuilder node_sstr = new StringBuilder();

		String node_str = "";

		int node_number;
		if (node.end == -1)
			node_number = node.end + 1;
		else
			node_number = node.end;

		node_sstr.append(" n_" + node.id + "_" + node_number + " ");

		String rep = "";
		if (node != root)
			rep = this.get_node_label(node);
		else
			rep = "λ";

//		node_sstr.append("[label=< id=" + node.id + "<br/> Rep: \"" + rep + "\"<br/>>");
		node_sstr.append("[label=< Rep: \"" + rep + "\"<br/>>");

		// for (int i=0;i<eq_strings_map.size();i++){
		// node_sstr.append("s" + (i+1) + ":" + eq_strings_map.get(i));
		// if(i==0)node_sstr.append("<br/>");
		// else node_sstr.append("<br/>>");
		// }
		node_sstr.append("]; \n");

		StringBuilder childlevel = new StringBuilder();
		childlevel.append("{ rank= same; ");

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();

			Node child = (Node) pair.getValue();
			int i = (int) pair.getKey();

			String child_node_str = print_nodes_rec(child);
			node_sstr.append(child_node_str);

			int node_number_end;
			if (node.children.get(i).end == -1)
				node_number_end = 0;
			else
				node_number_end = node.children.get(i).end;

			childlevel.append(" n_" + node.children.get(i).id + "_" + node_number_end + "; ");

		}

		childlevel.append("}");

		node_sstr.append(childlevel.toString() + "\n");

		result = node_sstr.toString();

		return result;

	} // print_nodes_rec()

	// *******************************************************************************
	// print_edges()
	// *******************************************************************************
	public String print_edges() {

		String result = "";

		StringBuilder edge_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);

			Iterator it = node.children.entrySet().iterator();
			while (it.hasNext()) {

				Map.Entry pair = (Map.Entry) it.next();

				int i = (int) pair.getKey();

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.children.get(i).end == -1)
					node_number_end = 0;
				else
					node_number_end = node.children.get(i).end;

				edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" + node.children.get(i).id + "_"
						+ node_number_end + " ");

				String label = "";
				label = get_edge_label(i, node, node.children.get(i));

				String regex = "\\\"";
				// label = ReplaceAll(label,std::string("\""), std::string(regex));

			
				edge_sstr.append(" [style=" + "solid" + "  label=\"" + label + "\"];" + "\n");

			} // for it node children

			Node suffixLink = node.suffixLink;

			if (suffixLink != null) {
				// string edge_str;
				// stringstream edge_sstr;

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.suffixLink.end == -1)
					node_number_end = node.suffixLink.end + 1;
				else
					node_number_end = node.suffixLink.end;
//
				edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" + node.suffixLink.id + "_"
						+ node_number_end + " ");
				edge_sstr.append(" [color=red];\n");
				
			}

			// edge_list+= edge_str;

			// if (node.prefixLinks.size()>0)
			// {
			//
			// for (int k=0;k<node.prefixLinks.size();k++){
			// string edge_str;
			// stringstream edge_sstr;
			//
			// int node_number;
			// if (node.end==-1) node_number=node.end+1;
			// else node_number = node.end;
			//
			// int node_number_end;
			// if (node.prefixLinks[k].end==-1) node_number_end=node.prefixLinks[k].end+1;
			// else node_number_end = node.prefixLinks[k].end;
			//
			// edge_sstr << " n_" << node.id << "_" << node_number << " . n_" <<
			// node.prefixLinks[k].id << "_" << node_number_end << " ";
			// edge_str = edge_sstr.str();
			//
			// string label = node.prefixlabels[k];
			// string regex = "\\\"";
			// label = ReplaceAll(label,std::string("\""), std::string(regex));
			// // if ( edge_list.find(edge_str) != string::npos ) return;
			// // cout << edge_str << " ["<< "prefix_link label=" << node.prefixlabels[k] <<
			// "];" << endl;
			// dotfile << edge_str << " [color=blue label=\"" << label << "\"];" << endl;
			// edge_list+= edge_str;
			//
			// }
			// }

			// }
		} // for all nodes

		result = edge_sstr.toString();

		return result;

	} // print_edges()

}
