import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import cdawg.Online_CDAWG;
import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;

import dawg.DAWG;
import indexstructure.Node;
import suffix_tree.Ukkonen_Suffixtree;
import suffix_trie.Naive_Suffixtrie;
import util.Util;
import com.sun.tools.javac.util.Pair;

import alignment_offline.Endpos_Tupel;

import org.apache.commons.cli.*;

public class findLongestCommonSubstrings {

	public static void main(String[] args) {
		ArrayList stringset = new ArrayList();
			

		
		Options options = new Options();

        Option input = new Option("i", "input", true, "input file path");
        input.setRequired(true);
        options.addOption(input);

        Option output= new Option("o", "output", true, "output");
        output.setRequired(false);
        options.addOption(output);
        
        Option debug = new Option("d", "debug", false, "enable debug print");
        debug.setRequired(false);
        options.addOption(debug);
        
    

        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;

        try {
            cmd = parser.parse(options, args);
        } catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("utility-name", options);

            System.exit(1);
        }

        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");


        boolean debugbool = false;

        if(cmd.hasOption("debug")) {
	        String debugstring = cmd.getOptionValue("debug");
	        
	      	debugbool = true;
	        
        
        }
        
        

		try {
		stringset = Util.readInputFile(inputFilePath);
		} catch (IOException e) {
			e.printStackTrace();
		}
			
	               
    		 Online_CDAWG_sym scdawg = new Online_CDAWG_sym(debugbool);
    		 scdawg.determineAlphabet(stringset,"",debugbool);
    		 scdawg.build_cdawg();
    		 scdawg.print_automaton_new(outputFilePath);
    		 System.out.println("Nodes: " +scdawg.all_nodes.size());
    		 System.out.println("Edges R: " +scdawg.count_edges(scdawg.all_nodes));
    		 System.out.println("Edges L: " +scdawg.count_edges_left(scdawg.all_nodes));

    		 Common_SCDAWG_Functions func = new Common_SCDAWG_Functions(scdawg);
    		 
    	  			 System.out.println("Quasimaximal Nodes:");

        		 ArrayList<Endpos_Tupel> r = func.get_quasi_maximal_nodes_new();
         		 for (Endpos_Tupel entry : r) {
 				
 				    System.out.println(scdawg.get_node_label(entry.node) + " " +  entry.endpos+" "+entry.stringnr);
 			
 			 }


    		 

		 java.io.PrintStream out = System.out;
		 Runtime runtime = Runtime.getRuntime();

			// To convert from Bytes to MegaBytes:
			// 1 MB = 1024 KB and 1 KB = 1024 Bytes.
			// Therefore, 1 MB = 1024 * 1024 Bytes.
			long MegaBytes = 1024 * 1024;

			// Memory which is currently available for use by heap
			long totalMemory = runtime.totalMemory() / MegaBytes;
			out.println("Heap size available for use -> " + totalMemory + " MB");

			// Maximum memory which can be used if required.
			// The heap cannot grow beyond this size
			long maxMemory = runtime.maxMemory() / MegaBytes;
			out.println("Maximum memory Heap can use -> " + maxMemory + " MB");

			// Free memory still available
			long freeMemory = runtime.freeMemory() / MegaBytes;
			out.println("Free memory in heap -> " + freeMemory + " MB");

			// Memory currently used by heap
			long memoryInUse = totalMemory - freeMemory;
			out.println("Memory already used by heap -> " + memoryInUse + " MB");



	}
	
	
	

}

