package dawg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import indexstructure.IndexStructure;
//import indexstructure.Neo4J_Handler;
import util.Util;

public class DAWG extends IndexStructure {

	Node currentsink, currentstate, suffixstate;

	public Node root;

	Node childstate;

	Node newsink;

	public ArrayList<Node> all_nodes;

	int id_cnt;
	int split_cnt = 0;

	public String input_text;
	public ArrayList<String> stringset = new ArrayList();

	boolean letters_available;

	int stringcount;

	int pos = 0;

	public HashMap<Integer, Node> endnodes = new HashMap<Integer, Node>();

	public DAWG(ArrayList<String> _stringset) {

		super();

		id_cnt = 0;
		stringset = _stringset;
		input_text = "";
		letters_available = true;

		all_nodes = new ArrayList();

	} // Dawg()

	public void build_dawg() {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..building DAWG ");

		// 1. Create a state named source and let currentsink be source.
		root = create_node(-1, 0, 1);

		currentsink = root;
		stringcount = 1;

		while (stringcount <= stringset.size()) {
			input_text = stringset.get(stringcount - 1);
			// cout << input_text << endl;

			pos = 0;

			// 2. For each letter a of w do:

			letters_available = true;
			while (letters_available) {
				// Let currentsink be update(currentsink,a)
				currentsink = update(currentsink);
				if (pos >= input_text.length())
					letters_available = false;
			} // letters_available

			// words[currentsink] = stringcount;
			endnodes.put(stringcount, currentsink);

			currentsink.is_endNode = true;

			// reset currentsink
			currentsink = root;
			stringcount++;
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " millieseconds");
		System.out.println(
				" ... memory used:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory free:" + (Runtime.getRuntime().freeMemory()));
		System.out.println(" ... memory total:" + (Runtime.getRuntime().totalMemory()));
	}

	// *******************************************************************************
	// split()
	// *******************************************************************************
	public Node split(Node parentstate, Node childstate, int a, int pos) {

		split_cnt++;

		// 1. Create a state called newchildstate.
		Node newchildstate = create_node(pos, parentstate.pathlength + 1, stringcount);

		// 2. Make the secondary edge from parentstate to childstate into a primary edge
		// from parentstate to newchildstate (with the same label).

		create_edge(parentstate, newchildstate, a, true);

		// 3. For every primary and secondary outgoing edge of childstate, create a
		// secondary
		// outgoing edge of newchildstate with the same label and leading to the same
		// state.

		Iterator it = childstate.children.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();
			int i = (int) pair.getKey();
			create_edge(newchildstate, (Node) pair.getValue(), i, false);

		}

		// 4. Set the suffix pointer of newchildstate equal to that of childstate.

		newchildstate.suffixLink = childstate.suffixLink;

		// 5. Reset the suffix pointer of childstate to point to newchildstate.

		childstate.suffixLink = newchildstate;

		// 6. Let currentstate be parentstate.

		currentstate = parentstate;

		// 7. While currentstate is not source root do:

		while (currentstate != root) {
			// (a) Let currentstate be the state pointed to by the suffix pointer of
			// currentstate.

			currentstate = currentstate.suffixLink;

			// (b) .If currentstate has a secondary edge to childstate, make it a secondary
			// edge
			// to newchildstate (with the same label).

			boolean currentstate_has_a_secondary_edge_to_childstate = false;

			if (get_state_of_outgoing_edge(currentstate, a) == childstate && !currentstate.primary.get(a)) {
				currentstate_has_a_secondary_edge_to_childstate = true;
				create_edge(currentstate, newchildstate, a, false);
			}

			// (c) Else, break out of the while loop.
			if (!currentstate_has_a_secondary_edge_to_childstate)
				break;

		} // while

		// 8. Return newchildstate.

		return newchildstate;

	} // split()

	// *******************************************************************************
	// update()
	// *******************************************************************************
	private Node update(Node currentsink) {

		int a = get_next_letter();
		if (has_outgoing_edge(currentsink, a)) {

			newsink = get_state_of_outgoing_edge(currentsink, a);
			if (currentsink.primary.get(a)) {
				newsink.update_end_positions(pos, stringcount);

				return newsink;
			} else
				return split(currentsink, newsink, a, pos);

		}

		// 1. Create a state named newsink and a primary edge labeled a from currentsink
		// to newsink.

		newsink = create_node(pos, currentsink.pathlength + 1, stringcount);
		create_edge(currentsink, newsink, a, true);

		// 2. Let currentstate be currentsink and let suffixstate be undefined.

		currentstate = currentsink;

		suffixstate = null;

		// 3. While currentstate is not source and suffixstate is undefined do:
		while (currentstate != root && suffixstate == null) {
			// 3.a Let currentstate be the state pointed to by the suffix pointer of
			// currentstate.

			currentstate = currentstate.suffixLink;

			// 3.b Check whether currentstate has an outgoing edge labeled a.

			if (!has_outgoing_edge(currentstate, a)) {
				// 3.b.1 If currentstate does not have an outgoing edge labeled a, then create
				// a secondary edge from currentstate to newsink labeled a.
				create_edge(currentstate, newsink, a, false);

			}
			// 3.b.2 Else, if currentstate has a primary outgoing edge labeled a, then let
			// suffixstate be the state to which this edge leads.
			else {
				if (currentstate.primary.get(a)) {
					suffixstate = get_state_of_outgoing_edge(currentstate, a);
				}

				else {
					// 3.b.3 Else (currentstate has a secondary outgoing edge labeled a):
					// 3.b.3.a Let childstate be the state that the outgoing edge labeled a leads
					// to.
					childstate = get_state_of_outgoing_edge(currentstate, a);

					// 3.b.3.b Let suffixstate be split( currentstate, childstate).
					suffixstate = split(currentstate, childstate, a, -1);
				}
			}
		} // while

		// 4. If suffixstate is still undefined, let suffixstate be source root.
		if (suffixstate == null)
			suffixstate = root;

		// 5. Set the suffix pointer of newsink to point to suffixstate and return
		// newsink.
		newsink.suffixLink = suffixstate;

		return newsink;

	}

	// *******************************************************************************
	// isReplaceable()
	// *******************************************************************************
	public boolean isReplaceable(Node node, Node start_node, Node unreplaceable_node, String label,
			boolean needs_prefix_link, String prefixlabel) {
		int n_children = 0;
		Node child_node = new Node();
		String childlabel = "";

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();

			int i = (int) pair.getKey();
			if (node.children.get(i) != null) {
				n_children++;
				child_node = node.children.get(i);

				// int stringnr=0;
				// vector<map<int,int> > equivalence_classes =
				// get_equivalence_classes(child_node);
				// map <int,int> end_position = equivalence_classes[0];
				// for (map<int,int>::iterator it=end_position.begin(); it!=end_position.end();
				// ++it)
				// {
				// stringnr = it->first;
				// }
				// string s = stringset[stringnr-1];

				childlabel = get_letter_by_idx(i);

			}
		} // for it

		if (n_children == 1 && node.ident_pointers.size() == 0) {

			isReplaceable(child_node, start_node, unreplaceable_node, label, needs_prefix_link, prefixlabel);

			if (node.suffixLink == start_node) {
				needs_prefix_link = true;
				prefixlabel = get_PrefixLabel(node, start_node);
			}

			label = childlabel + label;
			return true;
		}

		label = "";
		unreplaceable_node = node;
		return false;

	} // isReplaceable()

	// *******************************************************************************
	// get_PrefixLabel()
	// *******************************************************************************
	public String get_PrefixLabel(Node node, Node parentNode) {

		String rep = get_node_label(node);
		String rep2 = get_node_label(parentNode);

		return rep.substring(0, rep.length() - rep2.length());

	} // get_PrefixLabel()

	// *******************************************************************************
	// get_node_label()
	// *******************************************************************************

	public String get_node_label(Node node) {

		String result;

		if (node == root)
			return "λ";

		Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

		Integer firstKey = (Integer) equivalence_classes.keySet().toArray()[0];
		Collection<Integer> values = equivalence_classes.get((Integer) firstKey);

		Integer value = 0;

		Iterator it = values.iterator();
		while (it.hasNext()) {

			Integer firstValue = (Integer) it.next();

			if (firstValue > 0) {
				value = firstValue;
				break;
			}

		}

		result = stringset.get(firstKey - 1).substring((value - node.pathlength), value);

		return result;

	} // get_node_label()

	// *******************************************************************************
	// get_edge_label()
	// *******************************************************************************

	public String get_edge_label(Node node) {

		String result = "";

		Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

		Integer firstKey = (Integer) equivalence_classes.keySet().toArray()[0];
		Collection<Integer> values = equivalence_classes.get((Integer) firstKey);

		Integer value = 0;

		Iterator it = values.iterator();
		while (it.hasNext()) {

			Integer firstValue = (Integer) it.next();

			if (firstValue > 0) {
				value = firstValue;
				break;
			}

		}

		return stringset.get(firstKey - 1).substring(value - 1, value);

	}

	// *******************************************************************************
	// get_edge_label()
	// *******************************************************************************

	public String get_edge_label(int letter_idx, Node parent, Node node) {

		return this.get_letter_by_idx(letter_idx);

	}

	// *******************************************************************************
	// get_equivalence_classes_()
	// *******************************************************************************

	public Multimap<Integer, Integer> get_equivalence_classes(Node node) {
		Multimap<Integer, Integer> result = ArrayListMultimap.create();
		Multimap<Integer, Integer> node_end_positions = node.end_positions;

		Iterator it = node_end_positions.entries().iterator();
		while (it.hasNext()) {
			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			if (pair.getValue() != -1)
				result.put(pair.getKey(), pair.getValue());

		}

		for (int i = 1; i < all_nodes.size(); i++) {

			if (hasConnectionViaSuffixLinks(all_nodes.get(i).suffixLink, node)) {
				node_end_positions = all_nodes.get(i).end_positions;

				it = node_end_positions.entries().iterator();
				while (it.hasNext()) {
					Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
					result.put(pair.getKey(), pair.getValue());

				}

			}

		}

		return result;

	} // get_equivalence_classes()

	// *******************************************************************************
	// equivalence_classes_to_strings()
	// *******************************************************************************

	public ArrayList equivalence_classes_to_strings(Multimap<Integer, Integer> eq) {

		ArrayList result = new ArrayList();

		Iterator it = eq.entries().iterator();

		StringBuilder s1 = new StringBuilder();
		StringBuilder s2 = new StringBuilder();

		int cnt = 0;

		String d = ",";

		while (it.hasNext()) {

			Map.Entry<Integer, Integer> pair = (Map.Entry) it.next();
			// System.out.println(pair.getKey()+ " " + pair.getValue());
			if (pair.getKey() == 1) {
				s1.append(pair.getValue());
				s1.append(d);
			}
			if (pair.getKey() == 2) {
				s2.append(pair.getValue());
				s2.append(d);
			}

		}

		String eqs1 = s1.toString();
		String eqs2 = s2.toString();

		if (eqs1.length() > 0)
			eqs1 = eqs1.substring(0, eqs1.length() - 1);
		if (eqs2.length() > 0)
			eqs2 = eqs2.substring(0, eqs2.length() - 1);

		result.add(eqs1);
		result.add(eqs2);

		// string result =""; string d="";

		// stringstream node_sstr;

		// for (int i=0;i<eq.size();i++){
		// node_sstr << d << eq.at(i); d=",";
		// }
		// result = node_sstr.str();

		return result;

	} // equivalence_classes_to_strings()

	private boolean hasConnectionViaSuffixLinks(Node parentTW, Node node) {
		if (parentTW == node)
			return true;
		if (parentTW == root)
			return false;

		return hasConnectionViaSuffixLinks(parentTW.suffixLink, node);

	}

	private boolean has_outgoing_edge(Node node, int label) {
		return (node.children.get(label) != null);
	}

	private Node get_state_of_outgoing_edge(Node node, int label) {
		return node.children.get(label);
	}

	private int get_next_letter() {

		String letter = input_text.substring(pos, pos + 1);
		int result = utf8_sequence_map.get(letter);
		pos++;
		return result;
	}

	public Node get_parent(Node node) {
		return node.suffixLink;
	} // get_parent()

	public void save_graph_to_db() {

		long startTime = System.currentTimeMillis();
		System.out.println("\n ..saving graph to database ");

		// Neo4J_Handler neo4j = new Neo4J_Handler("C:/Neo4j/Neo4jDAWGDB_test",this);

		// neo4j.connect_and_clear_graphDb();
		// neo4j.create_node_db(root);
		//
		// neo4j.link_children_db(root);
		// neo4j.link_suffixes_db(root);

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds \n");

	}

	// *******************************************************************************
	// create_node()
	// *******************************************************************************

	private Node create_node(int pos, int pathlength, int stringnr) {

		Node node = new Node(pos, pathlength, stringnr, id_cnt++);

		all_nodes.add(node);

		return node;
	}

	// *******************************************************************************
	// create_edge()
	// *******************************************************************************

	public void create_edge(Node parent, Node child, int label, boolean isPrimary) {

		parent.children.put(label, child);

		if (isPrimary)
			parent.primary.put(label, true);
		else
			parent.primary.put(label, false);

	} // create_edge()

	public void print_automaton(String outputfile) {

		long startTime = System.currentTimeMillis();
		System.out.println(" ..printing DAWG ");

		String filename = outputfile+"_dawg.dot";

		StringBuilder sb = new StringBuilder();

		// dotfile
		sb.append("digraph dawg_graph { ");
		sb.append("\n" + "labeljust=l");
		sb.append("\n" + "fontname=Vera");
		sb.append("\n" + "fontsize=20");
		sb.append("\n" + "labelloc=top");
		sb.append("\n" + "margin=.5");
		sb.append("\n" + "size=\"15,7\"");
		sb.append("\n" + "nodesep=.3");
		sb.append("\n"
				+ "node [width=0.5,height=auto,shape=record,fontsize=12,fontcolor=black,style=filled,fillcolor=sandybrown];");
		sb.append("\n" + "edge [minlen=1,constraint=true,fontsize=11,labelfontsize=11];");

		sb.append("\n");
		sb.append("\n");

		//
		String edge_list = "", node_list = "";
		sb.append("/* Nodes */ \n \n");
		//
		String nodeslist = print_nodes();
		sb.append(nodeslist);
		sb.append("\n /* Edges */ \n \n");
		// print_edges(root,edge_list);
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		Util.writeFile(filename, result);

		String[] cmd = { "cmd.exe", "/c", "dot -Tsvg "+outputfile+ "_dawg.dot -o " + outputfile + "_DAWG.svg" };

		try {

			Process p = Runtime.getRuntime().exec(cmd);

			BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));

			String temp = "";

			while ((temp = input.readLine()) != null)
				System.out.println(temp);

			input.close();

		} catch (IOException e) {
		}

		long duration = System.currentTimeMillis() - startTime;
		System.out.println(" ... took " + duration + " milliseconds");

	} // print_automaton()

	public String get_dot() {

		long startTime = System.currentTimeMillis();

		StringBuilder sb = new StringBuilder();

		// dotfile

		String edge_list = "", node_list = "";
		String nodeslist = print_nodes();
		sb.append(nodeslist);
		
		String edgeslist = print_edges();
		sb.append(edgeslist + "}");

		String result = sb.toString();

		return result;

	} // get_dot()

	// *******************************************************************************
	// print_nodes()
	// *******************************************************************************
	String print_nodes() {

		String result = "";

		String node_str;
		StringBuilder node_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);

			int node_number;
			if (node.end == -1)
				node_number = node.end + 1;
			else
				node_number = node.end;

			node_sstr.append(" n_" + node.id + "_" + node_number + " ");

			Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

			//
			ArrayList eq_strings_map = equivalence_classes_to_strings(equivalence_classes);
			//

			//
			String rep = get_node_label(node);

		
//			node_sstr.append("[label=< id=" + node.id + "<br/> Rep: \"" + rep + "\"<br/>");
			node_sstr.append("[label=<\"" + rep + "\">");

			//
			//
			//
//
//			for (int i = 0; i < eq_strings_map.size(); i++) {
//				node_sstr.append("s" + (i + 1) + ":" + eq_strings_map.get(i));
//				if (i == 0)
//					node_sstr.append("<br/>");
//				else
//					node_sstr.append("<br/>>");
//			}
			node_sstr.append("];\n");

		}

		result = node_sstr.toString();

		return result;

	} // print_nodes()

	// *******************************************************************************
	// print_nodes_rec()
	// *******************************************************************************
	String print_nodes_rec(Node node) {

		String result = "";

		StringBuilder node_sstr = new StringBuilder();

		String node_str = "";

		int node_number;
		if (node.end == -1)
			node_number = node.end + 1;
		else
			node_number = node.end;

		node_sstr.append(" n_" + node.id + "_" + node_number + " ");

		Multimap<Integer, Integer> equivalence_classes = get_equivalence_classes(node);

		ArrayList eq_strings_map = equivalence_classes_to_strings(equivalence_classes);

		String rep = get_node_label(node);

		// node_sstr.append("[label=< id=" + node.id + "<br/> Rep: \"" + rep +
		// "\"<br/>");
		node_sstr.append("[label=<\"" + rep + "\">");
		//
		// for (int i = 0; i < eq_strings_map.size(); i++) {
		// node_sstr.append("s" + (i + 1) + ":" + eq_strings_map.get(i));
		// if (i == 0)
		// node_sstr.append("<br/>");
		// else
		// node_sstr.append("<br/>>");
		// }
		node_sstr.append("];");

		StringBuilder childlevel = new StringBuilder();
		childlevel.append("{ rank= same; ");

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();

			Node child = (Node) pair.getValue();
			int i = (int) pair.getKey();

			String child_node_str = print_nodes_rec(child);
			node_sstr.append(child_node_str);

			int node_number_end;
			if (node.children.get(i).end == -1)
				node_number_end = 0;
			else
				node_number_end = node.children.get(i).end;

			if (node.primary.get(i))
				childlevel.append(" n_" + node.children.get(i).id + "_" + node_number_end + "; ");

		}

		childlevel.append("}");

		node_sstr.append(childlevel.toString());

		result = node_sstr.toString();

		return result;

	} // print_nodes_rec()

	// *******************************************************************************
	// print_edges()
	// *******************************************************************************
	public String print_edges() {

		String result = "";

		StringBuilder edge_sstr = new StringBuilder();

		for (int r = 0; r < all_nodes.size(); r++) {

			Node node = all_nodes.get(r);
			// if (node->ident_pointers.size()>0||node==root) {
			int label_count = 0;

			Iterator it = node.children.entrySet().iterator();
			while (it.hasNext()) {

				Map.Entry pair = (Map.Entry) it.next();

				int i = (int) pair.getKey();

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.children.get(i).end == -1)
					node_number_end = 0;
				else
					node_number_end = node.children.get(i).end;

				edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" + node.children.get(i).id + "_"
						+ node_number_end + " ");

				String label = "";
				label = get_edge_label(i, node, node.children.get(i));
				String regex = "\\\"";

			
				edge_sstr.append(
						" [style=" + (node.primary.get(i) ? "solid" : "dashed") + "  label=\"" + label + "\"];\n");

			} // for it node children

			Node suffixLink = node.suffixLink;

			if (suffixLink != null) {
				// string edge_str;
				// stringstream edge_sstr;

				int node_number;
				if (node.end == -1)
					node_number = node.end + 1;
				else
					node_number = node.end;

				int node_number_end;
				if (node.suffixLink.end == -1)
					node_number_end = node.suffixLink.end + 1;
				else
					node_number_end = node.suffixLink.end;
//
				 edge_sstr.append(" n_" + node.id + "_" + node_number + " -> n_" +
				 node.suffixLink.id + "_"
				 + node_number_end + " ");
				 edge_sstr.append(" [color=red];");

			}

			// edge_list+= edge_str;
			label_count++;

			// if (node.prefixLinks.size()>0)
			// {
			//
			// for (int k=0;k<node->prefixLinks.size();k++){
			// string edge_str;
			// stringstream edge_sstr;
			//
			// int node_number;
			// if (node->end==-1) node_number=node->end+1;
			// else node_number = node->end;
			//
			// int node_number_end;
			// if (node->prefixLinks[k]->end==-1)
			// node_number_end=node->prefixLinks[k]->end+1;
			// else node_number_end = node->prefixLinks[k]->end;
			//
			// edge_sstr << " n_" << node->id << "_" << node_number << " -> n_" <<
			// node->prefixLinks[k]->id << "_" << node_number_end << " ";
			// edge_str = edge_sstr.str();
			//
			// string label = node->prefixlabels[k];
			// string regex = "\\\"";
			// label = ReplaceAll(label,std::string("\""), std::string(regex));
			// // if ( edge_list.find(edge_str) != string::npos ) return;
			// // cout << edge_str << " ["<< "prefix_link label=" << node->prefixlabels[k]
			// << "];" << endl;
			// dotfile << edge_str << " [color=blue label=\"" << label << "\"];" << endl;
			// edge_list+= edge_str;
			//
			// }
			// }

			// }
		} // for all nodes

		result = edge_sstr.toString();

		return result;

	} // print_edges()

	public int count_edges_rec(int count, Node node, HashSet used_nodes) {
		count += node.children.size();

		HashSet<Node> child_nodes = new HashSet<Node>();

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();
			if (!used_nodes.contains(pair.getValue())) {
				child_nodes.add((Node) pair.getValue());
				used_nodes.add(pair.getValue());

			}
		}

		for (Node child : child_nodes) {
			count = count_edges_rec(count, child, used_nodes);
		}

		return count;

	}

	public int count_edges_dawg(ArrayList<Node> allnodes) {
		int count = 0;

		for (Node n : allnodes) {
			count += n.children.size();
		}

		return count;

	}
	
	
	public String[] getTopNNodes() {
		int n = 10;
		
		ArrayList<String> node_reps_list = new ArrayList<String>();
		
		String[] node_reps = new String[this.all_nodes.size()];

		for (int i=0;i<this.all_nodes.size();i++) {
			node_reps[i] = this.get_node_label(this.all_nodes.get(i));
		}
		
		
//		this.eachNode_DFS(this.root, false, false, new IndexStructure.Visitor() {
//		 public void visit(Node n){
//			node_reps_list.add(this.get_node_label(n));
//		 }
//		 });
//		
//		
//		String[] node_reps = new String[node_reps_list.size()];
//		
//		for(int i=0;i<node_reps_list.size();i++) {
//			node_reps[i] = node_reps_list.get(i);
//		}
		
		Arrays.sort(node_reps, (b, a)->Integer.compare(a.length(), b.length()));

		
		for (int i=0;i<node_reps.length;i++) {
			System.out.println(node_reps[i]);
		}
		String [] result = new String[n];
		
		
		return result;
		
	}
	

}
