package alignment_offline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.glassfish.grizzly.utils.Pair;

import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;
import indexstructure.Node;
import util.Util;

public class LineAlignment_Fast extends ArrayList {

	static ArrayList<Node> sinks = new ArrayList<Node>();
	public ArrayList<String> stringset = new ArrayList<String>();
	public ArrayList<pair> nodes_sink_set = new ArrayList<pair>();

	public Online_CDAWG_sym scdawg ;
	private static class pair {
		public Node node;
		public HashSet<Integer> ids;
	}

	public LineAlignment_Fast(ArrayList stringset, int nlines, ArrayList gt_ids, ArrayList ocr_ids) {
		super();

		ArrayList<String> strids = new ArrayList<String>();

		scdawg = new Online_CDAWG_sym(false);
		scdawg.determineAlphabet(stringset,"",false);
		scdawg.build_cdawg();
		
		this.stringset = stringset;
		
		Common_SCDAWG_Functions scdawg_functions = new Common_SCDAWG_Functions(scdawg);
//	    scdawg.print_automaton("svgs/scdawg");

		HashMap<Node,HashSet<Integer>> nodes_with_n_occs = scdawg_functions.get_n_string_occurences(nlines);
		
		

//		Common_SCDAWG_Functions scdawg_functions = new Common_SCDAWG_Functions(scdawg);
//
//		HashMap<Node, Integer> nodes_count = scdawg_functions.count_nodes();
//
		HashMap<Node,HashSet<Integer>> nodes_sorted = Util.sortByNodeLength(nodes_with_n_occs, "DESC",scdawg);
//
//
		Iterator<Entry<Node, HashSet<Integer>>> it3 = nodes_sorted.entrySet().iterator();

		HashSet<Integer> usedIDs = new HashSet<Integer>();
		System.out.println("Gefundene Knoten");

		main_loop: while (it3.hasNext()) {
			Map.Entry<Node,HashSet<Integer>> pair = it3.next();

			Node n = (Node) pair.getKey();
			HashSet<Integer> ids = (HashSet<Integer>) pair.getValue();
//			System.out.println(scdawg.get_node_label(n));

			if (ids.size() != nlines) {
				continue;
			}
			for (Integer id : ids) {
				if (usedIDs.contains(id)) {
					continue main_loop;
				}
			}
			boolean gt_found = false;
			boolean ocr_found = false;
			
			ArrayList gt_ocr_test = new ArrayList();
			for (Integer id : ids) {
				if(gt_ids.contains(id)){
				     gt_found=true;
				}
				else if(ocr_ids.contains(id)){
				    ocr_found=true;
				}
				
			}
			if (!(gt_found&&ocr_found)) {
				continue main_loop;
			}
			
			for (Integer id : ids) {
				usedIDs.add(id);
			}
			pair p = new pair();
			p.ids = ids;
			p.node = n;
//			System.out.println(scdawg.get_node_label(n));
			nodes_sink_set.add(p);
		}
		
		
//		// handle final nodes (special case if all ocrs are identical)
		sinkloop: for (Node sink : scdawg.sinks) {
			if (sink.stringnumbers.size() == nlines) {
				// it is impossilbe (?) that this node was used before
				// System.out.println("got sink with " + nlines + " sinks");
				// System.out.println(sink.stringnumbers);
				// System.out.println(scdawg.get_node_label(sink));

				// Special case if identical strings had an smaller quasi max node as their sink

				for (pair pn : nodes_sink_set) {
					HashSet<Integer> ids = pn.ids;
					HashSet<Integer> sink_ids = new HashSet<Integer>();

					for (Integer i : sink.stringnumbers) {
						sink_ids.add(i);
					}

					if (sink_ids.equals(ids)) {
						continue sinkloop;
					}
				}

				pair p = new pair();
				p.ids = new HashSet<Integer>();
				for (Integer id : sink.stringnumbers) {
					p.ids.add(id);
				}
				p.node = scdawg.root;
				nodes_sink_set.add(p);
			}
		}

		for (pair p : nodes_sink_set) {
			 System.out.println(scdawg.get_node_label(p.node));
			 System.out.println(p.ids);
			 ArrayList<Pair<Integer, String>> linetupel = new ArrayList<Pair<Integer, String>>();
			 
			 Object[] idsarray = (Object[]) p.ids.toArray();
			 int diff = Math.abs((int)idsarray[0]-(int)idsarray[1]); 
			 System.out.println(diff);
			 if(diff<(stringset.size()/2)){
			     System.out.println("FALSCH!!!!!!!!!!!!!");
			 }
			for (Integer id : p.ids) {
				int idx = id;

				linetupel.add(new Pair(idx,stringset.get(idx)));

				System.out.println("- " + stringset.get(idx));
				
				
				
				// xyz[idx] = stringset.get(idx);
			}
			
			
			this.add(linetupel);

			 System.out.println("--------------------------------");
		}
		
	 
	}

	 public String[] getsortedbyId () {
		 
			String[] result = new String[nodes_sink_set.size()];
			
			for (pair p : nodes_sink_set) {
				 System.out.println(scdawg.get_node_label(p.node));
				 System.out.println(p.ids);
				ArrayList<String> linetupel = new ArrayList<String>();
				for (Integer id : p.ids) {
					int idx = id;

					linetupel.add((String) stringset.get(idx));

					System.out.println("- " + stringset.get(idx));
					
					// xyz[idx] = stringset.get(idx);
				}
				this.add(linetupel);
				// System.out.println();
			}
			
			return result;
			
		}

	

}
