package alignment_offline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;
import indexstructure.Node;
import util.Util;

public class LCS_Alignment_All extends ArrayList<ArrayList<String>> {

	Online_CDAWG_sym scdawg;
	Common_SCDAWG_Functions scdawg_functions;
	int nlines;
	
	public LCS_Alignment_All(ArrayList<String> stringset,int nlines) {

		Online_CDAWG_sym scdawg = new Online_CDAWG_sym(false);
		scdawg.determineAlphabet(stringset,"",true);
		scdawg.build_cdawg();

		this.scdawg = scdawg;

		Common_SCDAWG_Functions scdawg_functions = new Common_SCDAWG_Functions(scdawg);
		this.scdawg_functions = scdawg_functions;

	}

	public void align() {

		System.out.println("Searching quasi max nodes for n strings...");

		HashMap<Node, Integer> nodes_count = scdawg_functions.count_nodes();

		HashMap count_nodes_sorted = Util.sortByValues(nodes_count, "DESC");

		count_nodes_sorted.put(scdawg.root, null);
		Iterator it4 = count_nodes_sorted.entrySet().iterator();

		main_loop: while (it4.hasNext()) {
			Map.Entry pair = (Map.Entry) it4.next();

			System.out.println(scdawg.get_node_label((Node) pair.getKey()) + " : " + pair.getValue());

		}
		
		Iterator it3 = count_nodes_sorted.entrySet().iterator();

		HashSet<Integer> usedIDs = new HashSet<Integer>();
		main_loop: while (it3.hasNext()) {
			Map.Entry pair = (Map.Entry) it3.next();

			Node n = (Node) pair.getKey();

			HashSet<Integer> ids = Common_SCDAWG_Functions.find_n_transitions_to_sinks(n, scdawg, new HashSet<Integer>());

			if (ids.size() != nlines) {
				continue;
			}
			
			System.out.println(scdawg.get_node_label(n)+" "+ids.size());
			
//			for (Integer id : ids) {
//				if (usedIDs.contains(id)) {
//					continue main_loop;
//				}
//			}
//			for (Integer id : ids) {
//				usedIDs.add(id);
//			}
//			pair p = new pair();
//			p.ids = ids;
//			p.node = n;
//			System.out.println(scdawg.get_node_label(n));
//			nodes_sink_set.add(p);
		}
		
		
		// ArrayList<Endpos_Pair> quasi_max_nodes = find_quasi_max_nodes();

		// System.out.println("Calculating LCS for s1 and s2 pairs...");
		//
		// for (Endpos_Pair pair : quasi_max_nodes) {
		// longest_common_subsequences.add(calculate_LCS(pair.nodes_in_s1,
		// pair.nodes_endpos_s2));
		// }

	}

}