package dawg;
import java.util.ArrayList;
import java.util.HashMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

public class Node {

	public int   id;
	  public int   pathlength;
	  public int   end;
	  public Node  suffixLink;
	  public HashMap<Integer,Node> children;
	  public HashMap<Integer,String> labels;
	  String id_char;
	  public ArrayList <Node> prefixLinks;
	  public ArrayList<String> prefixlabels;
	  public boolean is_endNode=false;
	  boolean is_semiMaximal=false;
	  boolean is_inBothStrings=false;

	  boolean set_for_alignment;
	  public HashMap<Integer,Boolean> primary;
	  public Multimap<Integer,Integer>  end_positions;

	  public ArrayList<Integer> ident_pointers;

	
	  public Node(int _end,int _pathlength,int _stringnr,int _id_cnt)
	  {
 
	    id         = _id_cnt++;
	    end        =_end;
	    pathlength =_pathlength;
	    suffixLink = null;
	    id_char    = "";
	    children = new HashMap <Integer,Node>();
	    primary = new HashMap <Integer,Boolean> ();
	    end_positions = ArrayListMultimap.create();

	    ident_pointers = new ArrayList();
	    labels = new HashMap <Integer,String> ();
	    
	    prefixlabels = new ArrayList();
	    prefixLinks = new ArrayList();
	    
	    end_positions.put(_stringnr,_end);

	    if(_stringnr>1) is_inBothStrings = true;


	  } // Node()


	public Node() {
		id=-2;
	}
	  
	 public void update_end_positions(int _end,int _stringnr)
	  {
	    end_positions.put(_stringnr,_end);

	    if(_stringnr>1) is_inBothStrings = true;

	  }
	
	
	
}
