import java.io.IOException;
import java.util.ArrayList;

import cdawg.Online_CDAWG;
import cdawg_sym.Online_CDAWG_sym;

import dawg.DAWG;

import suffix_tree.Ukkonen_Suffixtree;
import suffix_trie.Naive_Suffixtrie;
import util.Util;

import org.apache.commons.cli.*;

public class BuildIndexstructures {

	public static void main(String[] args) {
		ArrayList stringset = new ArrayList();
			

		
		Options options = new Options();

        Option input = new Option("i", "input", true, "input file path");
        input.setRequired(true);
        options.addOption(input);

        Option output = new Option("o", "output", true, "output file");
        output.setRequired(true);
        options.addOption(output);
        
        Option debug = new Option("d", "debug", false, "enable debug prints 1|0");
        debug.setRequired(false);
        options.addOption(debug);
        
        Option indexstructure = new Option("s", "indexstructure", true, "strie, stree, dawg, cdawg, scdawg");
        indexstructure.setRequired(true);
        options.addOption(indexstructure);

        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;

        try {
            cmd = parser.parse(options, args);
        } catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("utility-name", options);

            System.exit(1);
        }

        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");
        String indexstructure_type = cmd.getOptionValue("indexstructure");
        
        boolean debugbool = false;

        if(cmd.hasOption("debug")) {
	        String debugstring = cmd.getOptionValue("debug");
	        	        
	        	debugbool = true;
	        
        
        }

		try {
		stringset = Util.readInputFile(inputFilePath);
		} catch (IOException e) {
			 // TODO Auto-generated catch block
			e.printStackTrace();
		}
			
	        
         if(indexstructure_type.equals("strie")) {
        
		 Naive_Suffixtrie strie = new Naive_Suffixtrie(stringset,debugbool);
		 strie.determineAlphabet_strings(stringset,debugbool);
		 strie.build_suffixtrie();
	     strie.print_tree(outputFilePath);
		 System.out.println("Nodes: " +strie.all_nodes.size());
		 System.out.println("Edges: " +strie.count_edges(strie.all_nodes));
		 
         }
         else if(indexstructure_type.equals("stree")) {
 
		 Ukkonen_Suffixtree stree = new Ukkonen_Suffixtree(stringset, debugbool);
		 stree.determineAlphabet_strings(stringset,debugbool);
		 stree.build_suffixtree();
		 stree.print_tree(outputFilePath);
		 System.out.println("Nodes: " + stree.all_nodes.size());
		 System.out.println("Edges: " +stree.count_edges(stree.all_nodes));
		 
         }
         else if(indexstructure_type.equals("dawg")) {
    		 DAWG dawg = new DAWG(stringset);
    		 dawg.determineAlphabet_strings(stringset,debugbool);
    		 dawg.build_dawg();
    		 dawg.print_automaton(outputFilePath);
    		 System.out.println("Nodes: " + dawg.all_nodes.size());
    		 System.out.println("Edges: " +dawg.count_edges_dawg(dawg.all_nodes));
         
         }
         else if(indexstructure_type.equals("cdawg")) {
    		 Online_CDAWG cdawg = new Online_CDAWG(debugbool);
    		 cdawg.determineAlphabet(stringset,"",debugbool);
    		 cdawg.build_cdawg();
        	 cdawg.print_automaton(outputFilePath);
    		 System.out.println("Nodes: " +cdawg.all_nodes.size());
    		 System.out.println("Edges: " +cdawg.count_edges(cdawg.all_nodes));
         
         }
         else if (indexstructure_type.equals("scdawg")) {
    		 Online_CDAWG_sym scdawg = new Online_CDAWG_sym(debugbool);
    		 scdawg.determineAlphabet(stringset,"",debugbool);
    		 scdawg.build_cdawg();
    		 scdawg.print_automaton_new(outputFilePath);
    		 System.out.println("Nodes: " +scdawg.all_nodes.size());
    		 System.out.println("Edges R: " +scdawg.count_edges(scdawg.all_nodes));
    		 System.out.println("Edges L: " +scdawg.count_edges_left(scdawg.all_nodes));

         }
		
		 
		 java.io.PrintStream out = System.out;
		 Runtime runtime = Runtime.getRuntime();

			// To convert from Bytes to MegaBytes:
			// 1 MB = 1024 KB and 1 KB = 1024 Bytes.
			// Therefore, 1 MB = 1024 * 1024 Bytes.
			long MegaBytes = 1024 * 1024;

			// Memory which is currently available for use by heap
			long totalMemory = runtime.totalMemory() / MegaBytes;
			out.println("Heap size available for use -> " + totalMemory + " MB");

			// Maximum memory which can be used if required.
			// The heap cannot grow beyond this size
			long maxMemory = runtime.maxMemory() / MegaBytes;
			out.println("Maximum memory Heap can use -> " + maxMemory + " MB");

			// Free memory still available
			long freeMemory = runtime.freeMemory() / MegaBytes;
			out.println("Free memory in heap -> " + freeMemory + " MB");

			// Memory currently used by heap
			long memoryInUse = totalMemory - freeMemory;
			out.println("Memory already used by heap -> " + memoryInUse + " MB");



	}
	
	
	

}

