package alignment_offline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import cdawg_sym.Online_CDAWG_sym;
import indexstructure.Node;
import util.Util;

public class LIS_Graph {

    public LIS_Node root;
    private Online_CDAWG_sym scdawg = null;

    public int cap = 0;
    
    HashMap<Integer, LIS_Node> all_nodes = new HashMap<Integer, LIS_Node>();
    ArrayList<LCS_Triple> lcs_triples = new ArrayList<LCS_Triple>();

    public LIS_Graph(Online_CDAWG_sym scdawg) {
	this.root = new LIS_Node("root", 0, -1);
	this.scdawg = scdawg;
    }

    // *******************************************************************************
    // build_LCS_graph()
    // *******************************************************************************

    public void build_LCS_graph(Node[] nodes_in_s1,Node[] nodes_in_s2, HashMap<Node, ArrayList> nodes_endpos_s2,boolean print) {

	LCS_Algorithm lcs = new LCS_Algorithm(this.scdawg);
	
	ArrayList<LCS_Triple> lcs_triples = new ArrayList<LCS_Triple>();

	ArrayList[] greedy_cover = lcs.build_greedy_cover(nodes_in_s1, nodes_endpos_s2, lcs_triples);
	if(print){
	    lcs.print_greedy_cover(greedy_cover, lcs_triples);
	}
	this.lcs_triples = lcs_triples;

	// calculate lis

	int i_count = 0;
	for (int i = 0; i < greedy_cover.length; i++) {
	    if (greedy_cover[i].size() > 0)
		i_count++;
	}
//	System.out.println("----------------------------------------");

	for (int x = 0; x < greedy_cover[i_count - 1].size(); x++) {
	    LIS_Node lis_start_node = this.addNode((int) greedy_cover[i_count - 1].get(x));
	    int lis_start_node_epos_s2 = lcs_triples.get((int) greedy_cover[i_count - 1].get(x)).endpos_s2;
	    this.addTransition(this.root, lis_start_node, lis_start_node_epos_s2);
	}
	  determineLis(nodes_in_s2,greedy_cover, lcs_triples, i_count - 1);

    }

    public void determineLis(Node[] nodes_in_s2, ArrayList[] greedy_cover, ArrayList<LCS_Triple> lcs_triples, int i) {
//	System.out.println("Hhhh");
	for (int x = 0; x < greedy_cover[i].size(); x++) {
//	    System.out.println("anfang for 1");

	    LIS_Node lis_child = this.all_nodes.get((int) greedy_cover[i].get(x));
	    if (lis_child == null) {
		continue;
	    }

	    int child_node_epos_s2 = lcs_triples.get((int) greedy_cover[i].get(x)).endpos_s2;
	    int child_node_epos_s2_length = scdawg.get_node_length(nodes_in_s2[child_node_epos_s2]); // die länge des versteckten knotens
	    int child_node_spos_s2 = child_node_epos_s2-(child_node_epos_s2_length-1);

	    int ancestor_idx = lcs_triples.get((int) greedy_cover[i].get(x)).idx_ancestor;

	    if (ancestor_idx == -1) {
		break;
	    }
//		System.out.println("Knoten( "+child_node_epos_s2+" "+ child_node_epos_s2_length +") "+ lis_child.label+" :: Vorgänger= "+scdawg.get_node_label(lcs_triples.get(ancestor_idx).node));

//		System.out.println("Mögliche Knoten: ");
	    for (int k = greedy_cover[i - 1].indexOf(ancestor_idx); k >= 0; k--) {
//		for (int k = greedy_cover[i - 1].indexOf(ancestor_idx); k < greedy_cover[i - 1].size(); k++) {

//		LCS_Triple xyz = lcs_triples.get((int) greedy_cover[i - 1].get(k));
//		System.out.println(greedy_cover[i - 1].get(k)+" "+scdawg.get_node_label(xyz.node));
//		System.out.println("for 2");
		int child_node_prev_epos_s2 = lcs_triples.get((int) greedy_cover[i - 1].get(k)).endpos_s2;
		int child_node_prev_epos_s2_length = scdawg.get_node_length(nodes_in_s2[child_node_prev_epos_s2]); // die länge des versteckten knotens
		int child_node_prev_spos_s2 = child_node_prev_epos_s2-(child_node_prev_epos_s2_length);
		
		// S1 copy? fr
		
		
		// FÜR ÜBERLAPP STARTPOS DES ursprünglichen??
		// < oder <= ??? eher < oder??
//		System.out.println(x);
//		System.out.println("Knoten("+child_node_epos_s2+" - "+ (child_node_epos_s2_length) +" = "+child_node_spos_s2+ ") \""+ lis_child.label+"\" :: Vorgänger: \""+scdawg.get_node_label(lcs_triples.get((int) greedy_cover[i - 1].get(k)).node)+ "\" ("+child_node_prev_epos_s2+")");
		boolean overlap = false;
		if(child_node_prev_epos_s2>=child_node_spos_s2 && child_node_prev_spos_s2 <= child_node_spos_s2 ) {
//			System.out.println("ÜBERLAPP");
			overlap = true;
		}
		
		if (child_node_prev_epos_s2  <= child_node_epos_s2) {

//		if (child_node_prev_epos_s2  <= child_node_spos_s2) { // over lapp fall auskommentiert goethe gedichte 
//			//System.out.println("Knoten("+child_node_epos_s2+" "+ child_node_epos_s2_length +" = "+child_node_spos_s2+ ") "+ lis_child.label+" :: Vorgänger: "+scdawg.get_node_label(lcs_triples.get((int) greedy_cover[i - 1].get(k)).node)+ " ("+child_node_prev_epos_s2+")");
		    LIS_Node lis_child_2 = null;

		    if (this.all_nodes.containsKey((int) greedy_cover[i - 1].get(k))) {
			lis_child_2 = this.all_nodes.get((int) greedy_cover[i - 1].get(k));
		    } else {
			lis_child_2 = this.addNode((int) greedy_cover[i - 1].get(k));
		    }

		    this.addTransition(lis_child, lis_child_2, k);

		}
	    }

//	    System.out.println("ende for 1");

	}

	if (i > 0) {
	    determineLis(nodes_in_s2,greedy_cover, lcs_triples, i - 1);
	}
	return;

    }

    public LIS_Node addNode(int lcs_idx) {
	Node cover_node = lcs_triples.get(lcs_idx).node;
	LIS_Node n = new LIS_Node(scdawg.get_node_label(cover_node), 0, lcs_idx);

	all_nodes.put(lcs_idx, n);
	return n;
    }

    public void addTransition(LIS_Node parent, LIS_Node child, int epos) {
	parent.children.put(epos, child);
    }

    public ArrayList<ArrayList<LCS_Triple>> reduce_to_related_nodes(Node[] nodes_in_s1, Node[] nodes_in_s2,
	    HashMap<Node, Related_Node_Info> related_quasi_max_nodes) {

	ArrayList<ArrayList<LCS_Triple>> all_longest_common_subsequences = this.serialize_all_LCS();

	ArrayList<ArrayList<LCS_Triple>> result = new ArrayList<ArrayList<LCS_Triple>>();

	for (ArrayList<LCS_Triple> alignment : all_longest_common_subsequences) {

	    ArrayList<LCS_Triple> new_lcs = new ArrayList<LCS_Triple>();

	    mainloop: for (LCS_Triple t : alignment) {

		Node aligned_node = t.node;
		Node original_node_s1 = nodes_in_s1[t.endpos_s1];
		Node original_node_s2 = nodes_in_s2[t.endpos_s2];

		System.out.println("original 1: " + scdawg.get_node_label(original_node_s1) + " " + t.endpos_s1
			+ " original 2: " + scdawg.get_node_label(original_node_s2) + " " + t.endpos_s2 + " aligned: "
			+ scdawg.get_node_label(aligned_node));

		if (scdawg.get_node_length(original_node_s2) == scdawg.get_node_length(original_node_s1)) {

		    new_lcs.add(new LCS_Triple(t.endpos_s1, t.endpos_s2, t.node,scdawg.get_node_label(t.node)));
		    continue mainloop;

		}

		if (scdawg.get_node_length(original_node_s2) > scdawg.get_node_length(original_node_s1)) {

		    Iterator it = original_node_s1.children.entrySet().iterator();

		    while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			Node child = (Node) pair.getValue();
			if (child.equals(original_node_s2)) {
			    int edgelength = scdawg.get_edge_length((int) pair.getKey(), original_node_s1, child);
			    int new_pos_s2 = t.endpos_s2 - edgelength;

			    new_lcs.add(new LCS_Triple(t.endpos_s1, new_pos_s2, t.node,scdawg.get_node_label(t.node)));

			    continue mainloop;
			}

		    }

		    it = original_node_s1.children_left.entrySet().iterator();

		    while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			Node child = (Node) pair.getValue();
			int edgelength = scdawg.get_edge_label_left((int) pair.getKey(), original_node_s1, child)
				.length();

			if (child.equals(original_node_s2)) {
			    int new_pos_s2 = t.endpos_s2 - scdawg.get_node_length(child) + edgelength
				    + scdawg.get_node_length(t.node);

			    new_lcs.add(new LCS_Triple(t.endpos_s1, new_pos_s2, t.node,scdawg.get_node_label(t.node)));

			}

		    }

		} else {

		    Iterator it = original_node_s2.children.entrySet().iterator();

		    while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			Node child = (Node) pair.getValue();
			if (child.equals(original_node_s1)) {
			    int edgelength = scdawg.get_edge_length((int) pair.getKey(), original_node_s2, child);
			    int new_pos_s1 = t.endpos_s1 - edgelength;
			    new_lcs.add(new LCS_Triple(new_pos_s1, t.endpos_s2, original_node_s2,scdawg.get_node_label(original_node_s2)));

			    continue mainloop;
			}

		    }

		    it = original_node_s2.children_left.entrySet().iterator();

		    while (it.hasNext()) {

			Map.Entry pair = (Map.Entry) it.next();
			Node child = (Node) pair.getValue();
			int edgelength = scdawg.get_edge_label_left((int) pair.getKey(), original_node_s2, child).length();

			if (child.equals(original_node_s1)) {
			    int new_pos_s1 = t.endpos_s1 - scdawg.get_node_length(child) + edgelength
				    + scdawg.get_node_length(original_node_s2);

			    new_lcs.add(new LCS_Triple(new_pos_s1, t.endpos_s2, original_node_s2,scdawg.get_node_label(original_node_s2)));

			}

		    }

		}

		// // fall, dass der s1 node in related nodes ist => s2 position ändern
		// if(related_quasi_max_nodes.get(t.node)!=null) {
		// related_alignment_node = t.node;
		// Node original_node_s2 = nodes_in_s2[t.endpos_s2];
		//
		// System.out.println("orginalknoten in s2: "+
		// scdawg.get_node_label(original_node_s2)+" rel
		// "+scdawg.get_node_label(t.node));
		//
		// // wenn beide gleich sind dann nichts machen ?!
		// if(scdawg.get_node_label(original_node_s2).equals(scdawg.get_node_label(t.node))){
		// continue mainloop;
		// }
		//
		// Iterator it = t.node.children.entrySet().iterator();
		//
		// while (it.hasNext()) {
		//
		// Map.Entry pair = (Map.Entry) it.next();
		// Node child = (Node) pair.getValue();
		// if(child.equals(original_node_s2)) {
		// int edgelength = scdawg.get_edge_length((int) pair.getKey(), t.node, child);
		// int new_pos_s2 = t.endpos_s2 - edgelength;
		//
		// t.endpos_s2 = new_pos_s2;
		// continue mainloop;
		// }
		//
		// }
		//
		//
		// it = t.node.children_left.entrySet().iterator();
		//
		// while (it.hasNext()) {
		//
		//
		// int edgelength = scdawg.get_edge_label_left((int) pair.getKey(), t.node,
		// child).length();
		// Map.Entry pair = (Map.Entry) it.next();
		// Node child = (Node) pair.getValue();
		// if(child.equals(original_node_s2)) {
		// int new_pos_s2 = t.endpos_s2 - scdawg.get_node_length(child) + edgelength +
		// scdawg.get_node_length(t.node);
		//
		// t.endpos_s2 = new_pos_s2;
		//
		// }
		//
		// }
		//
		//
		// }
		// else {
		//
		// // fall, dass der s1 node nicht in related nodes ist => s1 knoten ändern
		//
		// related_alignment_node = t.node;
		// Node original_node_s1 = nodes_in_s1[t.endpos_s1];
		//
		// System.out.println("orginalknoten in s1: "+
		// scdawg.get_node_label(original_node_s1)+" rel
		// "+scdawg.get_node_label(t.node));
		//
		// // wenn beide gleich sind dann nichts machen ?!
		// if(scdawg.get_node_label(original_node_s1).equals(scdawg.get_node_label(t.node))){
		// continue mainloop;
		// }
		//
		// ArrayList<Node> found_nodes = new ArrayList<Node>();
		// ArrayList<Integer> found_endpos = new ArrayList<Integer>();
		//
		// for(Map.Entry<Node, Related_Node_Info> rel_pair :
		// related_quasi_max_nodes.entrySet()) {
		//
		//
		// Iterator it = rel_pair.getKey().children.entrySet().iterator();
		//
		// while (it.hasNext()) {
		//
		// Map.Entry pair = (Map.Entry) it.next();
		// Node child = (Node) pair.getValue();
		// if(child.equals(original_node_s1)) {
		// System.out.println("!!!! EQUALS RIGHT");
		//
		// found_nodes.add(rel_pair.getKey());
		// int edgelength = scdawg.get_edge_length((int) pair.getKey(), t.node, child);
		// int new_pos_s1 = t.endpos_s1 - edgelength;
		// found_endpos.add(new_pos_s1);
		// }
		//
		// }
		//
		//
		// it = rel_pair.getKey().children_left.entrySet().iterator();
		//
		// while (it.hasNext()) {
		//
		// Map.Entry pair = (Map.Entry) it.next();
		// Node child = (Node) pair.getValue();
		// if(child.equals(original_node_s1)) {
		// System.out.println("!!!! EQUALS LEFT");
		//
		// found_nodes.add(rel_pair.getKey());
		//
		// int edgelength = scdawg.get_edge_label_left((int) pair.getKey(), t.node,
		// child).length();
		// int new_pos_s1 = t.endpos_s1 - scdawg.get_node_length(child) + edgelength +
		// scdawg.get_node_length(t.node);
		// found_endpos.add(new_pos_s1);
		//
		// }
		//
		// }
		// } // for rel
		//
		// if(found_nodes.size()>0) {
		// System.out.println("HJKALL");
		//
		// Node arg_max = null;
		// int new_pos = 0;
		// int max = 0;
		// for (int i=0;i<found_nodes.size();i++) {
		// Node n = found_nodes.get(i);
		// if(scdawg.get_node_length(n)>max) {
		// max = scdawg.get_node_length(n);
		// arg_max = n;
		// new_pos = found_endpos.get(i);
		// }
		//
		// }
		//
		// t.node = arg_max;
		// t.endpos_s1 = new_pos;
		// }
		//
		//
		// }
		//
		//
	    }
	    //
	    //
	    result.add(new_lcs);
	    System.out.println("---------------------------------------------------------------------------");

	}

	return result;

    }

    public ArrayList<LCS_Triple> get_alignment_greedy(
	    ArrayList<ArrayList<LCS_Triple>> all_longest_common_subsequences) {

	int max_sum = 0;
	ArrayList<LCS_Triple> arg_max = null;

	for (ArrayList<LCS_Triple> alignment : all_longest_common_subsequences) {
	    int sum = 0;

	    for (LCS_Triple t : alignment) {
		sum += scdawg.get_node_length(t.node);
	    }
	    if (sum > max_sum) {
		max_sum = sum;
		arg_max = alignment;
	    }

	}
	Collections.reverse(arg_max);
	return arg_max;

    }
    

    // *******************************************************************************
    // serialize_all_LCS2
    // *******************************************************************************

    public ArrayList<ArrayList<LCS_Triple>> serialize_all_LCS2() {
	LIS_Node root = this.root;
	ArrayList<ArrayList<LCS_Triple>> result = new ArrayList<ArrayList<LCS_Triple>>();
	System.out.println(root.children.size());
	this.eachNode_DFS(root,false,false, new Visitor(){
	    
	    public void visit(LIS_Node n) {

	System.out.println(n.label);
//	for (ArrayList<Integer> lcs_indices : all_lcs_indices) {
//
//	    ArrayList<LCS_Triple> t = new ArrayList();
//	    for (int idx : lcs_indices) {
//		t.add(this.lcs_triples.get(idx));
//	    }
//
//	    result.add(t);

	}
	
	    });

	

	return result;

    }
    
     

    // *******************************************************************************
    // serialize_all_LCS_indices()
    // *******************************************************************************

    public ArrayList<ArrayList<LCS_Triple>> serialize_all_LCS() {

	ArrayList<ArrayList<LCS_Triple>> result = new ArrayList<ArrayList<LCS_Triple>>();
//	System.out.println("STEP!");
	ArrayList<ArrayList<Integer>> all_lcs_indices = serialize_all_LCS_indices();
//	System.out.println("END!");
	for (ArrayList<Integer> lcs_indices : all_lcs_indices) {

	    ArrayList<LCS_Triple> t = new ArrayList();
	    for (int idx : lcs_indices) {
		t.add(this.lcs_triples.get(idx));
	    }

	    result.add(t);

	}

	return result;

    }

    // *******************************************************************************
    // serialize_all_LCS_indices()
    // *******************************************************************************

    public ArrayList<ArrayList<Integer>> serialize_all_LCS_indices() {

	ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();

	ArrayList<Integer> first_path = new ArrayList<Integer>();
	HashMap visited = new HashMap(); 
	serializeGraphUtil(this.root, first_path, result,visited);

	return result;

    }

    public void serializeGraphUtil(LIS_Node node, ArrayList<Integer> path, ArrayList<ArrayList<Integer>> result,HashMap visited) {
	visited.put(node.lcs_idx,true);
//	System.out.println(node.lcs_idx+" "+node.label);
	if (node.children == null || node.children.isEmpty()) {
	    result.add(path);
	    return;
	}

	ArrayList<Integer> copy_path = new ArrayList<Integer>();

	for (int idx : path) {
	    int new_idx = idx;
	    copy_path.add(new_idx);
	}

	int cnt = 0;
	for (Map.Entry<Integer, LIS_Node> child : node.children.entrySet()) {

	    if (cnt == 0) {
		    if(!visited.containsKey(child.getValue().lcs_idx)){

		
		path.add(child.getValue().lcs_idx);
		serializeGraphUtil(child.getValue(), path, result,visited);
		    }
	    } else {

		ArrayList<Integer> new_path = new ArrayList<Integer>();

		for (int idx : copy_path) {
		    int new_idx = idx;
		    new_path.add(new_idx);
		}

		new_path.add(child.getValue().lcs_idx);
		serializeGraphUtil(child.getValue(), new_path, result,visited);

	    }
	    cnt++;
	 }	
		
	visited.put(node.lcs_idx, false);

    }

    public void print_all_LCS(ArrayList<ArrayList<LCS_Triple>> longest_common_subsequences) {

	for (int u = 0; u < longest_common_subsequences.size(); u++) {
	    ArrayList<LCS_Triple> lis = longest_common_subsequences.get(u);
	    for (int i = 0; i < lis.size(); i++) {
		int e1 = lis.get(i).endpos_s1;
		int e2 = lis.get(i).endpos_s2;
		String nodelabel = scdawg.get_node_label(lis.get(i).node);
		System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);
	    }
	    System.out.println("---------------------------------------");
	}

    }

    public void printLCS(ArrayList<LCS_Triple> lis) {

	for (int i = 0; i < lis.size(); i++) {
	    int e1 = lis.get(i).endpos_s1;
	    int e2 = lis.get(i).endpos_s2;
	    String nodelabel = lis.get(i).label;
	    System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);
	}
	System.out.println("---------------------------------------");

    }

    public void print_graph(String outputfile) {

	long startTime = System.currentTimeMillis();
	System.out.println(" ..printing Graph ");

	String filename = "lis.dot";

	StringBuilder sb = new StringBuilder();

	// dotfile
	sb.append("digraph lis_graph { ");
	sb.append("\n" + "labeljust=l");
	sb.append("\n" + "fontname=Vera");
	sb.append("\n" + "fontsize=20");
	sb.append("\n" + "labelloc=top");
	sb.append("\n" + "margin=.5");
	sb.append("\n" + "size=\"15,7\"");
	sb.append("\n" + "nodesep=.3");
	sb.append("\n" + "rankdir=\"LR\"");
	sb.append("\n"
		+ "node [width=0.5,height=auto,shape=record,fontsize=12,fontcolor=black,style=filled,fillcolor=lightblue];");
	sb.append("\n" + "edge [minlen=1,constraint=true,fontsize=11,labelfontsize=11];");

	sb.append("\n");
	sb.append("\n");

	//
	String edge_list = "", node_list = "";
	sb.append("/* Nodes */ \n \n");
	//
	String nodeslist = print_nodes();
	sb.append(nodeslist);
	sb.append("\n /* Edges */ \n \n");
	// print_edges(root,edge_list);
	String edgeslist = print_edges();
	sb.append(edgeslist + "}");

	String result = sb.toString();

	Util.writeFile(filename, result);

	// String[] cmd = { "/usr/bin/dot -Tsvg lis.dot -o " + outputfile + "_.svg" };
	String[] cmd = { "cmd.exe", "/c", "dot -Tsvg lis.dot -o " + outputfile + "_.svg" };

	try {

	    Process p = Runtime.getRuntime().exec(cmd);

	    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));

	    String temp = "";

	    while ((temp = input.readLine()) != null)
		System.out.println(temp);

	    input.close();
	    p.waitFor();

	} catch (IOException e) {
	    e.printStackTrace();
	} catch (InterruptedException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}

	long duration = System.currentTimeMillis() - startTime;
	System.out.println(" ... took " + duration + " milliseconds");

    } // print_automaton()

    public String print_nodes() {

	String result = "";

	String node_str;
	StringBuilder node_sstr = new StringBuilder();

	this.eachNode_DFS(this.root, true, false, new Visitor() {
	    public void visit(LIS_Node node) {

		node_sstr.append(node.lcs_idx);

		//
		node_sstr.append(" [label=<\"" + node.label + "\">]");
		node_sstr.append("; \n");
	    }

	});
	result = node_sstr.toString();

	return result;

    } // print_nodes()

    // *******************************************************************************
    // print_edges()
    // *******************************************************************************
    public String print_edges() {

	String result = "";
	StringBuilder edge_sstr = new StringBuilder();

	this.eachNode_DFS(this.root, true, false, new Visitor() {
	    public void visit(LIS_Node node) {

		Iterator it = node.children.entrySet().iterator();
		while (it.hasNext()) {

		    Map.Entry pair = (Map.Entry) it.next();

		    int i = (int) pair.getKey();
		    edge_sstr.append(node.lcs_idx + " -> " + node.children.get(i).lcs_idx);

		    String label = "";
		    label = "" + i;

		    edge_sstr.append(" [style=" + "solid" + "  label=\"" + label + "\"];" + "\n");

		} // for it node children

	    } // for all nodes

	});

	result = edge_sstr.toString();

	return result;

    } // print_edges()

    public void eachNode_BFS(LIS_Node s, boolean rev, boolean all, Visitor v) {

	HashMap<LIS_Node, Boolean> visited = new HashMap<LIS_Node, Boolean>();

	LinkedList<LIS_Node> queue = new LinkedList<LIS_Node>();

	visited.put(s, true);
	queue.add(s);

	while (queue.size() != 0) {
	    s = queue.poll();
	    if (!rev)
		v.visit(s);

	    for (Map.Entry<Integer, LIS_Node> child : s.children.entrySet()) {

		if (all) {
		    visited.put(child.getValue(), true);
		    queue.add(child.getValue());
		}

		else if (!visited.containsKey(child.getValue())) {
		    visited.put(child.getValue(), true);

		    queue.add(child.getValue());
		}
	    }

	    if (rev)
		v.visit(s);

	}

    }

    void DFSUtil(LIS_Node s, boolean rev, boolean all, HashMap<LIS_Node, Boolean> visited, Visitor v) {
	visited.put(s, true);
	if (!rev) {
	    v.visit(s);
	}
	

	for (Map.Entry<Integer, LIS_Node> child : s.children.entrySet()) {

	    if (all) {
		DFSUtil(child.getValue(), rev, all, visited, v);
	    }

	    else if (!visited.containsKey(child.getValue())) {
		DFSUtil(child.getValue(), rev, all, visited, v);
	    }
	}

	if (rev) {
	    v.visit(s);
	}

    }

    public void eachNode_DFS(LIS_Node s, boolean rev, boolean all, Visitor v) {

	HashMap<LIS_Node, Boolean> visited = new HashMap<LIS_Node, Boolean>();

	DFSUtil(s, rev, all, visited, v);
    }

    public interface Visitor {
	void visit(LIS_Node n);
    }

}
