package alignment_offline;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;


import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;
import indexstructure.EdgeInfo;
import indexstructure.Node;
import util.Util;

public class LCS_Alignment_Pairwise {

    public Online_CDAWG_sym scdawg;

    public Common_SCDAWG_Functions scdawg_functions;

    public ArrayList<LCS_Triple> greedy_alignment = new ArrayList<LCS_Triple>();

    public LIS_Graph lis_graph = null;

    public LCS_Alignment_Pairwise(ArrayList<String> stringset) {
//
//	System.out.println("S1 " + stringset.get(0));
//	System.out.println("S2 " + stringset.get(1));
	
	Online_CDAWG_sym scdawg = new Online_CDAWG_sym(false);
	scdawg.determineAlphabet(stringset,"",false);
	scdawg.build_cdawg();
	//scdawg.print_automaton("svgs/scdawg");

	this.scdawg = scdawg;
	Common_SCDAWG_Functions scdawg_functions = new Common_SCDAWG_Functions(scdawg);
	this.scdawg_functions = scdawg_functions;

    }

    public void align(boolean print) {
	
	if (print){
	    System.out.println("Searching quasi max nodes for s1 and s2 pairs...");
	}

	ArrayList<Endpos_Tupel> quasi_max_nodes = scdawg_functions.get_quasi_maximal_nodes_new();
	if (print){
	System.out.println("Done Qmax nodes");
	System.out.println(quasi_max_nodes.size());

	}
//	System.out.println(quasi_max_nodes.size()+ " ....");
	if (quasi_max_nodes.size() < 2) {
	    return;
	}
	

//	int[] marked_nodes = scdawg_functions.get_string_occurences();
//
//	System.out.println(marked_nodes.length);
//	System.out.println(scdawg.all_nodes.size());



	Node[] nodes_in_s1 = new Node[scdawg.stringset.get(0).length + 1];
	Node[] nodes_in_s2 = new Node[scdawg.stringset.get(1).length + 1];

	HashMap<Node, ArrayList> nodes_endpos_s1 = new HashMap();
	HashMap<Node, ArrayList> nodes_endpos_s2 = new HashMap();


	for (Endpos_Tupel pair : quasi_max_nodes) {
	    Node x = pair.node;
	    
	    if(print){
		System.out.println("-----------------------------------");
		System.out.println(scdawg.get_node_label(x) + ", s=" + pair.stringnr + " :: endpos=" + pair.endpos);
	    }
	    if(pair.stringnr==0){
		nodes_in_s1[pair.endpos] = x;
	    }
	    if(pair.stringnr==1)
		nodes_in_s2[pair.endpos] = x;
	    }
	   

//	    ArrayList<Integer> e1 = pair.endpos_s1;
//	    Collections.sort(e1);
//	    nodes_endpos_s1.put(x, e1);
//
//	    ArrayList<Integer> e2 = pair.endpos_s2;
//	    Collections.sort(e2);
//	    nodes_endpos_s2.put(x, e2);
//
	    for (int i=0;i<nodes_in_s2.length;i++) {
		if(nodes_in_s2[i]==null){
		    continue;
		}
		if(nodes_endpos_s2.containsKey(nodes_in_s2[i])){
		    nodes_endpos_s2.get(nodes_in_s2[i]).add(i);
		}
		else {
		    ArrayList list = new ArrayList();
		    list.add(i);
		    nodes_endpos_s2.put(nodes_in_s2[i],list);

		}
	    }



	if(print){
        	System.out.println("____________________________________________________");
        
        	for (int i = 0; i < nodes_in_s1.length; i++) {
        	    if (nodes_in_s1[i] != null) {
        		System.out.println(scdawg.get_node_label(nodes_in_s1[i]) + ", i= " + i + " :: s2="
        			+ nodes_endpos_s2.get(nodes_in_s1[i]));
        	    }
        	}
        	System.out.println("____________________________________________________");
        	System.out.println("Calculating LCS for s1 and s2 pairs...");
	}
	
	
	if(print){
	    System.out.println("Building Graph...");
	}
	
	LIS_Graph g = new LIS_Graph(scdawg);

	g.build_LCS_graph(nodes_in_s1, nodes_in_s2, nodes_endpos_s2,print);
	
	if(print){
	    System.out.println("Serializing LCS...");
	}
//	ArrayList<ArrayList<LCS_Triple>> longest_common_subsequences2 = g.serialize_all_LCS2();
	ArrayList<ArrayList<LCS_Triple>> longest_common_subsequences = g.serialize_all_LCS();
	
	if(print){
	    System.out.println("Serialized("+longest_common_subsequences.size()+") LCS...");
	}

//	System.out.println("Printing all LCS...");
//	g.print_all_LCS(longest_common_subsequences);
	if(print){
	 g.print_graph("svgs/lis");
	}


	ArrayList<LCS_Triple> greedy_alignment = g.get_alignment_greedy(longest_common_subsequences);
	this.greedy_alignment = greedy_alignment;
	
	if(print){
	System.out.println("=====================");
	System.out.println("Printing greedy LCS...");

	g.printLCS(greedy_alignment);
	}
	
	

	

	
	this.lis_graph = g;

    }
    
    
    public void align_lcs(int q_max,boolean print) {
	
   	if (print){
   	    System.out.println("Searching quasi max nodes for s1 and s2 pairs...");
   	}

   	ArrayList<Endpos_Tupel> quasi_max_nodes = scdawg_functions.get_quasi_maximal_nodes_new();
   	if (print){
   	System.out.println("Done Qmax nodes");
   	System.out.println(quasi_max_nodes.size());

   	}
//   	System.out.println(quasi_max_nodes.size()+ " ....");
   	if (quasi_max_nodes.size() < 2) {
   	    return;
   	}
   	

//   	int[] marked_nodes = scdawg_functions.get_string_occurences();
   //
//   	System.out.println(marked_nodes.length);
//   	System.out.println(scdawg.all_nodes.size());



   	Node[] nodes_in_s1 = new Node[scdawg.stringset.get(0).length + 1];
   	Node[] nodes_in_s2 = new Node[scdawg.stringset.get(1).length + 1];

   	HashMap<Node, ArrayList> nodes_endpos_s1 = new HashMap();
   	HashMap<Node, ArrayList> nodes_endpos_s2 = new HashMap();


   	for (Endpos_Tupel pair : quasi_max_nodes) {
   	    Node x = pair.node;
   	    
   	    if(print){
   		System.out.println("-----------------------------------");
   		System.out.println(scdawg.get_node_label(x) + ", s=" + pair.stringnr + " :: endpos=" + pair.endpos);
   	    }
   	    if(pair.stringnr==0){
   		nodes_in_s1[pair.endpos] = x;
   	    }
   	    if(pair.stringnr==1)
   		nodes_in_s2[pair.endpos] = x;
   	    }
   	   

//   	    ArrayList<Integer> e1 = pair.endpos_s1;
//   	    Collections.sort(e1);
//   	    nodes_endpos_s1.put(x, e1);
   //
//   	    ArrayList<Integer> e2 = pair.endpos_s2;
//   	    Collections.sort(e2);
//   	    nodes_endpos_s2.put(x, e2);
   //
   	    for (int i=0;i<nodes_in_s2.length;i++) {
   		if(nodes_in_s2[i]==null){
   		    continue;
   		}
   		if(nodes_endpos_s2.containsKey(nodes_in_s2[i])){
   		    nodes_endpos_s2.get(nodes_in_s2[i]).add(i);
   		}
   		else {
   		    ArrayList list = new ArrayList();
   		    list.add(i);
   		    nodes_endpos_s2.put(nodes_in_s2[i],list);

   		}
   	    }



   	if(print){
           	System.out.println("____________________________________________________");
           
           	for (int i = 0; i < nodes_in_s1.length; i++) {
           	    if (nodes_in_s1[i] != null) {
           		System.out.println(scdawg.get_node_label(nodes_in_s1[i]) + ", i= " + i + " :: s2="
           			+ nodes_endpos_s2.get(nodes_in_s1[i]));
           	    }
           	}
           	System.out.println("____________________________________________________");
           	System.out.println("Calculating LCS for s1 and s2 pairs...");
   	}
   	
LCS_Algorithm lcs = new LCS_Algorithm(scdawg);
	
	ArrayList<LCS_Triple> lcs_triples = new ArrayList<LCS_Triple>();

	ArrayList[] greedy_cover = lcs.build_greedy_cover(nodes_in_s1, nodes_endpos_s2, lcs_triples);
	if(print){
	    System.out.println("Printing greedy Cover");
	    lcs.print_greedy_cover(greedy_cover, lcs_triples);
	}
	
	ArrayList<LCS_Triple> greedy_alignment = lcs.calculate_LCS(nodes_in_s1, nodes_endpos_s2);
	this.greedy_alignment = greedy_alignment;
	
	if(print){
	    System.out.println("=====================");
	    System.out.println("Printing greedy LCS...");
	}
	LIS_Graph g = new LIS_Graph(scdawg);

	if(print){
	    g.printLCS(greedy_alignment);
	}

       }
    
    public void align_lcs_old(int q_max,boolean print) {
    	
	if(print){
	    System.out.println("Searching quasi max nodes for s1 and s2 pairs...");
	}
	ArrayList<Endpos_Pair> quasi_max_nodes = scdawg_functions.get_quasi_maximal_nodes_pairwise();
//	System.out.println(quasi_max_nodes.size()+ " ....");
	if (quasi_max_nodes.size() <= 2) {
	    return;
	}

//	int[] marked_nodes = scdawg_functions.get_string_occurences();
//
//	System.out.println(marked_nodes.length);
//	System.out.println(scdawg.all_nodes.size());



	Node[] nodes_in_s1 = new Node[scdawg.stringset.get(0).length + 1];
	Node[] nodes_in_s2 = new Node[scdawg.stringset.get(1).length + 1];

	HashMap<Node, ArrayList> nodes_endpos_s1 = new HashMap();
	HashMap<Node, ArrayList> nodes_endpos_s2 = new HashMap();

	HashMap<Node, ArrayList> nodes_endpos_s2_new = new HashMap();

	for (Endpos_Pair pair : quasi_max_nodes) {
	    Node x = pair.node;
	    
	    if(print){
		System.out.println("-----------------------------------");
		System.out.println(scdawg.get_node_label(x) + ", s1=" + pair.endpos_s1 + " :: s2=" + pair.endpos_s2);
	    }
	    for (int e1 : pair.endpos_s1) {
		nodes_in_s1[e1] = x;
	    }

	    for (int e2 : pair.endpos_s2) {
		nodes_in_s2[e2] = x;
	    }

	    ArrayList<Integer> e1 = pair.endpos_s1;
	    Collections.sort(e1);
	    nodes_endpos_s1.put(x, e1);

	    ArrayList<Integer> e2 = pair.endpos_s2;
	    Collections.sort(e2);
	    nodes_endpos_s2.put(x, e2);

	    ArrayList<Integer> e2_new = new ArrayList();
	    for (int h : e2) {
		e2_new.add(h);
	    }

	    nodes_endpos_s2_new.put(x, e2_new);

	}


	for (Map.Entry<Node, ArrayList> entry : nodes_endpos_s2_new.entrySet()) {
	    Collections.sort(entry.getValue());
	}
	
	if(print){
	    System.out.println("____________________________________________________");

		for (int i = 0; i < nodes_in_s1.length; i++) {
		    if (nodes_in_s1[i] != null) {
			System.out.println("'"+scdawg.get_node_label(nodes_in_s1[i]) + ", i= " + i + " :: s2="
			+ nodes_endpos_s2_new.get(nodes_in_s1[i]));
	    }
		}
		System.out.println("____________________________________________________");
	
		System.out.println("Calculating LCS for s1 and s2 pairs...");
	}
	LCS_Algorithm lcs = new LCS_Algorithm(scdawg);
	
	ArrayList<LCS_Triple> lcs_triples = new ArrayList<LCS_Triple>();

	ArrayList[] greedy_cover = lcs.build_greedy_cover(nodes_in_s1, nodes_endpos_s2_new, lcs_triples);
	if(print){
	    System.out.println("Printing greedy Cover");
	    lcs.print_greedy_cover(greedy_cover, lcs_triples);
	}
	
	ArrayList<LCS_Triple> greedy_alignment = lcs.calculate_LCS(nodes_in_s1, nodes_endpos_s2_new);
	this.greedy_alignment = greedy_alignment;
	
	if(print){
	    System.out.println("=====================");
	    System.out.println("Printing greedy LCS...");
	}
	LIS_Graph g = new LIS_Graph(scdawg);

	if(print){
	    g.printLCS(greedy_alignment);
	}

    }

    public void add_related_nodes_to_cover(HashMap<Node, ArrayList> nodes_endpos_s1,
	    HashMap<Node, ArrayList> nodes_endpos_s2, HashMap<Node, ArrayList> nodes_endpos_s2_new,
	    HashMap<Node, Related_Node_Info> related_quasi_max_nodes, int cap) {

	for (Map.Entry<Node, ArrayList> node_endpos_s1 : nodes_endpos_s1.entrySet()) {
	    if (related_quasi_max_nodes.containsKey(node_endpos_s1.getKey())) {

		scdawg.eachNode_DFS(node_endpos_s1.getKey(), true, false, new Online_CDAWG_sym.Visitor() {

		    public void visit(Node n) {

			if (n.is_endNode || n.equals(node_endpos_s1.getKey()) || !nodes_endpos_s1.containsKey(n))
			    return;
			int diff = scdawg.get_node_length(n) - scdawg.get_node_length(node_endpos_s1.getKey());
			if (diff > cap)
			    return;

			nodes_endpos_s2_new.get(node_endpos_s1.getKey()).addAll(nodes_endpos_s2.get(n));

			Set<Integer> set = new HashSet<>();
			set.addAll(nodes_endpos_s2_new.get(n));
			nodes_endpos_s2_new.get(n).clear();
			nodes_endpos_s2_new.get(n).addAll(set);

			// Collections.sort(nodes_endpos_s2_new.get(n)); ??
		    }
		});

	    }
	}

	for (Map.Entry<Node, ArrayList> node_endpos_s2 : nodes_endpos_s2.entrySet()) {
	    if (related_quasi_max_nodes.containsKey(node_endpos_s2.getKey())) {

		scdawg.eachNode_DFS(node_endpos_s2.getKey(), true, false, new Online_CDAWG_sym.Visitor() {

		    public void visit(Node n) {

			if (n.is_endNode || n.equals(node_endpos_s2.getKey()) || !nodes_endpos_s2.containsKey(n))
			    return;
			int diff = scdawg.get_node_length(n) - scdawg.get_node_length(node_endpos_s2.getKey());

			if (diff > cap)
			    return;

			nodes_endpos_s2_new.get(n).addAll(nodes_endpos_s2.get(node_endpos_s2.getKey()));

			Set<Integer> set = new HashSet<>();
			set.addAll(nodes_endpos_s2_new.get(n));
			nodes_endpos_s2_new.get(n).clear();
			nodes_endpos_s2_new.get(n).addAll(set);

			// Collections.sort(nodes_endpos_s2_new.get(n)); ???

		    }
		});

	    }
	}

    }

    
    
    
    public ArrayList<LCS_Triple> minimize_gaps(Node[] nodes_in_s1,Node[] nodes_in_s2,HashMap<Node, Related_Node_Info> related_quasi_max_nodes,ArrayList<LCS_Triple> lis) {
	
	    ArrayList<LCS_Triple> result = new ArrayList<LCS_Triple>();
    	 

    	    for (int i = 0; i < lis.size(); i++) {
    		int e1 = lis.get(i).endpos_s1;
    		int e2 = lis.get(i).endpos_s2;
    		String nodelabel = scdawg.get_node_label(lis.get(i).node);
    		
    		result.add(lis.get(i));
    		
    		String gap1 = "";
    		String gap2 = "";
    	

    		if (i < lis.size() - 1) {

    		    int x = scdawg.get_node_length(lis.get(i + 1).node);

    		    if ((lis.get(i + 1).endpos_s1 - x) < lis.get(i).endpos_s1
    			    || (lis.get(i + 1).endpos_s2 - x) < lis.get(i).endpos_s2) {
    			continue;
    		    } // TO DO: handle overlap correctly!

    		    // System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1
    		    // " + (lis.get(i + 1).endpos_s1 - x));
    		    // System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1
    		    // " + (lis.get(i + 1).endpos_s2 - x));
    		    
    		    
//    		    gap1 = (scdawg.stringset.get(0).substring(lis.get(i).endpos_s1,
//    			    lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node)));
    		    
    		    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node) -1, 0);

    		    
    		    int gap1_start = lis.get(i).endpos_s1;
    		    int gap1_end = lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node);
    		    
    		    HashMap<Node,Integer> nodes_found_in_gap1 = new HashMap<Node,Integer>();
    		        		    
    		    for (int j=gap1_start+1;j<gap1_end;j++) {
    		    	if(nodes_in_s1[j]!=null) {
    		    		System.out.println("In S1 Node found at: "+j+" "+scdawg.get_node_label(nodes_in_s1[j]));
    		    		nodes_found_in_gap1.put(nodes_in_s1[j],j);
    		    	}
    		    }
    		    
    		    System.out.println(gap1+" "+gap1_start+" - "+gap1_end);
    		    
    		    
//    		    gap2 = (scdawg.stringset.get(1).substring(lis.get(i).endpos_s2,
//    			    lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node)));
    		    
    		    gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node) -1, 1);

    		    
    		    int gap2_start = lis.get(i).endpos_s2;
    		    int gap2_end = lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node);
    		    
    		    HashMap<Node,Integer> nodes_found_in_gap2 = new HashMap<Node,Integer>();
    		    
    		    for (int j=gap2_start+1;j<=gap2_end;j++) {
    		    	if(nodes_in_s2[j]!=null) {
    		    		System.out.println("In S2 Node found at: "+j+" "+scdawg.get_node_label(nodes_in_s2[j]));
    		    		nodes_found_in_gap2.put(nodes_in_s2[j],j);

    		    	}
    		    }
    		    
    		    System.out.println(gap2+" "+gap2_start+" - "+gap2_end);

    		    
    		    for(Map.Entry<Node, Integer> entry : nodes_found_in_gap1.entrySet()) {
    		    
    		    Node s1_gap_node = entry.getKey();
    		    Integer s1_gap_node_pos = entry.getValue();
    		    
    		    
    		    if(related_quasi_max_nodes.containsKey(s1_gap_node)){
    		    	Node related_node = related_quasi_max_nodes.get(s1_gap_node).node;
    		    	
    		   
    		    	
    		    	if(nodes_found_in_gap2.containsKey(related_node)) {
        		    	System.out.println(scdawg.get_node_label(s1_gap_node)+" und "+scdawg.get_node_label(related_node)+" alignieren");
        		    	
        		    	
        		    	String edgelabel = "";
        		    	if(related_quasi_max_nodes.get(s1_gap_node).left_edge) {
        	    		      edgelabel = scdawg.get_edge_label_left(related_quasi_max_nodes.get(s1_gap_node).letter,s1_gap_node,related_node);
        		    	}
        		    	else {
        		    	    edgelabel = scdawg.get_edge_label(related_quasi_max_nodes.get(s1_gap_node).letter,s1_gap_node,related_node);
        		    	}
        		    	
        	    		      System.out.println("Edgelabel: "+edgelabel+" length "+edgelabel.length());
        	    		    	System.out.println("related enthalten: "+scdawg.get_node_label(s1_gap_node)+" sein relateder: "+scdawg.get_node_label(related_node));
        		    	
        		    	
        	    		Integer s2_gap_node_pos = nodes_found_in_gap2.get(related_node);
        	    		
        	    		System.out.println(s2_gap_node_pos + " - " + scdawg.get_node_length(related_node)+  " + " + (scdawg.get_node_length(s1_gap_node)+1));
        	    		
        	    		Integer s2_new_gap_node_pos = s2_gap_node_pos-scdawg.get_node_length(related_node)+edgelabel.length()+scdawg.get_node_length(s1_gap_node);
        	    		System.out.println(s2_new_gap_node_pos);
        	    			
        	    			
        		    	result.add(new LCS_Triple(s1_gap_node_pos,s2_new_gap_node_pos,s1_gap_node,scdawg.get_node_label(s1_gap_node)));

    		    	}
    		    	
    		    }
    		    // s1 und s2 enhalten einen relateden => vater der beiden finden und den alignieren..
    		    else {
    		    	
    		    }
    		    
    		    }
    		    System.out.println("-===============================================================-");

    		    
    		}

    		

    	    }

    	   return result;

        }
    
    public ArrayList<LCS_Triple> minimize_gaps_it(ArrayList<LCS_Triple> lis) {
	
	    ArrayList<LCS_Triple> result = new ArrayList<LCS_Triple>();
	    
	    if(lis.size()<2)
		return lis;

	    for (int i = 0; i < lis.size(); i++) {
		int e1 = lis.get(i).endpos_s1;
		int e2 = lis.get(i).endpos_s2;
		String nodelabel = scdawg.get_node_label(lis.get(i).node);
		
		result.add(lis.get(i));
		
		String gap1 = "";
		String gap2 = "";
	

		if (i < lis.size() - 1) {

		    int x = scdawg.get_node_length(lis.get(i + 1).node);

//		    if ((lis.get(i + 1).endpos_s1 - x) < lis.get(i).endpos_s1
//			    || (lis.get(i + 1).endpos_s2 - x) < lis.get(i).endpos_s2) {
//			continue;
//		    } // TO DO: handle overlap correctly!

		    // System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1
		    // " + (lis.get(i + 1).endpos_s1 - x));
		    // System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1
		    // " + (lis.get(i + 1).endpos_s2 - x));

//		    gap1 = (scdawg.stringset.get(0).substring(lis.get(i).endpos_s1,
//			    lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node)));
		    
    		    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node) -1, 0);

		    
		    int gap1_start = lis.get(i).endpos_s1;
		    int gap1_end = lis.get(i + 1).endpos_s1 - scdawg.get_node_length(lis.get(i + 1).node);
		    
		    		    
		    
//		    gap2 = (scdawg.stringset.get(1).substring(lis.get(i).endpos_s2,
//			    lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node)));
		    
    		    gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node) -1, 1);

    	

		    if(gap1.length()==0||gap2.length()==0) {
			continue;
		    }
		    
		    int gap2_start = lis.get(i).endpos_s2;
		    int gap2_end = lis.get(i + 1).endpos_s2 - scdawg.get_node_length(lis.get(i + 1).node);
		    
//		    System.out.println("Aligning: ");
//		    System.out.println(gap1+" "+gap1_start+" - "+gap1_end);
//    		    System.out.println(gap2+" "+gap2_start+" - "+gap2_end);
    		    
		    ArrayList<String> stringset = new ArrayList<String>();
//		    
		    stringset.add("#"+gap1+"$");
		    stringset.add("#"+gap2+"$");
		    
		    LCS_Alignment_Pairwise sub_alignment = new LCS_Alignment_Pairwise(stringset);
		    sub_alignment.align_lcs(2,false);
		    ArrayList <LCS_Triple> no_overlaps_sub = this.remove_overlaps(sub_alignment.greedy_alignment);
		    
		    for(LCS_Triple l : no_overlaps_sub) {
			if(!(sub_alignment.scdawg.get_node_label(l.node).equals("#"))&!sub_alignment.scdawg.get_node_label(l.node).equals("$")) {
//			 System.out.println(l);
			String sub_alignment_match = sub_alignment.scdawg.get_node_label(l.node).replace("#", "");
			sub_alignment_match = sub_alignment_match.replace("$","");
//			System.out.println("adding " + sub_alignment_match);
			
		    	result.add(new LCS_Triple(gap1_start+l.endpos_s1-1,gap2_start+l.endpos_s2-1,sub_alignment_match));
			}
		    }
		    
		    
		   

		    
		}

		

	    }
//	    result = minimize_gaps_it(result);
	    
	   return result;

    }
    // end new
    
    public ArrayList<LCS_Triple> minimize_gaps_hirschberg(ArrayList<LCS_Triple> lis) {
	
	    ArrayList<LCS_Triple> result = new ArrayList<LCS_Triple>();
//	    	System.out.println("-------------------------------------------------------------------");
	    	
	    	int addcount = 0;
	    	
	    for (int i = 0; i < lis.size(); i++) {
		int e1 = lis.get(i).endpos_s1;
		int e2 = lis.get(i).endpos_s2;
		String nodelabel = scdawg.get_node_label(lis.get(i).node);
		
		result.add(lis.get(i));
		
		String gap1 = "";
		String gap2 = "";
	

		if (i < lis.size() - 1) {

	
		    
		    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length() -1, 0);

		    
		    int gap1_start = lis.get(i).endpos_s1;
		    int gap1_end = lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length();
		    
	
		    
		    gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - lis.get(i + 1).label.length() -1, 1);

		    if(gap1.length()==0&&gap2.length()==0) {
 			continue;
 		    }
		    
		    if(gap1.equals("")) {
					gap1 = "~";
				    }
				    
				    if(gap2.equals("")) {
					gap2 = "~";
				    }

		    if(gap1.length()==0||gap2.length()==0) {
			continue;
		    }
		    
		 
		    
		    int gap2_start = lis.get(i).endpos_s2;
		    int gap2_end = lis.get(i + 1).endpos_s2 - lis.get(i + 1).label.length();
		    
//		    System.out.println("Aligning: ");
//		    System.out.println(gap1+" "+gap1_start+" - "+gap1_end);
//		    System.out.println(gap2+" "+gap2_start+" - "+gap2_end);
//		    		    
		    String z = gap1;
		    String y = gap2;
		    
	

		    int misMatchPenalty = 3; 
		    int gapPenalty = 1; 
		 		
		    	String [] subalignment =  NeedlemanWunsch.getMinimumPenalty(z, y, misMatchPenalty, gapPenalty);
//			for(int k =0; k<subalignment.length;k++){
//			    System.out.println(subalignment[k]+" ... ");
//			}
			
			int start1=gap1_start;
			int start2=gap2_start;
			

			String matchstring = "";
			
			for(int l =0;l<subalignment[0].length();l++){
			    
			    
			    if(subalignment[0].charAt(l)==subalignment[1].charAt(l)){
				matchstring+=subalignment[0].charAt(l);
				
			    }
			    else {
				if(matchstring.length()>0){
				    result.add(new LCS_Triple(start1+matchstring.length(),start2+matchstring.length(),matchstring));
			    
			    	start1+=matchstring.length();
			    	start2+=matchstring.length();
			    	matchstring = "";

			    	}
				
				
				if(subalignment[0].charAt(l)!='_'){
					start1+=1;
				}
				if(subalignment[1].charAt(l)!='_'){
				    start2+=1;
				}
				
			    
			}
		  	   
  
		}

		}

	    }
	    
//	    if(addcount > 0) result = minimize_gaps_hirschberg(result);

	   return result;

}
// end new
    
    
    public ArrayList<LCS_Triple> remove_overlaps(ArrayList<LCS_Triple> lis) {
  	    
	ArrayList<LCS_Triple> result = new ArrayList();

    	    for (int i = 0; i < lis.size(); i++) {
 
    		if (i < lis.size() - 1) { 			
    			
    		    int  x = lis.get(i+1).label.length();
    		    
    		    if ((lis.get(i + 1).endpos_s1 - (x) <= lis.get(i).endpos_s1)&&(lis.get(i + 1).endpos_s2 - (x-1) <= lis.get(i).endpos_s2)) { 
    		    	
//    		    	if(lis.get(i + 1).label.length()>=lis.get(i).label.length()) {
//       	    		result.add(lis.get(i+1));
//    		    	    System.out.println("REMOVE "+ lis.get(i).label);
//    		    	    System.out.println(lis.get(i+1).label);
//    		    	    System.out.println("-.-------.-----------------");
//    		    	    i=i+1;
//    		    	    continue;
//
//
//    		    	}
//    		    	else {
//		    		result.add(lis.get(i));
//    		    	    System.out.println("REMOVE" +lis.get(i+1).label);
//		    	    System.out.println( lis.get(i).label);
//    		    	    System.out.println("-.-------.-----------------");
//   		    	    i=i+1;
//    		    	    continue;
//
//    		    	}
    		    }
    		    
    		 		    
    		    else if ((lis.get(i + 1).endpos_s1 - (x-1) <= lis.get(i).endpos_s1)||(lis.get(i + 1).endpos_s2 - (x-1) <= lis.get(i).endpos_s2)) { 
    		    	
    		    	if(lis.get(i + 1).label.length()>=lis.get(i).label.length()) {
       	    		result.add(lis.get(i+1));
       	   
//    		    	    System.out.println("REMOVE "+ lis.get(i).label);
//    		    	    System.out.println(lis.get(i+1).label);
//    		    	    System.out.println("-.-------.-----------------");
    		    	    i=i+1;
    		    	    continue;


    		    	}
    		    	else {
		    		result.add(lis.get(i));
//    		    	    System.out.println("REMOVE" +lis.get(i+1).label);
//		    	    System.out.println( lis.get(i).label);
//    		    	    System.out.println("-.-------.-----------------");
		    		
		
		    		
   		    	    i=i+1;
    		    	    continue;

    		    	}
    		    }
    		    else{
        		    result.add(lis.get(i));

    		    }
    		    
    		    
    		}
    		
    		else{
    		    result.add(lis.get(i));
    		}
    		
    		
    	    }
    	    
    	if (result.size() >0) { 			

    	    if(!result.get(0).label.startsWith("#")) {
    	    	LCS_Triple start_triple = new LCS_Triple(1,1,"#");
    	    result.add(0,start_triple);
    	    }
    	 
    		}
    		
    	    return result;

        }
    
    
    public ArrayList<LCS_Triple> remove_special_nodes(List special_nodes,ArrayList<LCS_Triple> lis) {
	
	    for (int i = 0; i < lis.size(); i++) {
		if(special_nodes.contains(lis.get(i).label)){
		    lis.remove(i);
		}
		
	    }
	   
			
	    return lis;

    }

    public void print_alignment_html(String filepath, String filename, ArrayList<LCS_Triple> lis) {

	try {
	    BufferedWriter bw1 = new BufferedWriter(new FileWriter(filepath + ".html"));
	
	    bw1.write("<!DOCTYPE html>");
	    bw1.write("<head>");
	    bw1.write("<title>SCDAWG Alignment</title>");
	    bw1.write("<meta charset='UTF-8'>");
	    bw1.write("<link rel='stylesheet' href='css/bootstrap.css'>");
	    bw1.write("<link rel='stylesheet' href='css/font-awesome.min.css'>");
	    bw1.write("<link rel='stylesheet' href='css/app.css'>");
//	    bw1.write("<script src='js/vendor/jquery.js'></script> ");
//	    bw1.write("<script src='js/vendor/bootstrap.js'></script>");
//	    bw1.write("<script src='js/app.js'></script>");

	    bw1.write("</head>");
	    bw1.write("<body>");
	    bw1.write("<h3 style='text-align: center;'> Alignment of '"+ filename +"'</h3>");

	    String alignment_str1 = "";
	    String alignment_str2 = "";
	    
	
	    for (int i = 0; i < lis.size(); i++) {
		int e1 = lis.get(i).endpos_s1;
		int e2 = lis.get(i).endpos_s2;
		
		String nodelabel  = lis.get(i).label;
		nodelabel = nodelabel.replace("<","");
		nodelabel = nodelabel.replace("<","");

		String gap1 = "";
		String gap2 = "";
	
		
//		 System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);

		if (i < lis.size() - 1) {
			
			
		    int  x = lis.get(i+1).label.length();
		 		    


			    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - x -1, 0);
				gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - x -1, 1);
			
				gap1 = gap1.replace("<","");
				gap1 = gap1.replace(">","");
				gap2 = gap2.replace("<","");
				gap2 = gap2.replace(">","");
		    
		    if(gap1.equals("")) {
			gap1 = "~";
		    }
		    
		    if(gap2.equals("")) {
			gap2 = "~";
		    }
		    
//		    System.out.println("gap 1 "+gap1+" gap 2 "+gap2);
//		    System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x+ " " + x));
//		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " +" ->> "+  lis.get(i + 1).label  +" <-- "+ (lis.get(i + 1).endpos_s2 - x+ " " +x));
		}
		
		
//		System.out.println("NODELABEL: "+nodelabel);
		
		alignment_str1 += nodelabel + "<span id='" + i + "' class='gapdiv'>" + gap1 + "</span>";
		alignment_str2 += nodelabel + "<span id='" + i + "' class='gapdiv'>" + gap2 + "</span>";

	    }

	    bw1.write("<div class=\"container-fluid\" id=\"0\">");
	    bw1.write("<div class=\"row\" id=\"0\">");

	    bw1.write("<div class=\"col-md-6 alignment_col left-container\" id=\"0\">");
	    bw1.write("<div class=\"card\">");

	    bw1.write("<h4 class=\"card-header text-center\">Document 1</h4>");
	    bw1.write("<div class=\"card-body\">");

	    bw1.write("<p class=\"card-text\">"+alignment_str1 + "</p></div></div></div>");

	    bw1.write("<div class=\"col-md-6 alignment_col right-container\" id=\"0\">");
	    bw1.write("<div class=\"card\">");

	    bw1.write("<h4 class=\"card-header text-center\">Document 2</h4>");
	    bw1.write("<div class=\"card-body\">");

	    bw1.write("<p class=\"card-text\">"+alignment_str2 + "</p></div></div></div>");

	    bw1.write("</div>");
	    bw1.write("</div>");

	    // Map.Entry pair = (Map.Entry) it2.next();
	    // Node n = (Node) pair.getKey();
	    // Integer count = (Integer) pair.getValue();
	    // // System.out.println(scdawg.get_node_label(n) + "->" +
	    // count);
	    //
	    // if (n.stringnr == 0) {
	    // bw1.write(scdawg.get_node_label(n) + ":" + count);
	    // bw1.newLine();
	    // }
	    //

	    bw1.close();

	} catch (IOException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}

    }
    
    public void print_alignment_json(String filepath, String filename, ArrayList<LCS_Triple> lis) {

    	try {
    	    BufferedWriter bw1 = new BufferedWriter(new FileWriter(filepath + ".json"));
    	

    	    bw1.write("[");

    	    String alignment_str1 = "";
    	    String alignment_str2 = "";
    	    
    	    String d = "";
    	
    	    for (int i = 0; i < lis.size(); i++) {
    		int e1 = lis.get(i).endpos_s1;
    		int e2 = lis.get(i).endpos_s2;
    		
    		String nodelabel  = lis.get(i).label;
    		 nodelabel  = nodelabel.replaceAll("\"","\\\"");

    		bw1.write("{\"match\":\""+nodelabel+"\",");
    		bw1.write("\"endpos_s1\":\""+e1+"\",");

    		if (i == lis.size() - 1) {
        		bw1.write("\"endpos_s2\":\""+e2+"\"}");

    		}
    		else {
        		bw1.write("\"endpos_s2\":\""+e2+"\",");

    		}
    		
    		String gap1 = "";
    		String gap2 = "";
    	
    		
//    		 System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);

    		if (i < lis.size() - 1) {
    			
    			
    		    int  x = lis.get(i+1).label.length();
    		 		    


    			    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - x -1, 0);
    				gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - x -1, 1);
    			    
            		gap1  = gap1.replaceAll("\"","");
            		gap2  = gap2.replaceAll("\"","");
    				
    		    if(gap1.equals("")) {
    		    	gap1 = "|";
    		    }
    		    
    		    if(gap2.equals("")) {
    		    	gap2 = "|";    
    		    }
    		    
    

    	   		bw1.write("\"gap_s1\":\""+(gap1)+"\",");
    	   		
        	
        		
            		bw1.write("\"gap_s2\":\""+(gap2)+"\"},");

        		

    	   		

    	  	
//    		    System.out.println("gap 1 "+gap1+" gap 2 "+gap2);
//    		    System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x+ " " + x));
//    		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " +" ->> "+  lis.get(i + 1).label  +" <-- "+ (lis.get(i + 1).endpos_s2 - x+ " " +x));
    		}
    		
    		
//    		System.out.println("NODELABEL: "+nodelabel);


    	    }
    	    
    	    bw1.write("]");

    	
    	    bw1.close();

    	} catch (IOException e) {
    	    // TODO Auto-generated catch block
    	    e.printStackTrace();
    	}

        }
    
    public String get_alignment_html(ArrayList<LCS_Triple> lis,ArrayList<ArrayList<LCS_Triple>> intervalls,int totallines) {

    		String result = ""+totallines;

    		int intervall_start = -1;
    		int intervall_end = - 1;
    		
    		int gaps1length = 0;
    		int match1length = 0;
    		int gaps2length = 0;
    		int match2length = 0;
    		
    	    for (int i = 0; i < lis.size(); i++) {
    	    
    	   
    	    	
    	    String container = "";
    	    	
    		int e1 = lis.get(i).endpos_s1;
    		int e2 = lis.get(i).endpos_s2;
    		
    		String nodelabel  = lis.get(i).label;
//    		nodelabel = nodelabel.replaceAll("\\s+","_");

    		String gap1 = "";
    		String gap2 = "";
    		// System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel,
    		// e1, e2);

    	


	   			 for (int j=0;j<intervalls.size();j++) {
	   				 ArrayList<LCS_Triple> intervall = intervalls.get(j);
	   				 
	   				 if(intervall.size()<2) {
	   					 continue;
	   				 }

	   				 if(intervall.get(0).endpos_s1==e1) {
	   					 intervall_start = e1;
	   					 intervall_end = intervall.get(intervall.size()-1).endpos_s1;
	   				 }

	   			 }
   		 		    
	   			if (i < lis.size() - 1) {
	   			 
//    		     System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x));
//    		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " + (lis.get(i + 1).endpos_s2 - x));

//    		    gap1 = (scdawg.stringset.get(0).substring(lis.get(i).endpos_s1,
//    			    lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length()));
//    		    		  
    //
//    		    gap2 = (scdawg.stringset.get(1).substring(lis.get(i).endpos_s2,
//    			    lis.get(i + 1).endpos_s2 -lis.get(i + 1).label.length()));
    			
    			
    		    
    		    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length() -1, 0);
    		    gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - lis.get(i + 1).label.length() -1, 1);
    		    
//    		    gap1 = gap1.replaceAll("\\s+","_");
//    		    gap2 = gap2.replaceAll("\\s+","_");

//    		    System.out.println("gap 1"+gap1);
//    		    System.out.println("gap 2"+gap2);
    		    
//    		    if(gap1.equals("")) {
//	    		    for (char ch: gap2.toCharArray()) {
//	    				gap1+="~";
//	    			}
//    		    }
//    		    
//    		    if(gap2.equals("")) {
//        		    for (char ch: gap1.toCharArray()) {
//        				gap2+="~";
//        			}
//        		}
    		    
    		    if(gap1.equals("")) {
    		    	gap1=" ";
    		    }
    		    
    		    
    		    if(gap2.equals("")) {
    		    	gap2=" ";
    		    }

    		    
    		}
    		
    		gaps1length+=gap1.length();
    		gaps2length+=gap2.length();

    		match1length+=nodelabel.length();
    		    
    		String intervall_marker = "";
    		if(intervall_start==e1) {
    			intervall_marker = "<div class='intervall_start intervall'>{</div>";
    	    		container +=  intervall_marker + "<div class='matchdiv'><div>" + nodelabel + "</div>";
    	    		container +=  "<div>" + nodelabel + "</div></div>" ;

    		}
    		else if(intervall_end==e1) {
    			intervall_marker = "<div class='intervall_end intervall'>} </div>";
    	    		container += "<div class='matchdiv'><div>" + nodelabel + "</div>";
    	    		container +=  "<div>" + nodelabel + "</div></div>"+ intervall_marker;

    		}
    		else {
	    		container += "<div class='matchdiv'><div>" + nodelabel + "</div>";
	    		container +=  "<div>" + nodelabel + "</div></div>" ;

    		}
    		
    		

    		if(!gap1.equals("")) {
				container += "<div class='gapdiv'><div id='" + i + "' class='gap1'>" + gap1 + "</div>"+ "<div id='" + i + "' class='gap2'>" + gap2 + "</div></div>";

//    			if(gap1.length()==1&&gap2.length()==1){
//    	    		container += "<div class='matchdiv'><div id='" + i + "' class='gap1'>" + gap1 + "</div>"+ "<div id='" + i + "' class='gap2'>" + gap2 + "</div></div>";
//    			}
//    			else{
//    				container += "<div class='gapdiv'><div id='" + i + "' class='gap1'>" + gap1 + "</div>"+ "<div id='" + i + "' class='gap2'>" + gap2 + "</div></div>";
//    			}
    		}
    		else {
//        		container += "</div>";
    		}
    
    		result += container;
    	    }
    	    
//    	    System.out.println(match1length);
//    	    	 
//    	    System.out.println(gaps1length);
//    	    System.out.println(gaps2length);

    	    
     	    return result;

        }
    
    public void addName(ArrayList names,String s) {
    	if(!s.equals("")&&Character.isUpperCase(s.charAt(0))){
    		names.add(s);
    	}
    }
    
    public ArrayList get_alignment_intervalls(ArrayList<LCS_Triple> intervall) {

    	ArrayList result = new ArrayList();

		int intervall_start = -1;
		int intervall_end = - 1;
		
		int gaps1length = 0;
		int match1length = 0;
		int gaps2length = 0;
		int match2length = 0;
		
		ArrayList names1= new ArrayList();
		ArrayList names2= new ArrayList();
		
		String intervall_string1= "";
		String intervall_string2="";

		
		String intervall_string = "";

		String nextname1 = "";
		String nextname2 = "";
		
		for (int j=0;j<intervall.size();j++) {
	    
	   
		 if(intervall.size()<2) {
				 continue;
			 }

			
		 
	    String container = "";
	    	
		int e1 = intervall.get(j).endpos_s1;
		int e2 = intervall.get(j).endpos_s2;
		
		String nodelabel  = intervall.get(j).label;
//		nodelabel = nodelabel.replaceAll("\\s+","_");
   		intervall_string += nodelabel;

		String gap1 = "";
		String gap2 = "";
//		 System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);

	
		 
		 	if(Util.startsWithWordBound(nodelabel)) {
		 	
  	   		addName(names1,nextname1);
  	   		addName(names2,nextname2);
	
  	   			nextname1="";
  	   			nextname2="";
		 	}
		 
		 	
	
 			ArrayList<String> matchsplit = Util.splitWordBounds(nodelabel);
   			   			

   			// split and add all matching names, continue with last 
   			for (int r=0;r<matchsplit.size();r++) {
   				
   				if(r==0) {
   					
   				 	if(Util.startsWithWordBound(nodelabel)) {
//   				 	System.out.println("IFFFFFFF");
	   	 		 		if(!nextname1.equals("")) {
	   	 	  	   			addName(names1,nextname1);
		   	   	   			nextname1="";
	   	 		 		}
	   	 		 		
		   	 			if(!nextname2.equals("")) {
//		   	 		 		System.out.println("IFFFFFFF2");
	
		   	 		 		addName(names2,nextname2);
		   	   	   			nextname2="";
	   	 		 		}
   	   	   			
   				 	}
   				 	else if(matchsplit.size()>1||Util.endsWithWordBound(nodelabel)){

   				 		
   				 		
//	   	 		 		System.out.println("IFFFFFFF3");
	   	 		 		if(!nextname1.equals("")) {
		   	   	   			addName(names1,nextname1+matchsplit.get(r));
		   	   	   			nextname1="";


	   	 		 		}
	   	 		 		
		   	 			if(!nextname2.equals("")) {
//		   	 		 		System.out.println("IFFFFFFF4");

		   	   	   			addName(names2,nextname2+matchsplit.get(r));
		   	   	   			nextname2="";
	   	 		 		}
	   	   	   			
   				 		}
		 
    				}
   				
   	   			if (r < matchsplit.size() - 1) {
   	   			
   	   				if(Character.isUpperCase(matchsplit.get(r).charAt(0))) {
//   	   	   				System.out.println("Erster NAME: "+matchsplit.get(r));
	   	   	   			addName(names1,matchsplit.get(r));
	   	   	   			addName(names2,matchsplit.get(r));

   	   				}
   	   				
   	   				
   	   			}
   	   			else if(Character.isUpperCase(matchsplit.get(r).charAt(0))) {
   	   				
   	   			
   	   				
   	   				nextname1= matchsplit.get(r);
   	   				nextname2= matchsplit.get(r);

   	   			}
   	   			else {
   	   				if(!nextname1.equals("")) {
   	   	   				nextname1+= matchsplit.get(r);
   	   				}
   	   			if(!nextname2.equals("")) {
	   	   				nextname2+= matchsplit.get(r);
	   				}
   	   				
   	   			}
   	   			

   			}

   			if(nextname1.length()>0) {
//   			System.out.println("NEXT NAME1 " +nextname1);
   			}
   			if(nextname2.length()>0) {
//   	   			System.out.println("NEXT NAME2 " +nextname2);
   	   			}
   			
   			
   			if(nextname1.equals("")||nextname2.equals("")) {
   				continue;
   			}
   			
   			if (j < intervall.size() - 1) {
   			 
//		     System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x));
//		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " + (lis.get(i + 1).endpos_s2 - x));

//		    gap1 = (scdawg.stringset.get(0).substring(lis.get(i).endpos_s1,
//			    lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length()));
//		    		  
//
//		    gap2 = (scdawg.stringset.get(1).substring(lis.get(i).endpos_s2,
//			    lis.get(i + 1).endpos_s2 -lis.get(i + 1).label.length()));
			
			
		    
		    gap1 = scdawg.getSubstringFromArray(intervall.get(j).endpos_s1, intervall.get(j + 1).endpos_s1 - intervall.get(j + 1).label.length() -1, 0);
		    gap2 = scdawg.getSubstringFromArray(intervall.get(j).endpos_s2, intervall.get(j + 1).endpos_s2 - intervall.get(j + 1).label.length() -1, 1);
		    
//		    gap1 = gap1.replaceAll("\\s+","_");
//		    gap2 = gap2.replaceAll("\\s+","_");

//		    System.out.println("gap 1"+gap1);
//		    System.out.println("gap 2"+gap2);
		    
		    ArrayList<String> gap1split = Util.splitWordBounds(gap1);
		    ArrayList<String> gap2split = Util.splitWordBounds(gap2);
		    

		    if(gap1split.size()>1) {
			    nextname1+=gap1split.get(0);
	   	   		addName(names1,nextname1);

//	   			System.out.println("Gap end ADD NEXT NAME1 " +nextname1);

				nextname1="";

		    }
		    else {
			    nextname1+=gap1;
		    }
		    
		    if(gap2split.size()>1) {
			    nextname2+=gap2split.get(0);
   	   			addName(names2,nextname2);
//	   			System.out.println("Gap end ADD NEXT NAME2 " +nextname2);

				nextname2="";

		    }
		    else {
			    nextname2+=gap2;

		    }
		    

//		    

		    
//		    if(gap1.equals("")) {
//		    	gap1=" ";
//		    }
//		    
//		    
//		    if(gap2.equals("")) {
//		    	gap2=" ";
//		    }

		    
		}
		
//		intervall1.add(nodelabel);
//		intervall1.add(gap1);
//		intervall2.add(nodelabel);
//		intervall2.add(gap2);

   			intervall_string1+=nodelabel+gap1;
   			intervall_string2+=nodelabel+gap2;

	    }
	    

		
		result.add(names1);
		result.add(names2);
		

	    
 	    return result;

    }
    
    
    public ArrayList<ArrayList<LCS_Triple>> get_intervalls(ArrayList<LCS_Triple> lis,double bound) {

    	ArrayList<ArrayList<LCS_Triple>> result = new ArrayList<ArrayList<LCS_Triple>> ();
		
		ArrayList<LCS_Triple> old_intervall = new ArrayList<LCS_Triple>();

	    for (int i = 0; i < lis.size(); i++) {
	    	double white = 0.0;
	    	double red = 0.0;
	    	double match_ratio = 1;
			
			ArrayList<LCS_Triple> intervall = new ArrayList<LCS_Triple>();

//			System.out.println(".......................");
	    for(int j = i; j < lis.size(); j++) {

		String nodelabel  = lis.get(j).label;
		nodelabel = nodelabel.replaceAll("\\s+","_");
		
		white += (nodelabel.length()*2);
//		if(red>0) {
//			match_ratio =  (white/red)/2;
//		}
		
		intervall.add(lis.get(j));

		String gap1 = "";
		String gap2 = "";
		// System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel,
		// e1, e2);
		double next_white = 0;
		if (j < lis.size() - 1 ) {

		    gap1 = scdawg.getSubstringFromArray(lis.get(j).endpos_s1, lis.get(j + 1).endpos_s1 - lis.get(j + 1).label.length() -1, 0);
		    gap2 = scdawg.getSubstringFromArray(lis.get(j).endpos_s2, lis.get(j + 1).endpos_s2 - lis.get(j + 1).label.length() -1, 1);
		
			red += gap1.length() + gap2.length();
			next_white =  (lis.get(j + 1).label.length()*2);
			
		}
			match_ratio =  ((white+next_white)/red)/2;
//			    System.out.println("White "+ white +"next white " + next_white + " red "+red+ "  "+ match_ratio);

//			System.out.println(gap1.length() + " / "+ gap2.length());
			
			double gap_diff = Math.abs((double)gap1.length() -  (double)gap2.length());
//			System.out.println(gap_diff);
			if(match_ratio< bound||nodelabel.contains("$")) {
				if(intervall.size()>=2) {
					
					if(old_intervall.size()>0) {
						
//						System.out.println("-----------------------xxx");
//						System.out.println(intervall.get(0).endpos_s1);
//						System.out.println(old_intervall.get(0).endpos_s1);
//						System.out.println(intervall.get(intervall.size()-1).endpos_s1);
//						System.out.println(old_intervall.get(old_intervall.size()-1));
//						System.out.println("-----------------------xxx");

						if(intervall.get(0).endpos_s1>=old_intervall.get(0).endpos_s1&&intervall.get(intervall.size()-1).endpos_s1<=old_intervall.get(old_intervall.size()-1).endpos_s1) {
							System.out.println("überlapp");
							break;
						}
					
					}
					
					result.add(intervall);
					i=j;
					
					old_intervall = new ArrayList();
					for(int k=0;k<intervall.size();k++) {
						old_intervall.add(intervall.get(k));
					}
					
					
				}
				break;
			}

	
		
    

	    }
	    
//	    if(match_ratio>= bound) result.add(intervall);

	    }
	    	 
 	    return result;

    }
    
    public void print_alignment_latex(String filepath, String filename, ArrayList<LCS_Triple> lis) {

   	try {
   	    BufferedWriter bw1 = new BufferedWriter(new FileWriter(filepath + filename + ".tex"));

   	    int nodecount = 0;
   	    
   	    String alignment_str1 = "";
   	    String alignment_str2 = "";
	
   	    int cnt = 0;
   	    for (int i = 0; i <100; i++) {
   		
   		if(cnt==0){
   		 alignment_str1+="\\scalebox{0.6}[0.4]{";
   		 alignment_str2+="\\scalebox{0.6}[0.4]{";
   		 
   		}
   		
   		int e1 = lis.get(i).endpos_s1;
   		int e2 = lis.get(i).endpos_s2;
   		
   		String nodelabel  = lis.get(i).label;
   		
   		if(nodelabel.contains("#")){
   		  nodelabel =  nodelabel.replace("#","\\#");
   		}
   		
   		if(nodelabel.contains("$")){
     		  nodelabel =  nodelabel.replace("$","\\$");
     		}
   		  nodelabel =  nodelabel.replace("{","\\{");
   		  nodelabel =  nodelabel.replace("}","\\}");
   		  nodelabel =  nodelabel.replace("&","\\&");

   		if(nodelabel.equals(" ")){
       		  nodelabel =  "x";
       		}
   		  
   		String gap1 = "";
   		String gap2 = "";
   	
   		
//   		 System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);

   		if (i < lis.size() - 1) {
   			
   			
   		    int  x = lis.get(i+1).label.length();
   		 		    


   			    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - x -1, 0);
   				gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - x -1, 1);

   				gap1 =  gap1.replace("{","\\{");
   				gap1 =  gap1.replace("}","\\}");
   				gap2 =  gap2.replace("{","\\{");
   				gap2 =  gap2.replace("}","\\}");
   		    
   				gap2 =  gap2.replace("&","\\&");
   				gap1 =  gap1.replace("&","\\&");

   				
   		    if(gap1.equals("")) {
   			gap1 = "X";
   		    }
   		    
   		    if(gap2.equals("")) {
   			gap2 = "X";
   		    }
   		    
   		 if(gap1.equals(" ")) {
			gap1 = "X";
		    }
		    
		    if(gap2.equals(" ")) {
			gap2 = "X";
		    }
   		    
//   		    System.out.println("gap 1 "+gap1+" gap 2 "+gap2);
//   		    System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x+ " " + x));
//   		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " +" ->> "+  lis.get(i + 1).label  +" <-- "+ (lis.get(i + 1).endpos_s2 - x+ " " +x));
   		}
   		
   		
//   		System.out.println("NODELABEL: "+nodelabel);
   		nodecount++;
   		alignment_str1 += "\\colorbox{green!35}{\\textcolor{green!35}{"+nodelabel+"}}\\colorbox{red!65}{\\textcolor{red!65}{"+gap1+"}}\n";  
   		
   		alignment_str2 += "\\colorbox{green!35}{\\textcolor{green!35}{"+nodelabel+"}}\\colorbox{red!65}{\\textcolor{red!65}{"+gap2+"}}\n";  
  		cnt++;

  		if(cnt==10){
   	   	alignment_str2 += "}\\\\\n";  
   	   	alignment_str1 += "}\\\\\n" ; 
   	   	cnt=0;
      		}
   		
   	    }

   	  
   	    bw1.write(alignment_str1);
//   	    bw1.write(alignment_str2);
   	

   	 
   	    bw1.close();

   	} catch (IOException e) {
   	    // TODO Auto-generated catch block
   	    e.printStackTrace();
   	}

       }
    
    public void print_alignment_tikz(String filepath, String filename, ArrayList<LCS_Triple> lis) {

   	try {
   	    BufferedWriter bw1 = new BufferedWriter(new FileWriter(filepath + filename + ".html"));

   	    bw1.write("\\begin{tikzpicture}[>=stealth',shorten >=1pt,auto,initial text =,node distance=1cm]\n");
   	    int nodecount = 0;
   	    
   	    String alignment_str1 = "";
   	    String alignment_str2 = "";
		alignment_str1 += "\\node[align=left]("+nodecount+") []{$\\#$};\n";  
   		alignment_str2 += "\\node[align=left](2_"+nodecount+") [below=of "+(lis.size()-1)+".west,anchor=west]{$\\#$};\n";  

   	    for (int i = 0; i < lis.size(); i++) {
   		int e1 = lis.get(i).endpos_s1;
   		int e2 = lis.get(i).endpos_s2;
   		
   		String nodelabel  = lis.get(i).label;
   		
   		if(nodelabel.contains("#")){
   		  nodelabel =  nodelabel.replace("#","\\#");
   		}
   		
   		if(nodelabel.contains("$")){
     		  nodelabel =  nodelabel.replace("$","\\$");
     		}
   		
   		String gap1 = "";
   		String gap2 = "";
   	
   		
   		 System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel, e1, e2);

   		if (i < lis.size() - 1) {
   			
   			
   		    int  x = lis.get(i+1).label.length();
   		 		    


   			    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - x -1, 0);
   				gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - x -1, 1);
   			
   		 
   		    
   		    if(gap1.equals("")) {
   			gap1 = "~";
   		    }
   		    
   		    if(gap2.equals("")) {
   			gap2 = "~";
   		    }
   		    
//   		    System.out.println("gap 1 "+gap1+" gap 2 "+gap2);
//   		    System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x+ " " + x));
//   		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " +" ->> "+  lis.get(i + 1).label  +" <-- "+ (lis.get(i + 1).endpos_s2 - x+ " " +x));
   		}
   		
   		
//   		System.out.println("NODELABEL: "+nodelabel);
   		nodecount++;
   		alignment_str1 += "\\node[align=left]("+nodecount+")  [below=of "+(nodecount-1)+".west,anchor=west]{\\textit{"+nodelabel+"}};\n";  
   		alignment_str2 += "\\node[align=left](2_"+nodecount+")  [below=of 2_"+(nodecount-1)+".west,anchor=west]{\\textit{"+nodelabel+"}};\n";  
   		
   		nodecount++;
   		alignment_str1 += "\\node[fill=red!65,align=left] ("+nodecount+")  [base right = of "+(nodecount-1)+"]  {\\textit{"+gap1+"}};\n";
   		alignment_str2 += "\\node[fill=red!65,align=left] (2_"+nodecount+")  [base right = of "+(nodecount-1)+"]  {\\textit{"+gap2+"}};\n";
   	    }

   	  
   	    bw1.write(alignment_str1);
   	    bw1.write(alignment_str2);
   	    bw1.write("\n \\end{tikzpicture}\n");
   	

   	 
   	    bw1.close();

   	} catch (IOException e) {
   	    // TODO Auto-generated catch block
   	    e.printStackTrace();
   	}

       }
    
    public void line_alignment_by_endchar(String filepath, String filename,ArrayList<LCS_Triple> lis) {

    	try {
    	    BufferedWriter bw = new BufferedWriter(new FileWriter(filepath + filename + ".txt"));

    	  	ArrayList<String[]> result = new ArrayList<String[]>();

    	    String alignment_line1 = "";
    	    String alignment_line2 = "";

    	    for (int i = 0; i < lis.size(); i++) {
    		int e1 = lis.get(i).endpos_s1;
    		int e2 = lis.get(i).endpos_s2;
    		
    		String nodelabel  = lis.get(i).label;

    		String gap1 = "";
    		String gap2 = "";
    		// System.out.printf("\"%s\":e1:\"%s\", e2:\"%s\"\n", nodelabel,
    		// e1, e2);

    		if (i < lis.size() - 1) {

    		    int  x = lis.get(i+1).label.length();
    		 		    
    		    if ((lis.get(i + 1).endpos_s1 - x) < lis.get(i).endpos_s1
    			    || (lis.get(i + 1).endpos_s2 - x) < lis.get(i).endpos_s2) {
    			continue;
    		    } // TO DO: handle overlap correctly!

//    		     System.out.println("e1 " + lis.get(i).endpos_s1 + " e1+1 " + (lis.get(i + 1).endpos_s1 - x));
//    		     System.out.println("e2 " + lis.get(i).endpos_s2 + " e2+1 " + (lis.get(i + 1).endpos_s2 - x));

//    		    gap1 = (scdawg.stringset.get(0).substring(lis.get(i).endpos_s1,
//    			    lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length()));
//    		    		  
    //
//    		    gap2 = (scdawg.stringset.get(1).substring(lis.get(i).endpos_s2,
//    			    lis.get(i + 1).endpos_s2 -lis.get(i + 1).label.length()));
    		    
    		    gap1 = scdawg.getSubstringFromArray(lis.get(i).endpos_s1, lis.get(i + 1).endpos_s1 - lis.get(i + 1).label.length() -1, 0);
    		    gap2 = scdawg.getSubstringFromArray(lis.get(i).endpos_s2, lis.get(i + 1).endpos_s2 - lis.get(i + 1).label.length() -1, 1);

//    		    System.out.println("gap 1"+gap1);
//    		    System.out.println("gap 2"+gap2);
    		    
    

    
    		    
    		    if(gap2.contains("§")) {
//    		    	alignment_line1= alignment_line1.replace("#", "");
//    		    	alignment_line2=alignment_line2.replace("#", "");
//    		    	alignment_line1=alignment_line1.replace("$", "");
//    		    	alignment_line2=alignment_line2.replace("$", "");
//    		    	alignment_line2=alignment_line2.replace("§", "");
    		    	
    		    	String[] gap1split= gap1.split("&");
    		    	String[] gap2split= gap2.split("§");
    		    	
    		    	if(gap1split.length>1){
    		    	alignment_line1 += nodelabel +  gap1split[0];
    		    	}
    		    	else alignment_line1 += nodelabel;
    		    	
    		    	if(gap2split.length>1){
          		    alignment_line2 += nodelabel + gap2split[0] ;
    		    	}
    		    	else alignment_line2 += nodelabel;

    		    	result.add(new String[] {alignment_line1,alignment_line2});
    		    	
    		    	if(gap1split.length>1){
    		    	alignment_line1=gap1split[1];
    		    	}
    		    	else alignment_line1="";
    		    	if(gap2split.length>1){
    		    	alignment_line2=gap2split[1];
    		    	}
    		    	else alignment_line2="";

    		    }
    		    
    		    else {
    			    alignment_line1 += nodelabel +  gap1;
        		    alignment_line2 += nodelabel + gap2 ;
    		    }
    		    
    		    
    		}
    	

    	    }

    	    for(int i=0;i<result.size();i++) {
    	    	bw.write(result.get(i)[0]+"\n");
    	    	bw.write(result.get(i)[1]+"\n");
    	    	
    	    	int k=0;
    	    	if(result.get(i)[0].length()>=result.get(i)[1].length()) {
    	    	 k=result.get(i)[0].length();
    	    	}
    	    	else {
    	    		k=result.get(i)[1].length();
    	    	}
    	    	
    	    	String x ="";
    	    	for(int j=0;j<k;j++) {
    	    		x+="-";
    	    	}
    	    	
    	    	bw.write(x+"\n");
    	    	
    	    }
    	
    	    // Map.Entry pair = (Map.Entry) it2.next();
    	    // Node n = (Node) pair.getKey();
    	    // Integer count = (Integer) pair.getValue();
    	    // // System.out.println(scdawg.get_node_label(n) + "->" +
    	    // count);
    	    //
    	    // if (n.stringnr == 0) {
    	    // bw1.write(scdawg.get_node_label(n) + ":" + count);
    	    // bw1.newLine();
    	    // }
    	    //

    	    bw.close();

    	} catch (IOException e) {
    	    // TODO Auto-generated catch block
    	    e.printStackTrace();
    	}

        }

}
