import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import cdawg.Online_CDAWG;
import cdawg_sym.Common_SCDAWG_Functions;
import cdawg_sym.Online_CDAWG_sym;

import dawg.DAWG;
import indexstructure.Node;
import suffix_tree.Ukkonen_Suffixtree;
import suffix_trie.Naive_Suffixtrie;
import util.Util;
import com.sun.tools.javac.util.Pair;

import alignment_offline.Endpos_Tupel;
import alignment_offline.Hirschberg;
import alignment_offline.LCS_Alignment_Pairwise;
import alignment_offline.LCS_Triple;

import org.apache.commons.cli.*;

public class alignSC {

	public static void main(String[] args) {
		ArrayList<String> stringset = new ArrayList();
			

		
		Options options = new Options();

        Option input = new Option("i", "input", true, "input file path");
        input.setRequired(true);
        options.addOption(input);

        Option output= new Option("o", "output", true, "output");
        output.setRequired(false);
        options.addOption(output);
        
        Option debug = new Option("d", "debug", false, "enable debug prints");
        debug.setRequired(false);
        options.addOption(debug);
        
        Option align_sc = new Option("a1", "align_sc", false, "align_sc only");
        align_sc.setRequired(false);
        options.addOption(align_sc);
        
        Option align_sc_it = new Option("a2", "align_sc_it", false, "align sc iterative");
        align_sc_it.setRequired(false);
        options.addOption(align_sc_it);
        
        Option align_sc_h = new Option("a3", "align_sc_h", false, "align sc + hirschberg");
        align_sc_h.setRequired(false);
        options.addOption(align_sc_h);

        Option format = new Option("f", "format", true, "json|html");
        format.setRequired(true);
        options.addOption(format);
        
        Option eval = new Option("e", "eval", false, "evaluate against optimal alignment");
        eval.setRequired(false);
        options.addOption(eval);
        
        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;

        try {
            cmd = parser.parse(options, args);
        } catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("utility-name", options);

            System.exit(1);
        }

        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");
        String formatstring = cmd.getOptionValue("format");


        boolean debugbool = false;

        if(cmd.hasOption("debug")) {
	        String debugstring = cmd.getOptionValue("debug");
	        debugbool = true;
       
        }
        

        

		try {
		stringset = Util.readInputFile(inputFilePath);
		} catch (IOException e) {
			e.printStackTrace();
		}
			
	               
        if(cmd.hasOption("align_sc")) {
            
          	 LCS_Alignment_Pairwise alignment = new LCS_Alignment_Pairwise(stringset);
//   			 alignment.align(false);
	   		 alignment.align_lcs(2,false);
	   		 ArrayList <LCS_Triple> no_overlaps = new ArrayList();
	   		 no_overlaps = alignment.remove_overlaps(alignment.greedy_alignment); 
	   		 
	   		 
				 if(formatstring.equals("json")) {
					 alignment.print_alignment_json(outputFilePath+"_align_sc",outputFilePath, no_overlaps );

				 }
				 else {
					 alignment.print_alignment_html(outputFilePath+"_align_sc",outputFilePath, no_overlaps );

				 }
				 
			        if(cmd.hasOption("eval")) {
			        
			   		 String lcs_sc = "";
					 
					 for(int h=0;h<no_overlaps.size();h++){
					       lcs_sc+=no_overlaps.get(h).label;
					  }
			        	
			        	Hirschberg alg = new Hirschberg();
						String lcsh= alg.algC( stringset.get(0).length(),  stringset.get(1).length(), stringset.get(0), stringset.get(1)); //computes & prints out the result
						
						double ratio1 = (double) lcsh.length()/ (double) stringset.get(0).length();
						double ratio2 = (double) lcsh.length()/ (double) stringset.get(1).length();
						double combinedratio_h = (ratio1+ratio2)/2;
						
						 double ratiosc1 = (double) lcs_sc.length()/ (double) stringset.get(0).length();
							double ratiosc2 = (double) lcs_sc.length()/ (double) stringset.get(1).length();
							double combinedratio_sc = (ratiosc1+ratiosc2)/2;
//					
//						 System.out.println("Hirschberg combined "+combinedratio_h+"  sc combined "+combinedratio_sc);
					 
						 double correct_aligned = combinedratio_sc / combinedratio_h;
					 
						 System.out.println("Alignment rate " + correct_aligned);
			        	
			        }
				 
      		 
              }
        
        if(cmd.hasOption("align_sc_it")) {
            
        	LCS_Alignment_Pairwise alignment = new LCS_Alignment_Pairwise(stringset);
//  			 alignment.align(false);
	  		 alignment.align_lcs(2,false);
	  		 ArrayList <LCS_Triple> no_overlaps = new ArrayList();
	  		 no_overlaps = alignment.remove_overlaps(alignment.greedy_alignment); 
	  		 ArrayList <LCS_Triple> minimized = alignment.minimize_gaps_it(no_overlaps);
	  		 
	   		 
				 if(formatstring.equals("json")) {
					 alignment.print_alignment_json(outputFilePath+"_align_sc_it",outputFilePath, minimized );

				 }
				 else {
					 alignment.print_alignment_html(outputFilePath+"_align_sc_it",outputFilePath, minimized );

				 }
				 
			        if(cmd.hasOption("eval")) {
				        
				   		 String lcs_sc = "";
						 
						 for(int h=0;h<minimized.size();h++){
						       lcs_sc+=minimized.get(h).label;
						  }
				        	
				        	Hirschberg alg = new Hirschberg();
							String lcsh= alg.algC( stringset.get(0).length(),  stringset.get(1).length(), stringset.get(0), stringset.get(1)); //computes & prints out the result
							
							double ratio1 = (double) lcsh.length()/ (double) stringset.get(0).length();
							double ratio2 = (double) lcsh.length()/ (double) stringset.get(1).length();
							double combinedratio_h = (ratio1+ratio2)/2;
							
							 double ratiosc1 = (double) lcs_sc.length()/ (double) stringset.get(0).length();
								double ratiosc2 = (double) lcs_sc.length()/ (double) stringset.get(1).length();
								double combinedratio_sc = (ratiosc1+ratiosc2)/2;
//						
//							 System.out.println("Hirschberg combined "+combinedratio_h+"  sc combined "+combinedratio_sc);
						 
							 double correct_aligned = combinedratio_sc / combinedratio_h;
						 
							 System.out.println("Alignment rate " + correct_aligned);
				        	
				        }
				 
				 
     		 
             }
        
        if(cmd.hasOption("align_sc_h")) {
            
			 LCS_Alignment_Pairwise alignment = new LCS_Alignment_Pairwise(stringset);
			//alignment.align(false);
			 alignment.align_lcs(2,false);
			 ArrayList <LCS_Triple> no_overlaps = new ArrayList();
			 no_overlaps = alignment.remove_overlaps(alignment.greedy_alignment); 
			 ArrayList <LCS_Triple> minimized = alignment.minimize_gaps_hirschberg(no_overlaps);
		     		 
			 if(formatstring.equals("json")) {
				 alignment.print_alignment_json(outputFilePath+"_align_sc_h",outputFilePath, minimized );

			 }
			 else {
				 alignment.print_alignment_html(outputFilePath+"_align_sc_h",outputFilePath, minimized );

			 }
			 
			    if(cmd.hasOption("eval")) {
			        
			   		 String lcs_sc = "";
					 
					 for(int h=0;h<minimized.size();h++){
					       lcs_sc+=minimized.get(h).label;
					  }
			        	
			        	Hirschberg alg = new Hirschberg();
						String lcsh= alg.algC( stringset.get(0).length(),  stringset.get(1).length(), stringset.get(0), stringset.get(1)); //computes & prints out the result
						
						double ratio1 = (double) lcsh.length()/ (double) stringset.get(0).length();
						double ratio2 = (double) lcsh.length()/ (double) stringset.get(1).length();
						double combinedratio_h = (ratio1+ratio2)/2;
						
						 double ratiosc1 = (double) lcs_sc.length()/ (double) stringset.get(0).length();
							double ratiosc2 = (double) lcs_sc.length()/ (double) stringset.get(1).length();
							double combinedratio_sc = (ratiosc1+ratiosc2)/2;
//					
//						 System.out.println("Hirschberg combined "+combinedratio_h+"  sc combined "+combinedratio_sc);
					 
						 double correct_aligned = combinedratio_sc / combinedratio_h;
					 
						 System.out.println("Alignment rate " + correct_aligned);
			        	
			        }
			 
			 
             }

    		 

		 java.io.PrintStream out = System.out;
		 Runtime runtime = Runtime.getRuntime();

			// To convert from Bytes to MegaBytes:
			// 1 MB = 1024 KB and 1 KB = 1024 Bytes.
			// Therefore, 1 MB = 1024 * 1024 Bytes.
			long MegaBytes = 1024 * 1024;

			// Memory which is currently available for use by heap
			long totalMemory = runtime.totalMemory() / MegaBytes;
			out.println("Heap size available for use -> " + totalMemory + " MB");

			// Maximum memory which can be used if required.
			// The heap cannot grow beyond this size
			long maxMemory = runtime.maxMemory() / MegaBytes;
			out.println("Maximum memory Heap can use -> " + maxMemory + " MB");

			// Free memory still available
			long freeMemory = runtime.freeMemory() / MegaBytes;
			out.println("Free memory in heap -> " + freeMemory + " MB");

			// Memory currently used by heap
			long memoryInUse = totalMemory - freeMemory;
			out.println("Memory already used by heap -> " + memoryInUse + " MB");



	}
	
	
	

}

