#title: "VennDiagramm_script"
#author: Paulina Mrozek-Gorska & Dr. Alexander Buschle
#application: PhD thesis of Paulina Mroze-Gorska, comparison of 2 types of sequencing libraries

#use data after DESeq2 analysis of RNA-seq experiments from Antonio Scialdone, significantly DE genes for both types of libraries

read.table("/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/2_polyA_analysis/polyA_antonio_sig.tsv")
polyA_gene_sig <- read.table("/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/2_polyA_analysis/polyA_antonio_sig.tsv", sep="", header=F)
random_gene_sig <- read.table("/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/random_Hex_Home_windows/random_sig_Paula2.tsv", sep="", header=F)
head(random_gene_sig) 
head(polyA_gene_sig)

#cut out information containing only gene names
libraries_diff <- setdiff(random_gene_sig$V1, polyA_gene_sig$V1)
libraries_diff_polyA <- setdiff(polyA_gene_sig$V1, random_gene_sig$V1)
length(libraries_diff_polyA)
write.csv(libraries_diff_polyA, file = "libraries_diff_polyA.csv", row.names = FALSE, quote = FALSE)
getwd()

# check intersection between two types of libraries
intersect <- intersect(random_gene_sig$V1, polyA_gene_sig$V1)
length(intersect)

# create VennDiagram to visualize comparison of 2 sequencing libraries types 
require("gplots")
venn(list(first.vector = random_gene_sig, second.vector = polyA_gene_sig))

install.packages("VennDiagram")
require("VennDiagram")

pdf("venn_diagram_libraries.pdf")
venn.plot <- venn.diagram(list(random_gene_sig$V1, polyA_gene_sig$V1), NULL, fill=c("orange", "purple1"), alpha=c(0.5,0.5), cex = 2, cat.fontface=4, category.names=c("random library", "polyA library"))
grid.draw(venn.plot)
dev.off()

