# Author: Paulina Mrozek-Gorska & Dr. Antonio Scialdone
# Date created: 12/2017
# Application: UpSet pairwise comparison for PhD thesis of Paulina Mrozek-Gorska, discussion part

#Suggested by Antonio Scialdone to compare DE genes from following pairwise comparisons from RNAseq experiments

load("/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/2_polyA_analysis/diff_antonio.RData")
head(diff_antonio)

#filter the DESeq2 matrix from RNAseq data excluding NA values and padj <0.1
filtered_matrix<-lapply(diff_antonio, function(x) row.names(x[x$padj<0.1 & !is.na(x$padj),]))
head(filtered_matrix)

#extact info about each pairwise comparison, one by one (DE_1_Day0_1, DE1_Day1_2 etc.)
DE_1_Day0_1 <- filtered_matrix$Day0_Day1
length(DE_1_Day8_14)
class(DE_1_Day1_2)

write.table(DE_1_Day0_1, file="/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/Days intersections/DE_Day0_1.txt", row.names=F, col.names = F, quote=F )
write.csv(DE_1_Day8_14, file="/Users/PaulinaMrozek/Desktop/RNA-seq_procedure_AS/Antonio_analysis/171206/R_scripts/analysis/Days intersections/DE_Day8_14.csv", row.names=F, quote=F )

days <- c(DE_1_Day0_1, DE_1_Day1_2, DE_1_Day2_3, DE_1_Day3_4, DE_1_Day4_5, DE_1_Day5_8, DE_1_Day8_14)
head(days2)
colnames(days2)
colnames(days) <- c("Day0_1", "Day1_2", "Day2_3", "Day3_4", "Day4_5", "Day5_8", "Day8_14")

DE_1_Day8_14 <- filtered_matrix$Day8_Day14
length(DE_1_Day8_14)

# Upset visualization of intersecting sets, of DeSeq2 pairiwse comparisons

install.packages("UpSetR")
library(UpSetR)
library(ggplot2)
library(grid)
library(plyr)

listInput <- list(Day0_1 = for_Venn_day0_1_no0, Day1_1 = for_Venn_day1_1_no0, Day2_1 = for_Venn_day2_1_no0, Day3_1 = for_Venn_day3_1_no0, Day4_1 =for_Venn_day4_1_no0, Day5_1 = for_Venn_day5_1_no0, Day14_1 = for_Venn_day14_1_no0)

upset(fromList(listInput), nsets = 8, number.angles = 30)                  #without order sample by sample
upset(fromList(listInput), nsets = 8, number.angles = 30, order.by = "freq") #ordered by frequency
upset(fromList(listInput), nsets = 8, number.angles = 30, group.by ="sets", cutoff = 5 ) # 5 from each set




