
-- Französische Elemente in ägyptischen Theaterstücken der Nahḍa (1870-1918)
-- Emma Mages
-- 2018


-----------------------------
-- Abfragen: Theaterstücke --
-----------------------------

--- q1 (lexikalische Entlehnungen): 
select distinct author,play,lemma,lemma_dmg,group_concat(distinct token_dmg separator ', ') as types,count(token) as vorkommen,pos,replace(language,',',', ') as language,replace(etymon,',',', ') as etymon 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' 
			group by play,lemma 
---- a) alphabetisch: 
				order by author,play,lemma_dmg;
---- b) nach Vorkommen: 
				order by author,play,count(token) desc;



--- q2 (Wortarten nach Stücken): 
select author,play,count(distinct t.idlem),l.pos 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' 
			group by author,play,pos 
				order by author,play,count(distinct t.idlem) desc;



--- q3 (Figuren und Entlehnungen): 
select q2.author,q2.play,q2.name_dmg_role,q1.countDistinctIdlem,q1.countToken,q2.profession 
	from (
		select distinct t.play,t.speaker,count(distinct t.idlem) as countDistinctIdlem,count(t.token) as countToken 
			from lemmata l join tokens t on (l.id=t.idlem) 
				where (l.language like '%F%' and t.borrtype like 'lex') 
					group by t.play,t.speaker)q1 
		right join (
		select pl.author,p.play,p.name,concat(p.name_dmg,': ',p.role) as name_dmg_role,p.profession 
			from persons p join plays pl on (p.play=pl.play))q2 
		on (q1.speaker=q2.name and q1.play=q2.play) 
			order by author,play,countDistinctIdlem desc,countToken desc;



--- q4 (lexikalische Entlehnungen Ǧalāl, F u.a.): 
select distinct tok.id as idtok,q.idlem as idlem,q.author,q.play,q.lemma,q.lemma_dmg,q.tokenConcat,q.vorkommen, tok.token,tok.context,tok.speaker,tok.page,tok.act,tok.comment as tokComment,q.comment as lemComment 
	from (
		select distinct author,play,l.id as idlem,lemma,lemma_dmg,group_concat(distinct token separator ', ') as tokenConcat,count(token) as vorkommen,l.comment 
			from tokens t join lemmata l on (t.idlem=l.id) 
				where t.borrtype like 'lex' and author like '%Ǧalāl%' 
					group by play,lemma)q join tokens tok on (q.idlem=tok.idlem and q.play=tok.play) 
						order by author,play,vorkommen desc,idlem,abs(page),tok.id;



--- q5 (syntaktische Besonderheiten): 
select distinct author,play,context,speaker,page,act,comment 
	from tokens t 
		where t.borrtype like 'syntax' 
			order by author,play,id,act,page;



--- q6 (semantische Entlehnungen): 
select distinct author,play,token,context,speaker,page,act,comment 
	from tokens 
		where borrtype like 'sem' 
			order by author,play,id,act,page;



--- q7 (Entlehnungen stückeübergreifend): 
select count(q1.play_dmg),sum(q1.vorkommen),lemma_dmg,group_concat(q1.play_dmg,': ',q1.vorkommen order by q1.playid separator '; ') 
	from (
			select distinct p.id as playid,p.author,play_dmg,lemma,lemma_dmg,group_concat(distinct token separator ', '),count(token) as vorkommen 
				from plays p join tokens t on (t.play=p.play) join lemmata l on (t.idlem=l.id) 
					where l.language like '%F%' and t.borrtype like 'lex' 
						group by play_dmg,lemma)q1 
		group by q1.lemma_dmg 
			order by count(q1.play_dmg) desc,sum(q1.vorkommen) desc;



--- q8 (Varianten, Types pro Lemmata): 
select distinct author,play,lemma,lemma_dmg,group_concat(distinct token),count(token) as vorkommen 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' 
			group by play,lemma having count(distinct token)>1 
				order by author,play,lemma_dmg;



--- q9 (Phrasen und Interjektionen): 
select group_concat(distinct pos separator ', ') as wortart,count(pos) 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' 
			group by (pos='locution' or pos='interj') 
				order by count(pos) desc;



--- q10 (Phrasen nach Stücken und Sprachen): 
select q.play,q.author,q.lemma_dmg,group_concat(personTokens separator ', ') as personsAndTokens,q.etymon,q.language,q.pos 
	from (
			select t.author,t.play,t.idlem,concat(p.name_dmg,' (',count(t.token),')') as personTokens,count(t.token) as countToken,l.lemma_dmg,l.etymon,l.language,l.pos 
				from lemmata l right join tokens t on (l.id=t.idlem) left join persons p on (t.play=p.play and t.speaker=p.name) 
					where pos in ('locution','interj') and t.borrtype like 'lex' 
						group by author,play,name_dmg,idlem 
							order by t.author,t.play,count(t.token) desc,l.lemma_dmg)q 
		group by q.author,q.play,q.idlem 
			order by author,play,language,sum(q.countToken) desc;



--- q11 (Phrasen und Interjektionen, Textstellen): 
select token,lemma_dmg,pos,context,speaker,play,concat(act,',',page),t.id as idtok 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' and (pos='locution' or pos='interj') 
			order by author,play,act,page,t.id;



--- q12 (Entlehnungscluster, Tokens pro Seite): 
select t.author,t.play,tokpage,count(t.token) as countToken 
	from lemmata l right join tokens t on (l.id=t.idlem) 
		where language like '%F%' and t.borrtype like 'lex' 
			group by author,play,tokpage 
				order by t.author,t.play,abs(tokpage);



--- q13 (ausgewählte Entlehnungscluster, Tokens): 
select concat(tokpage,': ',group_concat(token order by t.id)) 
	from lemmata l right join tokens t on (l.id=t.idlem) join plays pl on (t.play=pl.play)
		where language like '%X%' and t.borrtype like 'lex' and pl.play_dmg like 'Y' and tokpage between Z1 and Z2 
			group by tokpage 
				order by tokpage;
---- Mit X=Sprache (F oder I), Y=Theaterstück (in Transliteration), Z1=VonSeitenzahl, Z2=BisSeitenzahl



--- q14 (Wortarten Stücke gesamt):
select count(distinct t.idlem),l.pos 
	from tokens t join lemmata l on (t.idlem=l.id) 
		where l.language like '%F%' and t.borrtype like 'lex' 
			group by pos 
				order by count(distinct t.idlem) desc;



--- q15 (lexikalische Entlehnungen mit Textstellen): 
select distinct tok.id as idtok,q.idlem as idlem,q.author,q.play,q.lemma,q.lemma_dmg,q.tokenConcat,q.vorkommen,tok.token,tok.context,tok.speaker,tok.page,tok.act,tok.comment as tokComment,q.comment as lemComment 
	from (
		select distinct author,play,l.id as idlem,lemma,lemma_dmg,group_concat(distinct token separator ', ') as tokenConcat,count(token) as vorkommen,l.comment 
			from tokens t join lemmata l on (t.idlem=l.id) 
				where l.language like '%F%' and t.borrtype like 'lex' 
					group by play,lemma)q 
		join tokens tok on (q.idlem=tok.idlem and q.play=tok.play) 
			order by author,play,vorkommen desc,idlem,abs(page),tok.id;



--- q16 (lexikalische Entlehnungen nach Figuren mit Textstellen): 
select q2.author,q2.play,q2.name_dmg,q2.role,q2.profession,q1.countDistinctIdlem,q1.countToken,q3.countTokensByPersonLemma,q3.lemma_dmg,q3.concatTokens,q3.concatContexts 
	from (
		select distinct t.play,t.speaker,count(distinct t.idlem) as countDistinctIdlem,count(t.token) as countToken 
			from lemmata l join tokens t on (l.id=t.idlem) 
				where (l.language like '%F%' and t.borrtype like 'lex') 
					group by t.play,t.speaker)q1 
		right join (
		select pl.author,p.play,p.name,p.name_dmg,p.role,p.profession 
			from persons p join plays pl on (p.play=pl.play))q2 
		on (q1.speaker=q2.name and q1.play=q2.play) 
		join (
		select distinct l.lemma,l.lemma_dmg,group_concat(distinct t.token separator ', ') as concatTokens,group_concat(distinct t.act,',',t.page,': ',t.context order by t.act,t.page separator ', ') as concatContexts,count(token) as countTokensByPersonLemma,t.play,t.speaker 
			from tokens t join lemmata l on (t.idlem=l.id) 
				where l.language like '%F%' and t.borrtype like 'lex' 
					group by play,speaker,lemma)q3 
		on (q1.play=q3.play and q1.speaker=q3.speaker) 
			order by author,play,countDistinctIdlem desc,countToken desc,name_dmg,countTokensByPersonLemma desc,lemma_dmg;



--- q17 (lexikalische Entlehnungen nach Entlehnungskategorien):
select distinct l.id,l.lemma,l.lemma_dmg,l.etymon,l.language,pos,l.lexcat 
	from lemmata l join tokens t on (l.id=t.idlem) 
		where language like '%F%' and t.borrtype='lex' 
			order by lexcat,lemma_dmg;





--------------------------
-- Abfragen: Wörterbuch --
--------------------------

--- q18 (Entlehnungen alphabetisch):
select lemma,translit_dmg,pos,replace(replace(replace(replace(replace(ety_lang,'.',''),'It','I'),'from','<'),' and',','),' or',',') as language,ety_word_completed as etymon,group_concat(meaning_german 
				order by id_poly separator '; ') as meaning 
	from dict_spiro 
		where category not in ("expression","compound","example") and ety_lang like '%F\\.%' 
			group by id_lem 
				order by translit_dmg;



--- q19 (Wortarten): 
select pos,count(pos) 
	from dict_spiro 
		where category not in ("expression","compound","example") and ety_lang like '%F\\.%' 
			group by pos 
				order by count(pos) desc;

