package eu.ascens.validation

import eu.ascens.helenaText.HelenaTextPackage
import eu.ascens.helenaText.RoleTypeWithMultiplicity
import org.eclipse.xtext.validation.AbstractDeclarativeValidator
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.EValidatorRegistrar

class EnsembleStructureValidator extends AbstractDeclarativeValidator {

	override register(EValidatorRegistrar registrar) {
       //not needed for classes used as ComposedCheck
    }

	/**
	 * Checks for a multiplicity in an ensemble structure 
	 * if the first number in a range is smaller than the second
	 */
	@Check
	def check_ensembleStructure_multiplicity_firstRangeValSmallerThanSecond(RoleTypeWithMultiplicity rtMult) {
		var min = 0;
		var max = 0;
		
		try {
			min = Integer.parseInt(rtMult.min);
		}
		catch(NumberFormatException e){
			try {
				Integer.parseInt(rtMult.max);
				error(
					'First value in the range has to be smaller than the second one.',
					HelenaTextPackage.Literals.ROLE_TYPE_WITH_MULTIPLICITY__MAX,
					HelenaTextValidator.MULT_RANGE_WRONG
				)
			}
			catch(NumberFormatException e2){
				//no error, since min and max are * which is always ok	
			}
		}
		
		try {
			max = Integer.parseInt(rtMult.max);
			if(min > max){
				error(
					'First value in the range has to be smaller than the second one.',
					HelenaTextPackage.Literals.ROLE_TYPE_WITH_MULTIPLICITY__MAX,
					HelenaTextValidator.MULT_RANGE_WRONG
				)				}
			
		}
		catch(NumberFormatException e){
			//no error, because max is * which is always ok			
		}
	}
}