package eu.ascens.helenaText.util

import eu.ascens.helenaText.FormalDataParamsBlock
import eu.ascens.helenaText.FormalRoleParamsBlock
import eu.ascens.helenaText.Model

class ExtensionMethods_Model {
	
	/**
	 * Returns the maximal number of role params in any message in the model
	 */
	def static int maxNumberOfRoleParamsInModel(Model model) {
		return maxNumberOfAbstractParamsInModel(model, FormalRoleParamsBlock);
	}
	
	/**
	 * Returns the maximal number of data params in any message in the model
	 */
	def static int maxNumberOfDataParamsInModel(Model model) {
		return maxNumberOfAbstractParamsInModel(model, FormalDataParamsBlock);
	}
	
	private def static int maxNumberOfAbstractParamsInModel(Model model, Class<?> clazz) {
		//we need the max number to be at least 1 because arrays with size 0 cannot be initialized in Promela		
		var int maxNumber = 1;
		for (rt : model.headPkg.roleTypes) {
			for (msg : rt.rolemsgs) {
				var currentNumber = 0;
				switch clazz {
					case FormalRoleParamsBlock : currentNumber = msg.formalRoleParamsBlock.params.size
					case FormalDataParamsBlock : currentNumber = msg.formalDataParamsBlock.params.size
				}
				if (currentNumber > maxNumber) {
					maxNumber = currentNumber;
				}
			}
		}
		return maxNumber;
	}
}