package eu.ascens.helenaText.util

import eu.ascens.helenaText.DataExpression
import org.eclipse.xtext.common.types.JvmType

import static eu.ascens.helenaText.util.JvmTypesHelper.*

import static extension eu.ascens.helenaText.util.ExtensionMethods_Param.*

class ExtensionMethods_JvmType {
	
	def static boolean isBool(DataExpression expression) {
		var type = expression.wrappedJvmType.simpleName;
		return type == 'Boolean';
	}
	
	def static isNumber(DataExpression expression){
		var type = expression.wrappedJvmType.simpleName;
		return type == 'Integer' || type == 'Double'
	}
	
	
	def static boolean isBoolean(JvmType jvmType){
		return getWrappedTypeAsString(jvmType.simpleName) == 'Boolean';
	}
	def static boolean isNumber(JvmType jvmType){
		var typeAsString = getWrappedTypeAsString(jvmType.simpleName);
		return typeAsString == "Integer" || typeAsString == "Double"  
	}
	
	def static boolean isVoid(JvmType jvmType) {
		return getWrappedTypeAsString(jvmType.simpleName) == 'Void';
	}
	
	def static boolean isOfPromelaType(JvmType type) {
		var simpleType = getWrappedTypeAsString(type.simpleName);
		return simpleType == 'Byte' || simpleType == 'Short' || 
			simpleType == 'Integer' || simpleType == 'Boolean';
	}
	
	def static boolean isInt(JvmType type) {
		return getWrappedTypeAsString(type.simpleName) == "Integer";
	}
}