package eu.ascens.helenaText.util

import eu.ascens.helenaText.EnsembleStructure
import eu.ascens.helenaText.RoleType

class ExtensionMethods_EnsembleStructure {
	
	
	/**
	 * Calculates the multiplicity from an ensemble structure for a role type as 
	 * value (if only one value was set) or the maximum from the range
	 * If maximum is "*" Integer.MAX_VALUE is returned 
	 * @return maximum multiplicity for a role type
	 */
	def static String getMaxMultiplicityForRoleType(EnsembleStructure es, RoleType rt) {
		for (rtWithMult : es.rtWithMult){
			if (rtWithMult.roleType == rt) {
				return rtWithMult.max.calculateMultiplicityJava;
			}
		}
		
		return null;
	}
	
	/**
	 * @return capacity for a role type
	 */
	def static Integer getCapacityForRoleType(EnsembleStructure es, RoleType rt) {
		for (rtWithMult : es.rtWithMult){
			if (rtWithMult.roleType == rt) {
				return rtWithMult.capacity;
			}
		}
		
		return null;
	}
	
	private def static String calculateMultiplicityJava(String multiplicity){
		if (multiplicity == "*" ){
			return "Integer.MAX_VALUE"
		}
		else {
			return multiplicity;
		}
	}
	
	public def static String calculateMultiplicityPromela(String multiplicity){
		if (multiplicity == "*" ){
			return "(2^31)-1"
		}
		else {
			return multiplicity;
		}
	}
}