package eu.ascens.generator.promela;

import com.google.inject.Inject
import org.eclipse.xtext.xbase.XExpression
import org.eclipse.xtext.xbase.compiler.ImportManager
import org.eclipse.xtext.xbase.compiler.XbaseCompiler
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable

class TypesGenerator {
	@Inject XbaseCompiler xbase;
	
	public def getValueFromXExpression(XExpression expr){
		var ImportManager im = new ImportManager(true);
		val result = new FakeTreeAppendable(im);
		try{
			xbase.toJavaExpression(expr, result);
		}catch(NullPointerException e){
			System.err.println("Error in getValueFromXExpression")
			return "error"
		}
		return result.toString;
	}
}