package eu.ascens.generator.promela

import com.google.inject.Inject
import eu.ascens.generator.HelenaTextOutputConfigurationProvider
import eu.ascens.helenaText.Model
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.IFileSystemAccess
import org.eclipse.xtext.generator.IGenerator

import static extension eu.ascens.generator.promela.ComponentTypeGenerator.*
import static extension eu.ascens.generator.promela.MessageTypeGenerator.*
import static extension eu.ascens.generator.promela.NameGenerator.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_EnsembleStructure.*

/**
 * Generates the Promela code from a HelenaText file on save.
 * 
 */
class PromelaGenerator implements IGenerator {
	override void doGenerate(Resource resource, IFileSystemAccess fsa) {
		var Model model = resource.allContents.filter(Model).head;
		fsa.generateFile(
				model.headPkg.name + ".pml",
				HelenaTextOutputConfigurationProvider::PROMELA_GEN_OUTPUT,
				compile(model)
		)
	}
	
	/**
	 * Compiles the whole model
	 */
	@Inject RoleTypeGenerator rtGenerator;
	def compile(Model model) {
		'''
««« multiplicities for role types (caution: we assume just one ensemble structure)
		«model.compileMultiplicities»
		
««« operations for component types
		«FOR ct: model.headPkg.compTypes»
		«ct.compileOperations(model.headPkg.ensStructs.head)»
		«ENDFOR»
		
««« helpers for communication between roles and components
		«FOR ct: model.headPkg.compTypes SEPARATOR '\n'»
		«ct.compileOperationCallHelpers»
		«ENDFOR»

««« messages for role types
		«model.compileMsgs» 

««« helpers for communication between roles
		«model.compileMsgCallHelpers»
		
««« processes for component types
		«FOR ct: model.headPkg.compTypes SEPARATOR '\n'»
		«ct.compileProctype(model.headPkg.ensStructs.head, model)»
		«ENDFOR»

««« processes for role behaviors
		«FOR rt: model.headPkg.roleTypes SEPARATOR '\n'»
		«rtGenerator.compileProctype(rt, model)»
		«ENDFOR»
		'''
	}
	
	def static compileMultiplicities(Model model) {
		'''
		///////////// ensemble structure multiplicities //////////////////////
		«FOR rtWithMult:model.headPkg.ensStructs.head.rtWithMult SEPARATOR '\n'»
		int «rtWithMult.roleType.minName» = «rtWithMult.min.calculateMultiplicityPromela»;
		int «rtWithMult.roleType.maxName» = «rtWithMult.max.calculateMultiplicityPromela»;
		int «rtWithMult.roleType.currentName» = 0;
		«ENDFOR»
		'''
	}

}
