package eu.ascens.generator.promela

import eu.ascens.helenaText.Model

import static extension eu.ascens.generator.promela.NameGenerator.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_Model.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_RoleType.*

class MessageTypeGenerator {
	
	/**
	 * Compiles a user defined type declaration for every message which can be sent in the model
	 */
	def static compileMsgs(Model model) {
		'''
		///////////// message definitions //////////////////////
		mtype {
			setOffInitialRole, 
			«FOR msg: model.allMessagesInModel SEPARATOR ', '»
				«msg.msgName»
			«ENDFOR»
		}
		'''
	}
	
	/**
	 * Compiles helpers to send messages between roles
	 */
	def static compileMsgCallHelpers(Model model) {
		'''
		//////// helper for setting up initial state /////////
		inline send_setOffInitialRole(receiver) {
			receiver!setOffInitialRole«
				»«FOR i : 0 ..< model.maxNumberOfRoleParamsInModel BEFORE ',' SEPARATOR ','»1«ENDFOR»«
				»«FOR i : 0 ..< model.maxNumberOfDataParamsInModel BEFORE ',' SEPARATOR ','»1«ENDFOR»;
		}
		
		inline receive_setOffInitialRole() {
			self?setOffInitialRole«
				»«FOR i : 0 ..< model.maxNumberOfRoleParamsInModel BEFORE ',' SEPARATOR ','»1«ENDFOR»«
				»«FOR i : 0 ..< model.maxNumberOfDataParamsInModel BEFORE ',' SEPARATOR ','»1«ENDFOR»;
		}
		
		//////// helper for communication between roles /////////
		«FOR msg:model.allMessagesInModel SEPARATOR '\n'»
		«var roleparams = msg.formalRoleParamsBlock.params»
		«var dataparams = msg.formalDataParamsBlock.params»
		inline «msg.sndMsgHelperName»(receiver«FOR param:roleparams BEFORE ',' SEPARATOR ','»«param.variableName»«ENDFOR»«FOR param:dataparams BEFORE ',' SEPARATOR ','»«param.varName»«ENDFOR») {
			receiver!«msg.msgName»«
				»«FOR i : 0 ..< model.maxNumberOfRoleParamsInModel BEFORE ',' SEPARATOR ','»«
					»«IF i < roleparams.size»«roleparams.get(i).variableName»«ELSE»1«ENDIF»«
				»«ENDFOR»«
				»«FOR i : 0 ..< model.maxNumberOfDataParamsInModel BEFORE ',' SEPARATOR ','»«
					»«IF i < dataparams.size»«dataparams.get(i).varName»«ELSE»1«ENDIF»«
				»«ENDFOR»;
		}
		
		inline «msg.rcvMsgHelperName»(«FOR param:roleparams SEPARATOR ','»«param.variableName»«ENDFOR»«IF !roleparams.empty && !dataparams.empty»,«ENDIF»«FOR param:dataparams SEPARATOR ','»«param.varName»«ENDFOR») {
			self?«msg.msgName»«
				»«FOR i : 0 ..< model.maxNumberOfRoleParamsInModel BEFORE ',' SEPARATOR ','»«
					»«IF i < roleparams.size»«roleparams.get(i).variableName»«ELSE»1«ENDIF»«
				»«ENDFOR»«
				»«FOR i : 0 ..< model.maxNumberOfDataParamsInModel BEFORE ',' SEPARATOR ','»«
					»«IF i < dataparams.size»«dataparams.get(i).varName»«ELSE»1«ENDIF»«
				»«ENDFOR»;
		}
		«ENDFOR»
		'''
	}
}