package eu.ascens.generator.jHelena

import eu.ascens.helenaText.AbstractInstance
import eu.ascens.helenaText.MessageType
import java.util.ArrayList
import java.util.List
import org.eclipse.xtext.xbase.compiler.ImportManager
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer

import static extension eu.ascens.generator.jHelena.ExtensionMethods_jHelenaGenerator.*
import static extension eu.ascens.helenaText.util.ExtensionMethods.*

class MessageTypeGenerator extends AbstractHelenaTextGenerator {
	
	protected new(TypeReferenceSerializer serializer, ImportManager im, GeneratorHelper genHelper) {
		super(serializer, im, genHelper)
	}
	
	
	
	def String compile(MessageType it){
	'''
	
	«««package
	package «packageName»;
    
    «««imports
	«ImportGenerator.compileImports(it, im)»
	
	«««body	
	«val className = it.classname»
	public class «className» extends Message{
		
		«var roleParams = it.formalRoleParamsBlock.params.filterNull.toList»
		«var dataParams = it.formalDataParamsBlock.params.filterNull.toList»
		
		«var List<AbstractInstance> allParams = new ArrayList<AbstractInstance>(roleParams)»
		«var added = allParams.addAll(dataParams)»
		
		«««Constructor, params: first role params, then data params
		public «className»(«FOR p: allParams SEPARATOR ","»Variable<«genHelper.getWrappedTypeAsString(p)»> «p.instName»«ENDFOR»){
			super(
				«IF roleParams.size > 0»
				Auxiliaries.getAsList(
					«FOR p:roleParams SEPARATOR ', '»
					«p.instName»
		    		«ENDFOR»
	    		)
	    		«ELSE»
	    		new ArrayList<Variable<Role>>()
	    		«ENDIF»
	    		,
				«IF dataParams.size > 0»
				Auxiliaries.getAsList(
					«FOR p:dataParams SEPARATOR ', '»
					«p.instName»
		    		«ENDFOR»
	    		)
	    		«ELSE»
	    		new ArrayList<Variable<Object>>()
	    		«ENDIF»
    		);
		}
	}
	'''
	}
	
}