package eu.ascens.generator.jHelena

import eu.ascens.helenaText.EnsembleStructure
import org.eclipse.xtext.xbase.compiler.ImportManager
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer

import static extension eu.ascens.generator.jHelena.ExtensionMethods_jHelenaGenerator.*

class EnsembleStructureGenerator extends AbstractHelenaTextGenerator {
	
	protected new (TypeReferenceSerializer serializer, ImportManager im, GeneratorHelper genHelper){
		super(serializer, im, genHelper);
	}
	
	def String compile(EnsembleStructure it){
	'''
	
	«««package    
	package «packageName»;
    
    «««imports
	«ImportGenerator.compileImports(it, im)»
	
	«««body	
	public abstract class «classname» extends Ensemble {

		public «classname»(String ensembleID, Set<Component> comps) {
			super(ensembleID, comps);
		}
	
		public abstract void startEnsemble(Component initialComponent) 
			throws RoleTypeNotAllowedForEnsembleException,
	        RoleTypeNotAllowedForComponentTypeException,
	        ComponentNotInEnsembleException, 
	        ComponentAlreadyAdoptsRoleException, 
	        TooManyRoleInstancesException,
	        ReflectionException, PropertyNotDeclaredInClassException;

	}

	
	'''
	} 
	
	def String compileImpl(EnsembleStructure it){
	'''
	«««package    
	package «packageName»;

	 «««imports
	«ImportGenerator.compileImplImports(it, im)»
	
	
	public class «implClassname» extends «classname» {

		public «implClassname»(String ensembleID, Set<Component> comps) {
			super(ensembleID, comps);
		}

	@Override
	public void startEnsemble(Component initialComponent)
			throws RoleTypeNotAllowedForEnsembleException,
	        RoleTypeNotAllowedForComponentTypeException,
	        ComponentNotInEnsembleException, 
	        ComponentAlreadyAdoptsRoleException,
	        TooManyRoleInstancesException,
	        ReflectionException, PropertyNotDeclaredInClassException {
			//«METHOD_HAS_TO_BE_IMPLEMENTED_BY_USER»
			throw new UnsupportedOperationException("«METHOD_NOT_IMPLEMENTED»: «USER_INPUT_REQUIRED»");
		}
	}
	
	'''
	}

}