package eu.ascens.ui.outline;

import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.actions.SortOutlineContribution.DefaultComparator;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

import eu.ascens.helenaText.HelenaTextPackage;

public class HelenaTextOutlineNodeComparator extends DefaultComparator {

	/**
	 * Method for sorting the Helena elements in the Outline according to
	 * categories (instead of alphabetically) First all componentTypes are
	 * shown. Afterwards follow the roleTypes, roleConnectorTypes,
	 * ensembleStructures, roleBehaviors
	 */
	@Override
	public int getCategory(IOutlineNode node) {
		int classID = ((EObjectNode) node).getEClass().getClassifierID();
		if (node instanceof EObjectNode) {
			switch (classID) {
			case HelenaTextPackage.ROLE_BEHAVIOR:
				return -10;
			case HelenaTextPackage.ENSEMBLE_STRUCTURE:
				return -20;
				// case HelenaTextPackage.ROLE_CONNECTOR_TYPE:
				// return -30;
			case HelenaTextPackage.ROLE_TYPE:
				return -40;
			case HelenaTextPackage.COMPONENT_TYPE:
				return -50;
			}
		}
		return Integer.MIN_VALUE;
	}
}
