/*
* generated by Xtext
*/
package eu.ascens.ui.labeling

import com.google.inject.Inject
import eu.ascens.helenaText.AbstractAssignment
import eu.ascens.helenaText.MessageType
import eu.ascens.helenaText.RoleBehavior
import eu.ascens.helenaText.RoleTypeWithMultiplicity
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
class HelenaTextLabelProvider extends XbaseLabelProvider {

	@Inject
	new(AdapterFactoryLabelProvider delegate) {
		super(delegate);
	}

	// Adapt Labels:
	def text(AbstractAssignment a) {
		return a.roleTypeRef.name;
	}	
	
	def text(RoleTypeWithMultiplicity rtWithMult){
		'<'+ rtWithMult.roleType.name +','+ text(rtWithMult.min)+','+ text(rtWithMult.max)+','+ text(rtWithMult.capacity)+'>'
	}
	
	def text(RoleBehavior rb){
		return rb.roleTypeRef.name + " (role behavior)";
	}
	def text(MessageType msgType){
		return msgType.direction + " "+ msgType.name; 
	}

	//Adapts the Icons for the Helena Elements	
//	def image(ComponentType ct) {
//		'yellow2.png'
//	}
//
//	def image(RoleBehavior ele) {
//		'lightBlue2.png'
//	}
//	def image(RoleType rt) {
//		'pink2.png'
//	}
//	def image(EnsembleStructure es) {
//		'orange2.png'
//	}
//	def image(RoleConnectorType rct){
//		'green2.png'
//	}
}
