package eu.ascens.helena.metadata;

import eu.ascens.helena.dev.exceptions.ConfigurationFinishedException;
import eu.ascens.helena.dev.exceptions.TypeAlreadyExistsException;
import eu.ascens.helena.dev.exceptions.TypeDoesNotExistException;

/**
 * This class represents field types of data in Helena
 * 
 * @author Annabelle Klarl
 */
public class DataFieldType extends AbstractFieldType<Object> {

	/**
	 * This method creates a field type for data for the given name and type.
	 * 
	 * If there is none for the name and type, a new one is created. If there
	 * exists already one, an {@link TypeAlreadyExistsException} is thrown.
	 * 
	 * @param name the name of the field type
	 * @param type the type of the field type
	 * @return
	 * @throws ConfigurationFinishedException This exception is thrown if this
	 *             method was called after the configuration of the
	 *             ensemble-based system was finished.
	 * @throws TypeAlreadyExistsException This exception is thrown if a type
	 *             with the same name already exists.
	 */
	public static DataFieldType createType(String name, Class<?> type)
	        throws ConfigurationFinishedException, TypeAlreadyExistsException {

		DataFieldType newDataFieldType = new DataFieldType(name, type);
		AbstractFieldType.checkAndAddType(newDataFieldType);
		return newDataFieldType;
	}

	/**
	 * This method retrieves a field type for data for the given name.
	 * 
	 * @return
	 * @throws TypeDoesNotExistException This exception is thrown if there
	 *             exists not type for the given class.
	 */
	public static DataFieldType getType(String name)
	        throws TypeDoesNotExistException {
		return AbstractFieldType.getType(name, DataFieldType.class);
	}

	// //////// Data Field Type Declaration //////////////////////

	private DataFieldType(String name, Class<? extends Object> type) {
		super(name, type);
	}
}
