package eu.ascens.helena.metadata;

/**
 * This class controls configuration of all Helena entities.
 *
 * @author Annabelle Klarl
 */
public final class ConfigurationManager {

	private static boolean configurationDone = false;

	/**
	 * This method finishes the configuration of all types of the Helena
	 * specification.
	 */
	public static void configurationDone() {
		configurationDone = true;
	}

	/**
	 * This method returns whether configuration of the Helena specification has
	 * already been finished such that no more new types can be added.
	 *
	 * @return
	 */
	static boolean isConfigurationDone() {
		return configurationDone;
	}

}
