package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown if a type (ensemble, role, component, method,
 * operation, ...) should have been retrieved, but there does not exist one of
 * the given type.
 *
 * @author Annabelle Klarl
 */
public class TypeDoesNotExistException extends RuntimeException {

	private static final long serialVersionUID = -6776521451703410315L;
	private String name;

	public TypeDoesNotExistException(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return "Type " + this.name
				+ " could not be retrieved, since it does not exist.";
	}
}
