package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.metadata.ComponentType;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if an instance of a role type should have been
 * created on a component whose type is not allowed to adopt the given role
 * type.
 * 
 * @author Annabelle Klarl
 *
 */
public class RoleTypeNotAllowedForComponentTypeException extends Exception {

	private static final long serialVersionUID = 6800296910573061612L;
	private RoleType roleType;
	private ComponentType componentType;

	public RoleTypeNotAllowedForComponentTypeException(RoleType roleType,
	        ComponentType componentType) {
		this.roleType = roleType;
		this.componentType = componentType;
	}

	@Override
	public String toString() {
		return "Role type " + this.roleType + " not allowed for component type "
		        + this.componentType;
	}
}
