package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Component;
import eu.ascens.helena.dev.Ensemble;
import eu.ascens.helena.dev.Role;

/**
 * This exception is thrown if a role instance should be retrieved from a
 * certain owner in a certain ensemble, but there is currently no such instance.
 *
 * @author Annabelle Klarl
 */
public class NoRoleInstancesException extends Exception {

	private static final long serialVersionUID = -7102116381526067973L;

	private Class<? extends Role> roleType;
	private Component owner;
	private Ensemble ensemble;

	public NoRoleInstancesException(Class<? extends Role> roleType,
			Component owner, Ensemble ensemble) {
		this.roleType = roleType;
		this.owner = owner;
		this.ensemble = ensemble;
	}

	@Override
	public String toString() {
		return "No role instances of type " + this.roleType + " on the owner "
				+ this.owner.getType() + " and ensemble "
				+ this.ensemble.getType() + " available.";
	}
}
