package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Expression;

/**
 * This exception is thrown if a guard did not return a boolean value.
 * 
 * @author Annabelle Klarl
 */
public class NoBooleanValueException extends Exception {

	private static final long serialVersionUID = -7110834605755285699L;
	private Expression expression;

	public NoBooleanValueException(Expression expression) {
		this.expression = expression;
	}

	@Override
	public String toString() {
		return "An expression used as a guard was not boolean.";
	}
}
