package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.metadata.MessageType;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if a message is exchanged between two roles which
 * are not in the same ensemble.
 *
 * @author Annabelle Klarl
 */
public class MessageNotAllowedBetweenRolesException extends Exception {

	private static final long serialVersionUID = -7871473539092745541L;
	private MessageType msgType;
	private RoleType roleTypeOut;
	private RoleType roleTypeIn;

	public MessageNotAllowedBetweenRolesException(MessageType msgType,
	        RoleType roleTypeOut, RoleType roleTypeIn) {
		this.msgType = msgType;
		this.roleTypeOut = roleTypeOut;
		this.roleTypeIn = roleTypeIn;
	}

	@Override
	public String toString() {
		return this.msgType.getSimpleName() + " not allowed between "
		        + this.roleTypeOut.getSimpleName() + " and "
		        + this.roleTypeIn.getSimpleName()
		        + " since the roles are not in the same ensemble.";
	}
}
