package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Guard;
import eu.ascens.helena.dev.Role;

public class GuardNeverEvaluableException extends Exception {

	private static final long serialVersionUID = 7575081975203880533L;

	private Guard guard;
	private Role role;
	private Exception cause;

	public GuardNeverEvaluableException(Guard guard, Role source,
			Exception cause) {
		this.guard = guard;
		this.role = source;
		this.cause = cause;
	}

	@Override
	public String toString() {
		return "The exception " + this.getClass().getSimpleName()
				+ " occurred during evaluating a guard for "
				+ this.role.getType() + ". Cause: " + this.cause;
	}

}
