package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Component;
import eu.ascens.helena.dev.Ensemble;

/**
 * This exception is thrown if a role instance should be created on a component
 * which does not contribute to the ensemble.
 * 
 * @author Annabelle Klarl
 *
 */
public class ComponentNotInEnsembleException extends Exception {

	private static final long serialVersionUID = 2001596215079935895L;
	private final Component component;
	private final Ensemble ens;

	public ComponentNotInEnsembleException(Component component, Ensemble ens) {
		this.component = component;
		this.ens = ens;
	}

	@Override
	public String toString() {
		return "The component of type " + this.component.getType()
		        + " was not part of the ensemble of type " + this.ens.getType();
	}

}
