package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Action;
import eu.ascens.helena.dev.Role;

/**
 * This class represents the all exceptions which are caused by an action which
 * is syntactically allowed (fulfills Helena process term grammar and is
 * well-formed), but will never become executable.
 *
 * @author Annabelle Klarl
 */
public class ActionNeverExecutableException extends HelenaRuntimeException {

	private static final long serialVersionUID = -1871918776539431125L;

	public ActionNeverExecutableException(Action action, Role role,
			Exception cause) {
		super(action, role, cause);
	}
}
