package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Action;
import eu.ascens.helena.dev.Role;

/**
 * This class represents all exceptions which are caused by an action which is
 * syntactically allowed (fulfills Helena process term grammar and is
 * well-formed), but is currently not executable. This action might become
 * executable again at a later point in the execution.
 *
 * @author Annabelle Klarl
 */
public class ActionCurrentlyNotExecutableException
		extends HelenaRuntimeException {

	private static final long serialVersionUID = 6011599886418487621L;

	public ActionCurrentlyNotExecutableException(Action action, Role role,
			Exception cause) {
		super(action, role, cause);
	}
}
