package eu.ascens.helena.dev;

/**
 * This class models synchronous message exchange.
 *
 * @author Annabelle Klarl
 */
class SynchronousInputChannel extends RoleInputChannel {

	private Message queuedMsg;

	@Override
	protected int getFreeMessageSpots() {
		return (this.queuedMsg == null) ? 1 : 0;
	}

	@Override
	protected void writeToChannel(Message msg) {
		this.queuedMsg = msg;
	}

	@Override
	protected Message peekAtChannel() {
		return this.queuedMsg;
	}

	@Override
	protected Message takeFromChannel() throws InterruptedException {
		Message result = this.queuedMsg;
		this.queuedMsg = null;
		this.notifyAll();
		return result;
	}

	@Override
	protected void waitUntilMessageWasWritten(Message msg)
			throws InterruptedException {
		// synchronous message passing: waiting until message is received
		while (this.queuedMsg != null) {
			try {
				this.wait();
			}
			catch (InterruptedException e) {
				Thread.currentThread().interrupt();
				throw new InterruptedException("Sending the message "
						+ msg.getClass().getSimpleName()
						+ " via synchronous message passing was interrupted.");
			}
		}
	}

}