package eu.ascens.helena.dev;

import java.util.Set;

import eu.ascens.helena.dev.exceptions.ComponentIsNullException;
import eu.ascens.helena.dev.exceptions.ComponentNotInEnsembleException;

/**
 * This class represent a plays query.
 *
 * @author Annabelle Klarl
 */
public class PlaysQuery extends Guard {

	private final Component component;
	private final Class<? extends Role> roleType;

	public PlaysQuery(Component component, Class<? extends Role> roleType) {
		this.component = component;
		this.roleType = roleType;
	}

	@Override
	Set<Component> lockObjects(Role source) {
		return Auxiliaries.getAsSet(this.component);
	}

	/**
	 * This method evaluates whether the component currently plays the role type
	 * in the enclosing ensemble of the given role.
	 *
	 * @param source the role for which the guard should be evaluated
	 * @return
	 */
	@Override
	boolean isTrue(Role source) {
		try {
			return source.getEnsemble().playsRole(this.roleType,
					this.component);
		}
		catch (ComponentIsNullException | ComponentNotInEnsembleException e) {
			return false;
		}
	}
}
