package eu.ascens.helena.dev;

import eu.ascens.helena.dev.exceptions.NoBooleanValueException;
import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;

/**
 * This class represents abstract expressions which can serve as guards.
 *
 * @author Annabelle Klarl
 */
public abstract class Expression extends Guard {

	@Override
	boolean isTrue(Role source) throws PropertyNotDeclaredInClassException,
			ReflectionException, NoBooleanValueException {
		Object value = this.getValue(source);

		if (!(value instanceof Boolean)) {
			throw new NoBooleanValueException(this);
		}

		return (Boolean) value;
	}

	abstract Object getValue(Role source)
			throws PropertyNotDeclaredInClassException, ReflectionException;

}
