package eu.ascens.helena.dev;

import java.util.logging.Logger;

import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;
import eu.ascens.helena.metadata.ComponentAssociationType;
import eu.ascens.helena.metadata.ComponentType;

/**
 * This class represents a getter for a component association of a component.
 *
 * @author Annabelle Klarl
 */
public class CompAssociationGetter {

	protected final Logger log = Logger
			.getLogger("eu.ascens.helena.CompAssocGetterLogger");

	private final String assocName;

	public CompAssociationGetter(String assocName) {
		this.assocName = assocName;
	}

	/**
	 * This method evaluates the value of the component association of the owner
	 * of the source role.
	 *
	 * @param source the role for which the component association of its owner
	 *            should be evaluated
	 * @return
	 * @throws PropertyNotDeclaredInClassException This exception is thrown if
	 *             the getter tries to retrieve an association which is not
	 *             declared in the owner.
	 * @throws ReflectionException This exception is thrown if the association
	 *             could not be retrieved via reflection.
	 */
	public Component getValue(Role source)
			throws PropertyNotDeclaredInClassException, ReflectionException {

		ComponentAssociationType assocType = ComponentAssociationType
				.getType(this.assocName);
		ComponentType compType = source.getOwner().getType();

		if (!compType.isAllowed(assocType)) {
			throw new PropertyNotDeclaredInClassException(this.assocName,
					source.getOwner().getClass());

		}

		Object value = source.getOwner().getCompAttr(this.assocName);

		this.log.fine("Role " + source.getType()
				+ " retrieved component association " + this.assocName);

		return (Component) value;
	}

}
