package eu.ascens.helena.dev;

import java.util.HashSet;
import java.util.Set;

/**
 * This class represent a basic atom (i.e. value) which can serve as an
 * expression or guard.
 *
 * @author Annabelle Klarl
 */
public class Atom extends Expression {

	private final Object value;

	public Atom(Object value) {
		this.value = value;
	}

	@Override
	Set<Component> lockObjects(Role source) {
		return new HashSet<>();
	}

	/**
	 * This method returns the value itself.
	 *
	 * @param source the role for which the atom should be evaluated
	 * @return
	 */
	@Override
	Object getValue(Role source) {
		return this.value;
	}

}
