package eu.ascens.validation

import eu.ascens.helenaText.HelenaTextPackage
import eu.ascens.helenaText.RoleBehavior
import eu.ascens.helenaText.RoleType
import org.eclipse.xtext.validation.AbstractDeclarativeValidator
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.EValidatorRegistrar

class RoleTypeValidator extends AbstractDeclarativeValidator {

	override register(EValidatorRegistrar registrar) {
       //not needed for classes used as ComposedCheck
    }

	/**
	 * Checks if a role behavior exists for every role type
	 */
	@Check
	def check_roleType_roleBehaviorExists(RoleType rt) {
		var Iterable<RoleBehavior> allRBs = rt.eResource.allContents.toIterable.filter(RoleBehavior);

		for (RoleBehavior rb : allRBs) {
			if (rb.roleTypeRef.name == rt.name) {
				return;
			}
		}

		error(
			'No role behavior exists for role type ' + rt.name,
			HelenaTextPackage.Literals.ABSTRACT_HELENA_ENTITY__NAME,
			HelenaTextValidator.MISSING_CONNECTION
		)
	}
}