package eu.ascens.generator.promela

import com.google.inject.Inject
import eu.ascens.helenaText.AndTerm
import eu.ascens.helenaText.ComponentType
import eu.ascens.helenaText.DataExpression
import eu.ascens.helenaText.EqualityTerm
import eu.ascens.helenaText.GuardInParentheses
import eu.ascens.helenaText.NotTerm
import eu.ascens.helenaText.OrTerm
import eu.ascens.helenaText.PlaysQuery

import static extension eu.ascens.generator.promela.NameGenerator.*
import static extension eu.ascens.generator.promela.OperationCallGenerator.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_Param.*
import eu.ascens.helenaText.Relation

class GuardGenerator {
	@Inject NameGenerator nameGenerator
	
	/**
	 * Compiles a guard composed of or terms
	 */
	def dispatch CharSequence compileRelation(OrTerm term) {
		'''«compileRelation(term.left)» || «compileRelation(term.right)»'''
	}
	
	/**
	 * Compiles a guard composed of and terms
	 */
	def dispatch CharSequence compileRelation(AndTerm term) {
		'''«compileRelation(term.left)» && «compileRelation(term.right)»'''
	}
	/**
	 * Compiles a guard composed of a equality term
	 */
	def dispatch CharSequence compileRelation(EqualityTerm term) {
		'''«compileRelation(term.left)» «term.operator» «compileRelation(term.right)»'''
	}
	
	/**
	 * Compiles a guard composed of a not term
	 */
	def dispatch CharSequence compileRelation(NotTerm term) {
		'''«IF term.not != null»!«ENDIF»«compileAtom(term.atom)»'''
	}
	
	/**
	 * Compiles single atoms in guard
	 * - expressions (formal data params, role attributes, component attributes, data values)
	 * - plays queries
	 * - relations
	 * - guard in parentheses
	 */
	private dispatch def CharSequence compileAtom(DataExpression term) {
		'''«nameGenerator.getDataValue(term)»'''
	}
	private dispatch def CharSequence compileAtom(PlaysQuery term) {
		'''«term.variableName»'''
	}
	private dispatch def CharSequence compileAtom(Relation term) {
		'''«nameGenerator.getDataValue(term.left)» «term.operator» «nameGenerator.getDataValue(term.right)»'''
	}
	private dispatch def CharSequence compileAtom(GuardInParentheses term) {
		'''(«term.guard.compileRelation»)'''
	}
	
	def static compileOperationCallForComponentAttributeQuery(PlaysQuery query, ComponentType owner) {
		'''«query.compInstance.componentType.compileOperationCall(query)»'''
	}
	
	
	
}