package eu.ascens.generator.jHelena

import eu.ascens.helenaText.OperationType
import org.eclipse.xtext.xbase.compiler.ImportManager
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer

import static extension eu.ascens.generator.jHelena.ExtensionMethods_jHelenaGenerator.*

class OperationTypeGenerator extends AbstractHelenaTextGenerator {
	
	protected new(TypeReferenceSerializer serializer, ImportManager im, GeneratorHelper genHelper) {
		super(serializer, im, genHelper)
	}
	
	def String compile(OperationType it){
	'''
	
	«««package
	package «packageName»;
    
    «««imports
	«ImportGenerator.compileImports(it, im)»
	
	«««body	
	public class «classname» extends Operation{
		
		«var allParams = it.formalDataParamsBlock.params.filterNull.toList»
		
		«««Constructor
		public «classname»(«FOR p: allParams SEPARATOR ","»Variable<«genHelper.getWrappedTypeAsString(p)»> «p.name»«ENDFOR») {
			«IF allParams.size > 0»
				super(toList(«FOR p:allParams SEPARATOR ", "»«p.name»«ENDFOR»));
			«ELSE»
				super(new ArrayList<Variable<? extends Object>>());
			«ENDIF»
		}
		
		«IF allParams.size > 0»
		private static List<Variable<?>> toList(Variable<?>... objects) {
			return Arrays.asList(objects);
		}
		«ENDIF»
	}
	'''
	}
	
}