package eu.ascens.formatting;

import java.io.File;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.FileHandleImpl;
import org.eclipse.xpand2.output.JavaBeautifier;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtext.generator.IFilePostProcessor;

import com.google.inject.Inject;

public class JavaFormatterPostProcessor implements IFilePostProcessor{

	@Inject
	JavaBeautifier beautifier;
	
	public CharSequence postProcess(URI fileURI, CharSequence content) {
		
		if ("java".equalsIgnoreCase(fileURI.fileExtension())) {
			FileHandle handle = new FileHandleImpl(new Outlet(), new File(fileURI.toPlatformString(true)));
			handle.setBuffer(content);
			beautifier.beforeWriteAndClose(handle);
			
			return handle.getBuffer();
		}
		return content;
	}

}
